/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class ReachabilityForest {
    private static final int FORWARD_NAVIGATION_COST = 1;
    private static final int INVERSE_MANY_NAVIGATION_COST = 5;
    private static final int INVERSE_NAVIGATION_COST = 3;
    private static final int ITERATOR_COST = 1;
    private static final int OPERATION_COST = 10;
    private static final int RESULT_COST = 1;
    private final @NonNull Set<@NonNull NavigableEdge> forwardEdges = new HashSet<NavigableEdge>();
    private final @NonNull Set<@NonNull Edge> manyToOneEdges = new HashSet<Edge>();
    private final @NonNull Map<@NonNull Node, @Nullable Edge> node2reachingEdge = new HashMap<Node, Edge>();
    private @NonNull Map<@NonNull Node, @NonNull Integer> node2cost = new HashMap<Node, Integer>();
    private @Nullable Comparator<@NonNull Edge> edgeCostComparator = null;
    private @Nullable Comparator<@NonNull Node> nodeCostComparator = null;

    public ReachabilityForest(@NonNull Iterable<@NonNull Node> rootNodes, @NonNull Iterable<@NonNull NavigableEdge> availableNavigableEdges) {
        for (Node rootNode : rootNodes) {
            this.node2reachingEdge.put(rootNode, null);
        }
        for (NavigableEdge edge : availableNavigableEdges) {
            this.addEdge(edge);
        }
        this.analyze(this.node2reachingEdge.keySet());
    }

    protected void addEdge(@NonNull NavigableEdge edge) {
        if (!edge.isSecondary()) {
            this.forwardEdges.add(edge);
            if (edge.getEdgeSource().isClass() && edge.getOppositeEdge() == null) {
                this.manyToOneEdges.add((Edge)edge);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void analyze(@NonNull Iterable<@NonNull Node> rootNodes) {
        ArrayList<@Nullable List<@NonNull Node>> costs2nodes = new ArrayList<List<Node>>();
        for (Node rootNode : rootNodes) {
            this.node2cost.put(rootNode, 0);
        }
        costs2nodes.add(Lists.newArrayList(rootNodes));
        int thisCost = 0;
        while (thisCost < costs2nodes.size()) {
            @NonNull List thisCostNodes = (List)costs2nodes.get(thisCost);
            if (thisCostNodes != null) {
                for (Node sourceNode : thisCostNodes) {
                    assert (this.node2cost.get(sourceNode) == thisCost);
                    for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                        Node targetNode = edge.getEdgeTarget();
                        if (this.node2reachingEdge.containsKey(targetNode)) continue;
                        Integer targetCost = this.node2cost.get(targetNode);
                        assert (targetCost == null || thisCost < targetCost);
                        if (edge.isNavigation()) {
                            NavigableEdge navigableEdge = (NavigableEdge)edge;
                            if (this.forwardEdges.contains(navigableEdge)) {
                                int nextCost = thisCost + 1;
                                if (targetCost != null && nextCost >= targetCost) continue;
                                this.node2cost.put(targetNode, nextCost);
                                this.node2reachingEdge.put(targetNode, edge);
                                this.putCosts(costs2nodes, nextCost, targetNode);
                                continue;
                            }
                            NavigableEdge oppositeEdge = navigableEdge.getOppositeEdge();
                            if (this.forwardEdges.contains(oppositeEdge)) {
                                int nextCost = thisCost + 3;
                                if (targetCost != null && nextCost >= targetCost) continue;
                                this.node2cost.put(targetNode, nextCost);
                                this.node2reachingEdge.put(targetNode, (Edge)oppositeEdge);
                                this.putCosts(costs2nodes, nextCost, targetNode);
                                continue;
                            }
                            if (!this.manyToOneEdges.contains(oppositeEdge)) continue;
                            int nextCost = thisCost + 5;
                            if (targetCost != null && nextCost >= targetCost) continue;
                            this.node2cost.put(targetNode, nextCost);
                            this.node2reachingEdge.put(targetNode, (Edge)oppositeEdge);
                            this.putCosts(costs2nodes, nextCost, targetNode);
                            continue;
                        }
                        if (!edge.isComputation()) continue;
                        int nextCost = thisCost + 10;
                        if (targetNode.isOperation()) {
                            for (Edge incomingEdge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                                Node node;
                                Integer cost;
                                if (!incomingEdge.isOld() || !incomingEdge.isComputation() || (cost = this.node2cost.get(node = QVTscheduleUtil.getSourceNode((Edge)incomingEdge))) != null && cost <= thisCost) continue;
                                nextCost = -1;
                                break;
                            }
                        } else {
                            nextCost = targetNode.isIterator() ? thisCost + 1 : thisCost + 1;
                        }
                        if (nextCost <= 0 || targetCost != null && nextCost >= targetCost) continue;
                        this.node2cost.put(targetNode, nextCost);
                        this.node2reachingEdge.put(targetNode, edge);
                        this.putCosts(costs2nodes, nextCost, targetNode);
                    }
                }
            }
            ++thisCost;
        }
    }

    public @Nullable Integer getCost(@NonNull Node node) {
        return this.node2cost.get(node);
    }

    public @NonNull Comparator<@NonNull Edge> getEdgeCostComparator() {
        Comparator<@NonNull Edge> edgeCostComparator2 = this.edgeCostComparator;
        if (edgeCostComparator2 == null) {
            this.edgeCostComparator = edgeCostComparator2 = new Comparator<Edge>(){

                @Override
                public int compare(@NonNull Edge e1, @NonNull Edge e2) {
                    String n2;
                    int d2;
                    Node s1 = QVTscheduleUtil.getSourceNode((Edge)e1);
                    Node t1 = QVTscheduleUtil.getTargetNode((Edge)e1);
                    Node s2 = QVTscheduleUtil.getSourceNode((Edge)e2);
                    Node t2 = QVTscheduleUtil.getTargetNode((Edge)e2);
                    Integer d1s = (Integer)ReachabilityForest.this.node2cost.get(s1);
                    Integer d1t = (Integer)ReachabilityForest.this.node2cost.get(t1);
                    Integer d2s = (Integer)ReachabilityForest.this.node2cost.get(s2);
                    Integer d2t = (Integer)ReachabilityForest.this.node2cost.get(t2);
                    if (!($assertionsDisabled || d1s != null && d1t != null && d2s != null && d2t != null)) {
                        throw new AssertionError();
                    }
                    int d1 = Math.max(d1s, d1t);
                    if (d1 != (d2 = Math.max(d2s, d2t))) {
                        return d1 - d2;
                    }
                    if (d1s != d2s) {
                        return d1s - d2s;
                    }
                    String n1 = e1.getDisplayName();
                    int d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = e2.getDisplayName())));
                    if (d != 0) {
                        return d;
                    }
                    n1 = s1.getDisplayName();
                    d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = s2.getDisplayName())));
                    if (d != 0) {
                        return d;
                    }
                    n1 = t1.getDisplayName();
                    n2 = t2.getDisplayName();
                    d = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
                    return d;
                }
            };
        }
        return edgeCostComparator2;
    }

    public @NonNull Comparator<@NonNull Node> getNodeCostComparator() {
        Comparator<@NonNull Node> nodeCostComparator2 = this.nodeCostComparator;
        if (nodeCostComparator2 == null) {
            this.nodeCostComparator = nodeCostComparator2 = new Comparator<Node>(){

                @Override
                public int compare(@NonNull Node o1, @NonNull Node o2) {
                    Integer c1 = (Integer)ReachabilityForest.this.node2cost.get(o1);
                    Integer c2 = (Integer)ReachabilityForest.this.node2cost.get(o2);
                    if (!($assertionsDisabled || c1 != null && c2 != null)) {
                        throw new AssertionError();
                    }
                    int diff = c1 - c2;
                    if (diff != 0) {
                        return diff;
                    }
                    return ClassUtil.safeCompareTo((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
                }
            };
        }
        return nodeCostComparator2;
    }

    public @NonNull Iterable<@NonNull Node> getPredecessors(@NonNull Node targetNode) {
        HashSet<@NonNull Node> precedingNodes = new HashSet<Node>();
        this.getPredecessors(precedingNodes, targetNode);
        precedingNodes.remove(targetNode);
        return precedingNodes;
    }

    private void getPredecessors(@NonNull Set<@NonNull Node> precedingNodes, @NonNull Node targetNode) {
        if (precedingNodes.add(targetNode)) {
            if (targetNode.isOperation()) {
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)targetNode)) {
                    if (!edge.isComputation()) continue;
                    this.getPredecessors(precedingNodes, edge.getEdgeSource());
                }
            } else {
                Edge parentEdge = this.getReachingEdge(targetNode);
                if (parentEdge != null) {
                    Node sourceNode = parentEdge.getEdgeSource();
                    if (sourceNode == targetNode) {
                        sourceNode = parentEdge.getEdgeTarget();
                    }
                    this.getPredecessors(precedingNodes, sourceNode);
                }
            }
        }
    }

    public @Nullable Edge getReachingEdge(@NonNull Node node) {
        return this.node2reachingEdge.get(node);
    }

    private void putCosts(@NonNull List<@Nullable List<@NonNull Node>> costs2nodes, int cost, @NonNull Node node) {
        while (costs2nodes.size() <= cost) {
            costs2nodes.add(null);
        }
        List<@NonNull Node> nodes = costs2nodes.get(cost);
        if (nodes == null) {
            nodes = new ArrayList<Node>();
            costs2nodes.set(cost, nodes);
        }
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
    }

    public @NonNull String toString() {
        Comparator<@NonNull Node> nodeComparator = this.getNodeCostComparator();
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>(this.node2cost.keySet());
        Collections.sort(nodes, nodeComparator);
        for (Node node : nodes) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(this.node2cost.get(node));
            s.append(": ");
            s.append(node.getName());
            s.append(" : ");
            s.append(this.node2reachingEdge.get(node));
        }
        return s.toString();
    }
}

