/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.CallTreeBuilder;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartition;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;

public class ScheduleAnalysis {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull RootPartition rootPartition;
    protected final @NonNull ScheduledRegion scheduledRegion;
    protected final @NonNull List<@NonNull Region> callableRegions;
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection<?>>> region2incomingConnections = new HashMap();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection<?>>> region2loopingConnections = new HashMap();
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull DatumConnection<?>>> region2outgoingConnections = new HashMap();
    private final @NonNull Map<@NonNull DatumConnection<?>, @NonNull List<@NonNull Region>> connection2sourceRegions = new HashMap();
    private final @NonNull Map<@NonNull DatumConnection<?>, @NonNull List<@NonNull Region>> connection2targetRegions = new HashMap();
    private final @NonNull Map<@NonNull Region, @NonNull Set<@NonNull Region>> target2sources;
    private final @NonNull Map<@NonNull Set<@NonNull Region>, @NonNull Set<@NonNull Region>> cycle2sources;
    private final Map<@NonNull Region, @NonNull Set<@NonNull Region>> region2cycle;
    private final @NonNull Map<@NonNull Region, @NonNull Integer> region2depth;
    private final @NonNull Map<@NonNull Region, @NonNull List<@NonNull Region>> region2parents;
    private final @NonNull Set<@NonNull Region> unpassedRegions = new HashSet<Region>();

    protected ScheduleAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull RootPartition rootPartition) {
        this.scheduleManager = scheduleManager;
        this.rootPartition = rootPartition;
        this.scheduledRegion = rootPartition.getScheduledRegion();
        this.callableRegions = this.analyzeRegions(this.scheduledRegion, new ArrayList<Region>());
        Collections.sort(this.callableRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (Region region : this.callableRegions) {
            this.analyzeConnections(region);
        }
        for (Region region : this.callableRegions) {
            this.analyzeSourcesAndTargets(region);
        }
        this.target2sources = this.analyzeSources();
        this.cycle2sources = this.analyzeCycleSources();
        this.region2cycle = this.analyzeCycleElements();
        this.region2depth = this.analyzeDepths();
        this.region2parents = this.analyzeParents();
    }

    private void analyzeConnections(@NonNull Region region) {
        ArrayList<@NonNull DatumConnection> incomingConnections = new ArrayList<DatumConnection>();
        ArrayList<@NonNull DatumConnection> loopingConnections = new ArrayList<DatumConnection>();
        ArrayList<@NonNull DatumConnection> outgoingConnections = new ArrayList<DatumConnection>();
        for (DatumConnection connection : region.getIncomingConnections()) {
            for (Region sourceRegion : connection.getSourceRegions()) {
                if (region == sourceRegion) {
                    if (loopingConnections.contains(connection)) continue;
                    loopingConnections.add(connection);
                    continue;
                }
                if (incomingConnections.contains(connection)) continue;
                incomingConnections.add(connection);
            }
        }
        for (DatumConnection connection : region.getNextConnections()) {
            for (Region targetRegion : connection.getTargetRegions()) {
                if (region == targetRegion) {
                    assert (loopingConnections.contains(connection));
                    loopingConnections.add(connection);
                    continue;
                }
                if (outgoingConnections.contains(connection)) continue;
                outgoingConnections.add(connection);
            }
        }
        if (outgoingConnections.size() > 1) {
            Collections.sort(outgoingConnections, NameUtil.NAMEABLE_COMPARATOR);
        }
        this.region2incomingConnections.put(region, incomingConnections);
        this.region2loopingConnections.put(region, loopingConnections);
        this.region2outgoingConnections.put(region, outgoingConnections);
    }

    private @NonNull Map<@NonNull Region, @NonNull Set<@NonNull Region>> analyzeCycleElements() {
        HashMap<@NonNull Region, @NonNull Set<@NonNull Region>> region2cycle = new HashMap<Region, Set<Region>>();
        for (Set<Region> cycle : this.cycle2sources.keySet()) {
            for (Region region : cycle) {
                region2cycle.put(region, cycle);
            }
        }
        return region2cycle;
    }

    private @NonNull Map<@NonNull Set<@NonNull Region>, @NonNull Set<@NonNull Region>> analyzeCycleSources() {
        HashMap<@NonNull Set<@NonNull Region>, @NonNull Set<@NonNull Region>> cycle2sources = new HashMap<Set<Region>, Set<Region>>();
        Map<@NonNull Region, @NonNull Set<@NonNull Region>> target2sourcesClosure = CompilerUtil.computeClosure(this.target2sources);
        Map<@NonNull Region, @NonNull Set<@NonNull Region>> source2targetsClosure = CompilerUtil.computeInverseClosure(target2sourcesClosure);
        for (Region region : this.callableRegions) {
            Set<@NonNull Region> sourceRegions = target2sourcesClosure.get(region);
            Set<@NonNull Region> targetRegions = source2targetsClosure.get(region);
            assert (sourceRegions != null && targetRegions != null);
            HashSet<@NonNull Region> cyclicRegions = new HashSet<Region>(sourceRegions);
            cyclicRegions.retainAll(targetRegions);
            if (cyclicRegions.isEmpty() || cycle2sources.containsKey(cyclicRegions)) continue;
            HashSet<@NonNull Region> cycleSources = new HashSet<Region>();
            for (Region cyclicRegion : cyclicRegions) {
                Set<@NonNull Region> sources = this.target2sources.get(cyclicRegion);
                assert (sources != null);
                cycleSources.addAll(sources);
            }
            cycleSources.removeAll(cyclicRegions);
            cycle2sources.put(cyclicRegions, cycleSources);
        }
        return cycle2sources;
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Region, @NonNull Integer> analyzeDepths() {
        HashMap<@NonNull Region, @NonNull Integer> region2depth = new HashMap<Region, Integer>();
        HashSet<@NonNull Region> allRegions = new HashSet<Region>(this.target2sources.keySet());
        HashSet<@NonNull Region> pendingRegions = new HashSet<Region>(allRegions);
        HashSet<@NonNull Set<@NonNull Region>> pendingCycles = new HashSet<Set<Region>>(this.cycle2sources.keySet());
        region2depth.put((Region)this.scheduledRegion, 0);
        int depth = 1;
        while (!pendingRegions.isEmpty()) {
            HashSet targetSourceRegions;
            HashSet<@NonNull K> readyRegions = new HashSet(region2depth.keySet());
            HashSet<@NonNull Region> nowReadyRegions = new HashSet<Region>();
            HashSet<@NonNull @NonNull Set> nowReadyCycles = new HashSet<Set>();
            for (Region region : pendingRegions) {
                targetSourceRegions = new HashSet(this.target2sources.get(region));
                assert (targetSourceRegions != null);
                targetSourceRegions.removeAll(readyRegions);
                if (!targetSourceRegions.isEmpty()) continue;
                nowReadyRegions.add(region);
            }
            for (Set set : pendingCycles) {
                targetSourceRegions = new HashSet(this.cycle2sources.get(set));
                assert (targetSourceRegions != null);
                targetSourceRegions.removeAll(readyRegions);
                if (!targetSourceRegions.isEmpty()) continue;
                nowReadyRegions.addAll(set);
                nowReadyCycles.add(set);
            }
            if (nowReadyRegions.size() > 0) {
                for (Region region : nowReadyRegions) {
                    region2depth.put(region, depth);
                    pendingRegions.remove(region);
                }
                pendingCycles.removeAll(nowReadyCycles);
            } else {
                void var9_14;
                Object var9_13 = null;
                int badSources = Integer.MAX_VALUE;
                for (Region targetElement : pendingRegions) {
                    HashSet<@NonNull E> targetSourceElements = new HashSet(this.target2sources.get(targetElement));
                    assert (targetSourceElements != null);
                    targetSourceElements.removeAll(readyRegions);
                    int targetSourceElementsSize = targetSourceElements.size();
                    if (var9_14 != null && targetSourceElementsSize >= badSources) continue;
                    badSources = targetSourceElementsSize;
                    Region region = targetElement;
                }
                assert (var9_14 != null);
                region2depth.put((Region)var9_14, depth);
                pendingRegions.remove(var9_14);
            }
            ++depth;
        }
        return region2depth;
    }

    private @NonNull Map<@NonNull Region, @NonNull List<@NonNull Region>> analyzeParents() {
        HashMap<@NonNull Region, @NonNull List<@NonNull Region>> region2parents = new HashMap<Region, List<Region>>();
        region2parents.put((Region)this.scheduledRegion, Collections.emptyList());
        for (Region targetRegion : this.callableRegions) {
            HashSet<@NonNull Object> parentSet = new HashSet<Object>();
            Set<@NonNull Region> sourceRegions = this.target2sources.get(targetRegion);
            assert (sourceRegions != null);
            for (Region sourceRegion : sourceRegions) {
                Set<@NonNull Region> sourceCycle = this.region2cycle.get(sourceRegion);
                if (sourceCycle != null) {
                    Set<@NonNull Region> cycleSources = this.cycle2sources.get(sourceCycle);
                    assert (cycleSources != null);
                    parentSet.addAll(cycleSources);
                    continue;
                }
                parentSet.add(sourceRegion);
            }
            if (parentSet.isEmpty()) {
                parentSet.add(this.scheduledRegion);
            }
            ArrayList<@NonNull E> parentList = new ArrayList(parentSet);
            Collections.sort(parentList, NameUtil.NAMEABLE_COMPARATOR);
            region2parents.put(targetRegion, parentList);
        }
        return region2parents;
    }

    private @NonNull List<@NonNull Region> analyzeRegions(@NonNull ScheduledRegion outerScheduledRegion, @NonNull List<@NonNull Region> allCallableRegions) {
        for (Region region : outerScheduledRegion.getCallableRegions()) {
            assert (!region.isOperationRegion());
            assert (!allCallableRegions.contains(region));
            allCallableRegions.add(region);
            if (!(region instanceof ScheduledRegion)) continue;
            ScheduledRegion innerScheduledRegion = (ScheduledRegion)region;
            this.analyzeRegions(innerScheduledRegion, allCallableRegions);
        }
        return allCallableRegions;
    }

    private void analyzeSourcesAndTargets(@NonNull Region region) {
        boolean hasPassedConnection = false;
        for (DatumConnection<?> connection : this.getOutgoingConnections(region)) {
            if (!connection.isPassed()) continue;
            hasPassedConnection = true;
            break;
        }
        if (!hasPassedConnection) {
            this.unpassedRegions.add(region);
        }
        for (DatumConnection<?> connection : this.getIncomingConnections(region)) {
            List<Region> targetRegions;
            List<@NonNull Region> sourceRegions = this.connection2sourceRegions.get(connection);
            if (sourceRegions == null) {
                sourceRegions = new ArrayList<Region>();
                for (Region sourceRegion : connection.getSourceRegions()) {
                    if (sourceRegions.contains(sourceRegion)) continue;
                    sourceRegions.add(sourceRegion);
                }
                this.connection2sourceRegions.put(connection, sourceRegions);
            }
            if ((targetRegions = this.connection2targetRegions.get(connection)) != null) continue;
            targetRegions = new ArrayList<Region>();
            for (Region targetRegion : connection.getTargetRegions()) {
                if (targetRegions.contains(targetRegion)) continue;
                targetRegions.add(targetRegion);
            }
            this.connection2targetRegions.put(connection, targetRegions);
        }
    }

    private @NonNull Map<@NonNull Region, @NonNull Set<@NonNull Region>> analyzeSources() {
        HashMap<@NonNull Region, @NonNull Set<@NonNull Region>> target2sources = new HashMap<Region, Set<Region>>();
        for (Region region : this.callableRegions) {
            target2sources.put(region, new HashSet());
        }
        for (Region region : this.callableRegions) {
            HashSet<@NonNull Region> sources = new HashSet<Region>();
            target2sources.put(region, sources);
            List<@NonNull DatumConnection<?>> incomingConnections = this.region2incomingConnections.get(region);
            assert (incomingConnections != null);
            for (DatumConnection<?> incomingConnection : incomingConnections) {
                List<@NonNull Region> sourceRegions = this.connection2sourceRegions.get(incomingConnection);
                assert (sourceRegions != null);
                sources.addAll(sourceRegions);
            }
        }
        return target2sources;
    }

    protected void buildCallTree() {
        CallTreeBuilder callTreeBuilder = new CallTreeBuilder(this);
        callTreeBuilder.buildTree(this.scheduledRegion, (Iterable<? extends Iterable<Region>>)this.rootPartition.getRegionSchedule());
    }

    public Region getCommonRegion(@NonNull Region firstRegion, @NonNull Region secondRegion) {
        Region thisRegion = firstRegion;
        Region thatRegion = secondRegion;
        while (thisRegion != thatRegion) {
            int thatDepth;
            int thisDepth = this.getRegionDepth(thisRegion);
            if (thisDepth > (thatDepth = this.getRegionDepth(thatRegion))) {
                if ((thisRegion = this.getMinimumDepthParentRegion(thisRegion)) != null) continue;
                return null;
            }
            if (thatDepth > thisDepth) {
                if ((thatRegion = this.getMinimumDepthParentRegion(thatRegion)) != null) continue;
                return null;
            }
            thisRegion = this.getMinimumDepthParentRegion(thisRegion);
            thatRegion = this.getMinimumDepthParentRegion(thatRegion);
            if (thisRegion != null && thatRegion != null) continue;
            return null;
        }
        return thisRegion;
    }

    protected @NonNull Iterable<? extends @NonNull DatumConnection<?>> getConnections() {
        return this.connection2targetRegions.keySet();
    }

    protected @NonNull Iterable<@NonNull DatumConnection<?>> getIncomingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection<?>> incomingConnections = this.region2incomingConnections.get(region);
        assert (incomingConnections != null);
        return incomingConnections;
    }

    protected @NonNull Iterable<@NonNull DatumConnection<?>> getLoopingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection<?>> loopingConnections = this.region2loopingConnections.get(region);
        assert (loopingConnections != null);
        return loopingConnections;
    }

    public Region getMinimumDepthParentRegion(@NonNull Region childRegion) {
        Region minimumDepthParentRegion = null;
        int minimumDepth = Integer.MAX_VALUE;
        List<@NonNull Region> parentRegions = this.region2parents.get(childRegion);
        assert (parentRegions != null);
        for (Region parentRegion : parentRegions) {
            int parentDepth = this.getRegionDepth(parentRegion);
            if (minimumDepthParentRegion != null && parentDepth >= minimumDepth) continue;
            minimumDepthParentRegion = parentRegion;
            minimumDepth = parentDepth;
        }
        return minimumDepthParentRegion;
    }

    protected @NonNull Iterable<@NonNull DatumConnection<?>> getOutgoingConnections(@NonNull Region region) {
        List<@NonNull DatumConnection<?>> outgoingConnections = this.region2outgoingConnections.get(region);
        assert (outgoingConnections != null);
        return outgoingConnections;
    }

    private int getRegionDepth(@NonNull Region region) {
        Integer depth = this.region2depth.get(region);
        assert (depth != null);
        return depth;
    }

    protected @NonNull Iterable<@NonNull Region> getSourceRegions(@NonNull DatumConnection<?> connection) {
        List<@NonNull Region> sourceRegions = this.connection2sourceRegions.get(connection);
        assert (sourceRegions != null);
        return sourceRegions;
    }

    protected @NonNull Iterable<@NonNull Region> getTargetRegions(@NonNull DatumConnection<?> connection) {
        List<@NonNull Region> targetRegions = this.connection2targetRegions.get(connection);
        assert (targetRegions != null);
        return targetRegions;
    }

    protected boolean isPassed(@NonNull Region region) {
        return !this.unpassedRegions.contains(region);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void propagateIndexes(@NonNull DatumConnection<?> connection) {
        @NonNull List connectionIndexes = connection.getIndexes();
        if (connectionIndexes.size() > 0) {
            for (Region region : this.getTargetRegions(connection)) {
                int invocationIndex = region.getInvocationIndex();
                boolean propagateThroughRegion = false;
                Iterator iterator = connectionIndexes.iterator();
                while (iterator.hasNext()) {
                    int connectionIndex = (Integer)iterator.next();
                    if (connectionIndex <= invocationIndex || !region.addIndex(connectionIndex)) continue;
                    propagateThroughRegion = true;
                }
                if (!propagateThroughRegion) continue;
                Iterable<@NonNull DatumConnection<?>> outgoingConnections = this.getOutgoingConnections(region);
                for (DatumConnection<?> targetConnection : outgoingConnections) {
                    boolean propagateThroughConnection = false;
                    Iterator iterator2 = connectionIndexes.iterator();
                    while (iterator2.hasNext()) {
                        int connectionIndex = (Integer)iterator2.next();
                        if (!targetConnection.addIndex(connectionIndex)) continue;
                        propagateThroughConnection = true;
                    }
                    if (!propagateThroughConnection) continue;
                    this.propagateIndexes(targetConnection);
                }
            }
        }
    }

    public void schedule(@NonNull RootPartition rootPartition) {
        int depth = 0;
        for (Collection<Region> collection : rootPartition.getRegionSchedule()) {
            for (Region region : collection) {
                region.addIndex(depth);
                Iterable<@NonNull DatumConnection<?>> loopingConnections = this.getLoopingConnections(region);
                assert (loopingConnections != null);
                Iterable<@NonNull DatumConnection<?>> outgoingConnections = this.getOutgoingConnections(region);
                assert (outgoingConnections != null);
                for (DatumConnection<?> loopingConnection : loopingConnections) {
                    loopingConnection.addIndex(depth);
                }
                for (DatumConnection<?> outgoingConnection : outgoingConnections) {
                    outgoingConnection.addIndex(depth);
                }
            }
            ++depth;
        }
        this.scheduleManager.writeDebugGraphs("6-indexed", false, true, true);
        for (DatumConnection datumConnection : this.getConnections()) {
            this.propagateIndexes(datumConnection);
        }
        this.buildCallTree();
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull Region> list = new ArrayList<Region>(this.region2depth.keySet());
        Collections.sort(list, NameUtil.NAMEABLE_COMPARATOR);
        for (Region entry : list) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(this.region2depth.get(entry) + " : " + entry.getName());
        }
        return s.toString();
    }
}

