/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.InternallyAcyclicPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class CyclicPartitionsAnalysis {
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull Iterable<@NonNull Partition> leafPartitions;
    protected final @NonNull Map<@NonNull Partition, @NonNull CyclicPartition> partition2cyclicPartition = new HashMap<Partition, CyclicPartition>();
    protected final @NonNull Map<@NonNull TraceClassAnalysis<@NonNull Partition>, @NonNull CyclicPartition> traceClassAnalysis2cyclicPartition = new HashMap<TraceClassAnalysis<Partition>, CyclicPartition>();

    public CyclicPartitionsAnalysis(@NonNull TransformationPartitioner transformationPartitioner, @NonNull Iterable<@NonNull Partition> leafPartitions) {
        this.transformationPartitioner = transformationPartitioner;
        this.leafPartitions = leafPartitions;
    }

    public @NonNull RootPartition analyze() {
        Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> leafPartition2predecessors = CompilerUtil.computeTransitivePredecessors(this.leafPartitions);
        Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> leafPartition2successors = CompilerUtil.computeTransitiveSuccessors(leafPartition2predecessors);
        HashSet<@NonNull Set<@NonNull Partition>> intersections = new HashSet<Set<Partition>>();
        for (Partition leafPartition : this.leafPartitions) {
            HashSet<@NonNull E> intersection = new HashSet(leafPartition2predecessors.get(leafPartition));
            intersection.retainAll((Collection)leafPartition2successors.get(leafPartition));
            if (intersection.isEmpty()) continue;
            intersections.add(intersection);
        }
        if (intersections.isEmpty()) {
            Set<@NonNull TraceClassAnalysis<@NonNull Partition>> cyclicTraceClassAnalyses = this.computeTraceClassAnalysisDependencies(this.leafPartitions);
            Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> cyclicTracePropertyAnalyses = this.computeTracePropertyAnalysisDependencies(this.leafPartitions);
            String rootName = "\u00abroot\u00bb";
            return new RootPartition(rootName, leafPartition2predecessors, cyclicTraceClassAnalyses, cyclicTracePropertyAnalyses);
        }
        intersections.add(Sets.newHashSet(this.leafPartitions));
        return this.createAcyclicPartitionHierarchy(intersections, leafPartition2predecessors);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull TraceClassAnalysis<@NonNull Partition>> computeTraceClassAnalysisDependencies(@NonNull Iterable<@NonNull Partition> nestedPartitions) {
        HashSet<@NonNull @NonNull E> consumedTraceClassAnalyses = new HashSet();
        HashSet<@NonNull @NonNull E> superProducedTraceClassAnalyses = new HashSet();
        for (Partition nestedPartition : nestedPartitions) {
            Iterable superProducedTraceClassAnalyses2;
            Iterable<@NonNull TraceClassAnalysis<@NonNull RA>> consumedTraceClassAnalyses2 = nestedPartition.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses2 != null) {
                Iterables.addAll(consumedTraceClassAnalyses, consumedTraceClassAnalyses2);
            }
            if ((superProducedTraceClassAnalyses2 = nestedPartition.getSuperProducedTraceClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedTraceClassAnalyses, superProducedTraceClassAnalyses2);
        }
        HashSet<@NonNull TraceClassAnalysis<@NonNull Partition>> cyclicTraceClassAnalyses = new HashSet<TraceClassAnalysis<Partition>>(consumedTraceClassAnalyses);
        cyclicTraceClassAnalyses.retainAll(superProducedTraceClassAnalyses);
        return cyclicTraceClassAnalyses;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> computeTracePropertyAnalysisDependencies(@NonNull Iterable<@NonNull Partition> nestedPartitions) {
        HashSet<@NonNull @NonNull E> consumedTracePropertyAnalyses = new HashSet();
        HashSet<@NonNull @NonNull E> producedTracePropertyAnalyses = new HashSet();
        for (Partition nestedPartition : nestedPartitions) {
            Iterable producedTracePropertyAnalyses2;
            Iterable<@NonNull TracePropertyAnalysis<@NonNull RA>> consumedTracePropertyAnalyses2 = nestedPartition.getConsumedTracePropertyAnalyses();
            if (consumedTracePropertyAnalyses2 != null) {
                Iterables.addAll(consumedTracePropertyAnalyses, consumedTracePropertyAnalyses2);
            }
            if ((producedTracePropertyAnalyses2 = nestedPartition.getProducedTracePropertyAnalyses()) == null) continue;
            Iterables.addAll(producedTracePropertyAnalyses, producedTracePropertyAnalyses2);
        }
        HashSet<@NonNull TracePropertyAnalysis<@NonNull Partition>> cyclicTracePropertyAnalyses = new HashSet<TracePropertyAnalysis<Partition>>(consumedTracePropertyAnalyses);
        cyclicTracePropertyAnalyses.retainAll(producedTracePropertyAnalyses);
        return cyclicTracePropertyAnalyses;
    }

    /*
     * Could not resolve type clashes
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull RootPartition createAcyclicPartitionHierarchy(@NonNull Iterable<@NonNull Set<@NonNull Partition>> partitionings, @NonNull Map<@NonNull Partition, @NonNull Set<@NonNull Partition>> partition2predecessors) {
        @NonNull @NonNull ArrayList sortedPartitionings = Lists.newArrayList(partitionings);
        Collections.sort(sortedPartitionings, QVTbaseUtil.CollectionSizeComparator.INSTANCE);
        ArrayList<@NonNull InternallyAcyclicPartition> acyclicPartitionHierarchy = new ArrayList<InternallyAcyclicPartition>();
        int iMax = sortedPartitionings.size();
        assert (iMax >= 2);
        assert (((Set)sortedPartitionings.get(iMax - 1)).equals(Sets.newHashSet(this.leafPartitions)));
        int i = 0;
        while (i < iMax - 1) {
            CyclicPartition oldCycleAnalysis;
            @NonNull Set nestedPartitioning = (Set)sortedPartitionings.get(i);
            String cycleName = "\u00abcycle-" + i + "\u00bb";
            Set<@NonNull TraceClassAnalysis<@NonNull Partition>> cyclicTraceClassAnalyses = this.computeTraceClassAnalysisDependencies(nestedPartitioning);
            Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> cyclicTracePropertyAnalyses = this.computeTracePropertyAnalysisDependencies(nestedPartitioning);
            CyclicPartition nestedCyclicPartition = new CyclicPartition(this.transformationPartitioner, cycleName, this, nestedPartitioning, partition2predecessors, cyclicTraceClassAnalyses, cyclicTracePropertyAnalyses);
            acyclicPartitionHierarchy.add(nestedCyclicPartition);
            for (Partition nestedPartition : nestedPartitioning) {
                oldCycleAnalysis = this.partition2cyclicPartition.put(nestedPartition, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
                partition2predecessors.remove(nestedPartition);
            }
            partition2predecessors.put(nestedCyclicPartition, (Set<Partition>)nestedCyclicPartition.getExplicitPredecessors());
            for (TraceClassAnalysis cyclicTraceClassAnalysis : cyclicTraceClassAnalyses) {
                oldCycleAnalysis = this.traceClassAnalysis2cyclicPartition.put(cyclicTraceClassAnalysis, nestedCyclicPartition);
                assert (oldCycleAnalysis == null);
            }
            int j = i + 1;
            while (j < iMax) {
                @NonNull Set nestingPartitioning = (Set)sortedPartitionings.get(j);
                int oldSize = nestingPartitioning.size();
                if (nestingPartitioning.removeAll(nestedPartitioning)) {
                    int newSize = nestingPartitioning.size();
                    assert (oldSize - newSize == nestedPartitioning.size());
                    nestingPartitioning.add(nestedCyclicPartition);
                }
                ++j;
            }
            for (Partition partition : partition2predecessors.keySet()) {
                Set<@NonNull Partition> predecessors = partition2predecessors.get(partition);
                assert (predecessors != null);
                int oldSize = predecessors.size();
                if (!predecessors.removeAll(nestedPartitioning)) continue;
                int newSize = predecessors.size();
                assert (oldSize - newSize == nestedPartitioning.size());
                predecessors.add(nestedCyclicPartition);
            }
            ++i;
        }
        @NonNull Set rootPartitioning = (Set)sortedPartitionings.get(iMax - 1);
        Set<@NonNull TraceClassAnalysis<@NonNull Partition>> rootTraceClassAnalyses = this.computeTraceClassAnalysisDependencies(rootPartitioning);
        Set<@NonNull TracePropertyAnalysis<@NonNull Partition>> rootTracePropertyAnalyses = this.computeTracePropertyAnalysisDependencies(rootPartitioning);
        String rootName = "\u00abroot\u00bb";
        RootPartition rootPartition = new RootPartition(rootName, partition2predecessors, rootTraceClassAnalyses, rootTracePropertyAnalyses);
        acyclicPartitionHierarchy.add(rootPartition);
        if (TransformationPartitioner.CYCLES.isActive()) {
            this.showCycles(acyclicPartitionHierarchy);
        }
        return rootPartition;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void showCycles(@NonNull Iterable<@NonNull InternallyAcyclicPartition> cyclicPartitions) {
        if (Iterables.isEmpty(cyclicPartitions)) {
            TransformationPartitioner.CYCLES.println("No cycles");
        } else {
            for (InternallyAcyclicPartition cyclicPartition : cyclicPartitions) {
                StringBuilder s = new StringBuilder();
                s.append("\n  Partitions:");
                @NonNull ArrayList partitions2 = Lists.newArrayList(cyclicPartition.getPartitions());
                Collections.sort(partitions2, NameUtil.NAMEABLE_COMPARATOR);
                for (Partition partition : partitions2) {
                    Iterable producedTracePropertyAnalyses;
                    Iterable consumedTracePropertyAnalyses;
                    Iterable producedTraceClassAnalyses;
                    s.append("\n\t" + partition);
                    Iterable consumedTraceClassAnalyses = partition.getConsumedTraceClassAnalyses();
                    if (consumedTraceClassAnalyses != null) {
                        Iterator iterator = consumedTraceClassAnalyses.iterator();
                        while (iterator.hasNext()) {
                            @NonNull @NonNull TraceClassAnalysis traceClassAnalysis = (TraceClassAnalysis)iterator.next();
                            s.append("\n\t  =>" + traceClassAnalysis);
                        }
                    }
                    if ((producedTraceClassAnalyses = partition.getProducedTraceClassAnalyses()) != null) {
                        for (TraceClassAnalysis traceClassAnalysis : producedTraceClassAnalyses) {
                            s.append("\n\t  <=" + traceClassAnalysis);
                        }
                    }
                    if ((consumedTracePropertyAnalyses = partition.getConsumedTracePropertyAnalyses()) != null) {
                        for (TracePropertyAnalysis tracePropertyAnalysis : consumedTracePropertyAnalyses) {
                            s.append("\n\t  =>" + tracePropertyAnalysis);
                        }
                    }
                    if ((producedTracePropertyAnalyses = partition.getProducedTracePropertyAnalyses()) == null) continue;
                    for (TracePropertyAnalysis tracePropertyAnalysis : producedTracePropertyAnalyses) {
                        s.append("\n\t  <=" + tracePropertyAnalysis);
                    }
                }
                s.append("\n  TraceClassAnalyses:");
                @NonNull @NonNull ArrayList traceClassAnalyses = Lists.newArrayList(cyclicPartition.getTraceClassAnalyses());
                Collections.sort(traceClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (TraceClassAnalysis traceClassAnalysis : traceClassAnalyses) {
                    s.append("\n\t" + traceClassAnalysis);
                }
                s.append("\n  TracePropertyAnalyses:");
                @NonNull @NonNull ArrayList tracePropertyAnalyses = Lists.newArrayList(cyclicPartition.getTracePropertyAnalyses());
                Collections.sort(tracePropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
                for (TracePropertyAnalysis tracePropertyAnalysis : tracePropertyAnalyses) {
                    s.append("\n\t" + tracePropertyAnalysis);
                }
                TransformationPartitioner.CYCLES.println(s.toString());
            }
        }
    }
}

