/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.ui.launching.DirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public abstract class QVTDirectionalMainTab<TX extends Transformation>
extends DirectionalMainTab<TX> {
    private void gatherOutputModels(@NonNull List<@NonNull TypedModel> outputModels, @NonNull TypedModel typedModel) {
        if (!outputModels.contains(typedModel)) {
            outputModels.add(typedModel);
            for (TypedModel anotherTypedModel : QVTbaseUtil.getDependsOns((TypedModel)typedModel)) {
                this.gatherOutputModels(outputModels, anotherTypedModel);
            }
        }
    }

    @Override
    protected void updateDirection(@NonNull TX transformation) {
        HashSet<@NonNull String> enforceableDirectionNames = new HashSet<String>();
        for (TypedModel typedModel : QVTbaseUtil.getEnforceableTypedModels(transformation)) {
            String name = typedModel.getName();
            if (name == null) continue;
            enforceableDirectionNames.add(name);
        }
        this.setDirections(enforceableDirectionNames);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected void updateGroups(@NonNull TX transformation, @NonNull Map<@NonNull String, @Nullable String> oldInputsMap, @NonNull Map<@NonNull String, @Nullable String> newInputsMap, @NonNull Map<@NonNull String, @Nullable String> oldOutputsMap, @NonNull Map<@NonNull String, @Nullable String> newOutputsMap, @NonNull Map<@NonNull String, @Nullable String> intermediateMap) {
        super.updateGroups(transformation, oldInputsMap, newInputsMap, oldOutputsMap, newOutputsMap, intermediateMap);
        HashSet<@NonNull TypedModel> inputs = new HashSet<TypedModel>();
        HashSet<@NonNull TypedModel> outputs = new HashSet<TypedModel>();
        String directionName = this.directionCombo.getText();
        ArrayList<@NonNull TypedModel> inputModels = new ArrayList<TypedModel>();
        ArrayList<@NonNull TypedModel> outputModels = new ArrayList<TypedModel>();
        @NonNull Iterable modelParameters = QVTbaseUtil.getModelParameters(transformation);
        TypedModel traceModel = QVTbaseUtil.basicGetTraceTypedModel((Iterable)modelParameters);
        for (TypedModel typedModel : modelParameters) {
            if (typedModel == traceModel || !ClassUtil.safeEquals((Object)typedModel.getName(), (Object)directionName)) continue;
            this.gatherOutputModels(outputModels, typedModel);
        }
        for (TypedModel typedModel : modelParameters) {
            if (typedModel == traceModel || outputModels.contains(typedModel)) continue;
            inputModels.add(typedModel);
        }
        String modeName = this.modeCombo.getText();
        if ("CHECK".equals(modeName)) {
            String name;
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)inputModel);
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)outputModel);
                oldOutputsMap.put(name, null);
            }
            if (traceModel != null) {
                newOutputsMap.put(QVTbaseUtil.getTraceName((TypedModel)traceModel), null);
            }
        } else if ("ENFORCE - CREATE".equals(modeName)) {
            String name;
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)inputModel);
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)outputModel);
                newOutputsMap.put(name, null);
            }
            if (traceModel != null) {
                newOutputsMap.put(QVTbaseUtil.getTraceName((TypedModel)traceModel), null);
            }
        } else if ("ENFORCE - UPDATE".equals(modeName)) {
            String name;
            for (TypedModel inputModel : inputModels) {
                if (!inputs.add(inputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)inputModel);
                oldInputsMap.put(name, null);
                newInputsMap.put(name, null);
            }
            for (TypedModel outputModel : outputModels) {
                if (!outputs.add(outputModel)) continue;
                name = QVTbaseUtil.getName((NamedElement)outputModel);
                oldOutputsMap.put(name, null);
                newOutputsMap.put(name, null);
            }
            if (traceModel != null) {
                String traceName = QVTbaseUtil.getTraceName((TypedModel)traceModel);
                oldInputsMap.put(traceName, null);
                newOutputsMap.put(traceName, null);
            }
        }
    }
}

