/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;

public class LegacyContentsAnalysis {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ContentsAnalysis<@NonNull RuleRegion> contentsAnalysis;
    private final @NonNull AbstractTransformationAnalysis transformationAnalysis;

    public LegacyContentsAnalysis(@NonNull ScheduleManager scheduleManager) {
        this.scheduleManager = scheduleManager;
        this.contentsAnalysis = new ContentsAnalysis(scheduleManager);
        Iterable<@NonNull AbstractTransformationAnalysis> transformationAnalyses = scheduleManager.getTransformationAnalyses();
        assert (Iterables.size(transformationAnalyses) == 1);
        this.transformationAnalysis = transformationAnalyses.iterator().next();
    }

    public void addRegion(@NonNull RuleRegion ruleRegion) {
        this.contentsAnalysis.addRegion(ruleRegion);
    }

    public @NonNull Iterable<@NonNull RuleRegion> getConsumingRegions(@NonNull ClassDatum classDatum) {
        Iterable<@NonNull RuleRegion> legacyConsumingRegions = this.contentsAnalysis.getConsumingRegions(classDatum);
        TraceClassRegionAnalysis traceClassAnalysis = this.transformationAnalysis.basicGetTraceClassAnalysis(classDatum);
        HashSet<@NonNull RuleRegion> consumingRegions = new HashSet<RuleRegion>();
        if (traceClassAnalysis != null) {
            for (TraceClassRegionAnalysis subTraceClassAnalysis : traceClassAnalysis.getSubTraceClassAnalyses()) {
                for (RegionAnalysis regionAnalysis : subTraceClassAnalysis.getConsumers()) {
                    consumingRegions.add((RuleRegion)regionAnalysis.getRegion());
                }
            }
        }
        if (!Sets.newHashSet(legacyConsumingRegions).equals(consumingRegions) && !this.scheduleManager.isInput(classDatum.getReferredTypedModel())) {
            legacyConsumingRegions = this.contentsAnalysis.getConsumingRegions(classDatum);
            traceClassAnalysis = this.transformationAnalysis.basicGetTraceClassAnalysis(classDatum);
            if (traceClassAnalysis != null) {
                for (TraceClassRegionAnalysis subTraceClassAnalysis : traceClassAnalysis.getSubTraceClassAnalyses()) {
                    for (RegionAnalysis regionAnalysis : subTraceClassAnalysis.getConsumers()) {
                        consumingRegions.add((RuleRegion)regionAnalysis.getRegion());
                    }
                }
            }
            System.err.println("Inconsistent " + classDatum + " consumingRegions");
        }
        return consumingRegions;
    }

    public @NonNull Iterable<@NonNull RuleRegion> getProducingRegions(@NonNull ClassDatum classDatum) {
        Iterable<@NonNull RuleRegion> legacyProducingRegions = this.contentsAnalysis.getProducingRegions(classDatum);
        TraceClassRegionAnalysis traceClassAnalysis = this.transformationAnalysis.basicGetTraceClassAnalysis(classDatum);
        HashSet<@NonNull RuleRegion> producingRegions = new HashSet<RuleRegion>();
        if (traceClassAnalysis != null) {
            for (TraceClassRegionAnalysis subTraceClassAnalysis : traceClassAnalysis.getSubTraceClassAnalyses()) {
                for (RegionAnalysis regionAnalysis : subTraceClassAnalysis.getProducers()) {
                    producingRegions.add((RuleRegion)regionAnalysis.getRegion());
                }
            }
        }
        if (!Sets.newHashSet(legacyProducingRegions).equals(producingRegions)) {
            legacyProducingRegions = this.contentsAnalysis.getProducingRegions(classDatum);
            traceClassAnalysis = this.transformationAnalysis.basicGetTraceClassAnalysis(classDatum);
            if (traceClassAnalysis != null) {
                for (TraceClassRegionAnalysis subTraceClassAnalysis : traceClassAnalysis.getSubTraceClassAnalyses()) {
                    for (RegionAnalysis regionAnalysis : subTraceClassAnalysis.getProducers()) {
                        producingRegions.add((RuleRegion)regionAnalysis.getRegion());
                    }
                }
            }
            assert (producingRegions.containsAll(Sets.newHashSet(legacyProducingRegions)));
            System.err.println("Inconsistent " + classDatum + " producingRegions");
            assert (false);
        }
        return producingRegions;
    }

    public Iterable<@NonNull Node> getOldNodes(@NonNull ClassDatum classDatum) {
        return this.contentsAnalysis.getOldNodes(classDatum);
    }

    public @Nullable String dumpClass2newNode() {
        return this.contentsAnalysis.dumpClass2newNode();
    }

    public @Nullable String dumpClass2oldNode() {
        return this.contentsAnalysis.dumpClass2oldNode();
    }

    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatum classDatum) {
        Iterable<@NonNull Node> legacyNewNodes = this.contentsAnalysis.getNewNodes(classDatum);
        TraceClassRegionAnalysis traceClassAnalysis = this.transformationAnalysis.basicGetTraceClassAnalysis(classDatum);
        HashSet<@NonNull RuleRegion> producingRegions = new HashSet<RuleRegion>();
        if (traceClassAnalysis != null) {
            for (TraceClassRegionAnalysis subTraceClassAnalysis : traceClassAnalysis.getSubTraceClassAnalyses()) {
                for (RegionAnalysis regionAnalysis : subTraceClassAnalysis.getProducers()) {
                    producingRegions.add((RuleRegion)regionAnalysis.getRegion());
                }
            }
        }
        return legacyNewNodes;
    }

    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatum classDatum) {
        return this.contentsAnalysis.getNewEdges(edge, classDatum);
    }
}

