/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TracePropertyPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.Role;

public abstract class AbstractPartitionAnalysis<P extends Partition>
implements PartitionAnalysis {
    protected final @NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull P partition;

    protected AbstractPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull P partition) {
        this.partitionedTransformationAnalysis = partitionedTransformationAnalysis;
        this.scheduleManager = partitionedTransformationAnalysis.getScheduleManager();
        this.partition = partition;
    }

    @Override
    public void addEnforcedEdge(@NonNull NavigableEdge realizedEdge) {
    }

    public void analyzePartition() {
    }

    public void analyzePartition2() {
    }

    @Override
    public void analyzePartitionEdges() {
    }

    @Override
    public void computeCheckedOrEnforcedEdges() {
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getConsumedTraceClassAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getConsumedTracePropertyAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Set<@NonNull PartitionAnalysis> getExplicitPredecessors() {
        return null;
    }

    public @NonNull String getName() {
        return this.partition.getName();
    }

    public @NonNull P getPartition() {
        return this.partition;
    }

    @Override
    public @NonNull PartitionedTransformationAnalysis getPartitionedTransformationAnalysis() {
        return this.partitionedTransformationAnalysis;
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getProducedTraceClassAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Iterable<@NonNull TracePropertyPartitionAnalysis> getProducedTracePropertyAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Iterable<@NonNull TraceClassPartitionAnalysis> getSuperProducedTraceClassAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Iterable<@NonNull TraceClassPartitionAnalysis> getTraceClassAnalyses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Iterable<@NonNull TracePropertyPartitionAnalysis> getTracePropertyAnalyses() {
        throw new UnsupportedOperationException();
    }

    public @NonNull List<@NonNull Node> getTraceNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isChecked(@NonNull Edge edge) {
        Role role = this.partition.getRole(edge);
        assert (role != null);
        return role.isChecked();
    }

    public String toString() {
        return this.partition.toString();
    }
}

