/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibPackage;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractObjectManager;
import org.eclipse.qvtd.runtime.evaluation.AbstractSlotState;
import org.eclipse.qvtd.runtime.evaluation.AbstractTransformer;
import org.eclipse.qvtd.runtime.evaluation.Execution;
import org.eclipse.qvtd.runtime.evaluation.Invocation;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.SlotState;
import org.eclipse.qvtd.runtime.internal.evaluation.IncrementalInvocationManager;

public class IncrementalObjectManager
extends AbstractObjectManager {
    private Map<@NonNull Object, @NonNull Map<@NonNull EStructuralFeature, @NonNull BasicSlotState>> object2feature2slotState = new HashMap<Object, Map<EStructuralFeature, BasicSlotState>>();

    public IncrementalObjectManager(@NonNull IncrementalInvocationManager invocationManager) {
        super(invocationManager);
    }

    @Override
    public synchronized void assigned(@NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        Map<EStructuralFeature, BasicSlotState> objectState;
        BasicSlotState slotState;
        assert (eFeature != null);
        if (this.debugAssignments) {
            boolean isOpposite = false;
            StringBuilder s = new StringBuilder();
            s.append("assigned ");
            s.append(IncrementalObjectManager.toDebugString(eObject));
            s.append(".");
            s.append(isOpposite ? "~" : "");
            s.append(eFeature.getName());
            s.append(" := ");
            if (ecoreValue instanceof EObject) {
                s.append(IncrementalObjectManager.toDebugString(ecoreValue));
            } else {
                s.append(LabelUtil.getLabel((Object)ecoreValue));
            }
            AbstractTransformer.ASSIGNMENTS.println(s.toString());
        }
        if ((slotState = (objectState = this.getObjectState(eObject)).get(eFeature)) != null) {
            slotState.assigned(eObject, eFeature, ecoreValue);
        } else {
            if (eFeature instanceof EAttribute) {
                slotState = new SimpleSlotState(eObject, eFeature, ecoreValue);
            } else {
                EReference eReference = (EReference)eFeature;
                EReference eOppositeReference = eReference.getEOpposite();
                if (eOppositeReference != null) {
                    if (eReference.isMany()) {
                        assert (ecoreValue != null);
                        slotState = eOppositeReference.isMany() ? this.createManyToManySlotState(eObject, eReference, eOppositeReference) : this.createOneToManyAggregatorSlotState(eObject, eReference, eOppositeReference, ecoreValue);
                    } else if (ecoreValue != null && eOppositeReference.isMany()) {
                        slotState = this.createOneToManyElementSlotState(eObject, eReference, eOppositeReference, ecoreValue);
                    }
                } else if (eReference.isContainment()) {
                    assert (ecoreValue != null);
                    eOppositeReference = OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER;
                    assert (eOppositeReference != null);
                    if (eReference.isMany()) {
                        slotState = this.createOneToManyAggregatorSlotState(eObject, eReference, eOppositeReference, ecoreValue);
                    } else {
                        Map<EStructuralFeature, BasicSlotState> oppositeObjectState = this.getObjectState(ecoreValue);
                        slotState = oppositeObjectState.get(eOppositeReference);
                        if (slotState != null) {
                            slotState.assigned(ecoreValue, (EStructuralFeature)eOppositeReference, eObject);
                        } else {
                            slotState = this.createOneToOneSlotState(eObject, eReference, eOppositeReference, ecoreValue);
                        }
                    }
                } else {
                    slotState = new SimpleSlotState(eObject, eFeature, ecoreValue);
                }
            }
            objectState.put(eFeature, slotState);
        }
    }

    @Override
    public void assigned(@NonNull Invocation.Incremental invocation, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        this.assigned(eObject, eFeature, ecoreValue);
        assert (eFeature != null);
        BasicSlotState slotState = this.getSlotState(eObject, eFeature);
        invocation.addWriteSlot(slotState);
    }

    public @Nullable Map<@NonNull EStructuralFeature, @NonNull BasicSlotState> basicGetObjectState(@NonNull Object eObject) {
        return this.object2feature2slotState.get(eObject);
    }

    public @Nullable BasicSlotState basicGetSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        assert (eFeature != null);
        Map<EStructuralFeature, BasicSlotState> objectState = this.basicGetObjectState(eObject);
        if (objectState == null) {
            return null;
        }
        return objectState.get(eFeature);
    }

    @NonNull BasicSlotState createManyToManySlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature) {
        throw new UnsupportedOperationException();
    }

    @NonNull BasicSlotState createOneToManyAggregatorSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @Nullable Object eContents) {
        return new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eFeature, eContents);
    }

    @NonNull BasicSlotState createOneToManyElementSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @NonNull Object eAggregator) {
        OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)this.getSlotState(eAggregator, (EStructuralFeature)eOppositeFeature);
        aggregatorSlotState.assignedElement(eAggregator, eOppositeFeature, eObject);
        return new OneToManyElementSlotState(eObject, eFeature, eAggregator);
    }

    <G, S> @NonNull BasicSlotState createOneToOneSlotState(@NonNull Object eObject, @NonNull EReference eFeature, @NonNull EReference eOppositeFeature, @Nullable Object eOpposite) {
        BasicSlotState slotState;
        Map<EStructuralFeature, BasicSlotState> oppositeObjectState = null;
        if (eOpposite != null && (slotState = (oppositeObjectState = this.getObjectState(eOpposite)).get(eOppositeFeature)) != null) {
            return slotState;
        }
        slotState = new OneToOneSlotState(eObject, eFeature, eOpposite);
        if (oppositeObjectState != null) {
            oppositeObjectState.put((EStructuralFeature)eOppositeFeature, slotState);
        }
        return slotState;
    }

    @Override
    public void created(@NonNull Invocation.Incremental invocation, @NonNull Object eObject) {
        invocation.addCreatedObject(eObject);
    }

    @Override
    public void destroyed(@NonNull Object eObject) {
        PivotUtilInternal.resetContainer((EObject)((EObject)eObject));
        this.object2feature2slotState.remove(eObject);
    }

    public @NonNull Map<@NonNull EStructuralFeature, @NonNull BasicSlotState> getObjectState(@NonNull Object eObject) {
        Map<@NonNull EStructuralFeature, @NonNull BasicSlotState> feature2state = this.object2feature2slotState.get(eObject);
        if (feature2state == null) {
            feature2state = new HashMap<EStructuralFeature, BasicSlotState>();
            this.object2feature2slotState.put(eObject, feature2state);
        }
        return feature2state;
    }

    @Override
    public @NonNull Iterable<@NonNull ? extends Object> getObjects() {
        return this.object2feature2slotState.keySet();
    }

    public synchronized @NonNull BasicSlotState getSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        assert (eFeature != null);
        Map<EStructuralFeature, BasicSlotState> objectState = this.getObjectState(eObject);
        BasicSlotState slotState = objectState.get(eFeature);
        if (slotState == null) {
            EReference eReference;
            EReference eOppositeReference;
            slotState = eFeature instanceof EAttribute ? new SimpleSlotState(eObject, eFeature) : ((eOppositeReference = (eReference = (EReference)eFeature).getEOpposite()) != null ? (eReference.isMany() ? (eOppositeReference.isMany() ? new ManyToManySlotState(eObject, (EStructuralFeature)eReference) : new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eReference)) : (eOppositeReference.isMany() ? new OneToManyElementSlotState(eObject, eReference) : new OneToOneSlotState(eObject, eReference))) : (eReference.isContainment() ? (eReference.isMany() ? new OneToManyAggregatorSlotState(eObject, (EStructuralFeature)eReference) : new OneToOneSlotState(eObject, eReference)) : (eReference == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? new OneToManyElementSlotState(eObject, eReference) : new SimpleSlotState(eObject, eFeature))));
            objectState.put(eFeature, slotState);
        }
        return slotState;
    }

    @Override
    public @NonNull Iterable<@NonNull ? extends SlotState> getSlotStates(@NonNull Object object) {
        Map<@NonNull EStructuralFeature, @NonNull BasicSlotState> feature2slotState = this.object2feature2slotState.get(object);
        return feature2slotState != null ? feature2slotState.values() : EMPTY_SLOT_STATE_LIST;
    }

    @Override
    public synchronized void getting(@NonNull Object eObject, EStructuralFeature eFeature, boolean isOpposite) {
        assert (eFeature != null);
        if (this.debugGettings) {
            AbstractTransformer.GETTINGS.println("getting " + IncrementalObjectManager.toDebugString(eObject) + "." + (isOpposite ? "~" : "") + eFeature.getName());
        }
        BasicSlotState slotState = this.getSlotState(eObject, eFeature);
        slotState.getting(eObject, eFeature);
    }

    @Override
    public void got(@NonNull Execution.Incremental execution, @NonNull Object eObject, EStructuralFeature eFeature, @Nullable Object ecoreValue) {
        assert (eFeature != null);
        BasicSlotState slotState = this.getSlotState(eObject, eFeature);
        execution.addReadSlot(slotState);
    }

    public void modified(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
        BasicSlotState slotState = this.basicGetSlotState(eObject, eFeature);
        if (slotState != null) {
            for (Execution.Incremental execution : slotState.getTargets()) {
                execution.revoke();
            }
        }
    }

    public static abstract class BasicSlotState
    extends AbstractSlotState.Incremental {
        protected final @NonNull Object eObject;
        protected final @NonNull EStructuralFeature eFeature;
        private @Nullable Object value = null;
        protected @NonNull SlotMode mode;
        private @Nullable Object blockedInvocations = null;

        public BasicSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            this.mode = SlotMode.ASSIGNABLE;
            this.eObject = eObject;
            this.eFeature = eFeature;
        }

        public BasicSlotState(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.mode = SlotMode.ASSIGNED;
            this.eObject = eObject;
            this.eFeature = eFeature;
            this.value = ecoreValue;
        }

        public synchronized void assigned(@NonNull IncrementalObjectManager objectManager, @NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            switch (this.mode) {
                case ASSIGNABLE: {
                    this.mode = SlotMode.ASSIGNED;
                    this.unblock(objectManager);
                    this.value = ecoreValue;
                    break;
                }
                case ASSIGNED: {
                    System.out.println("Re-assignment of " + eFeature.getEContainingClass().getName() + "::" + eFeature.getName() + " for " + eObject + " with " + ecoreValue);
                    break;
                }
                case REASSIGNABLE: {
                    this.mode = SlotMode.ASSIGNED;
                    if (this.value != ecoreValue) {
                        this.value = ecoreValue;
                        this.revokeTargets();
                    }
                    this.unblock(objectManager);
                }
            }
        }

        @Override
        public synchronized void block(@NonNull Invocation invocation) {
            Object blockedInvocations2 = this.blockedInvocations;
            if (blockedInvocations2 == null) {
                this.blockedInvocations = invocation;
            } else if (blockedInvocations2 instanceof Invocation) {
                ArrayList<Invocation> blockedInvocationList = new ArrayList<Invocation>();
                blockedInvocationList.add((Invocation)blockedInvocations2);
                blockedInvocationList.add(invocation);
                this.blockedInvocations = blockedInvocationList;
            } else {
                List blockedInvocationList = (List)blockedInvocations2;
                blockedInvocationList.add(invocation);
            }
        }

        @Override
        public void debugUnblock() {
            if (this.eObject instanceof EObject) {
                Object eProxy = null;
                EObject eObject = (EObject)this.eObject;
                EClassifier eType = this.eFeature.getEType();
                if (eType instanceof EClass) {
                    EClass eClass = (EClass)eType;
                    for (EClassifier eClassifier : eClass.getEPackage().getEClassifiers()) {
                        EClass eClass2;
                        if (!(eClassifier instanceof EClass) || (eClass2 = (EClass)eClassifier).isAbstract() || !eClass2.getEAllSuperTypes().contains((Object)eClass)) continue;
                        eClass = eClass2;
                    }
                    eProxy = eType.getEPackage().getEFactoryInstance().create(eClass);
                    if (eProxy instanceof InternalEObject) {
                        ((InternalEObject)eProxy).eSetProxyURI(URI.createURI((String)"blocked"));
                    }
                } else {
                    try {
                        eProxy = eType.getEPackage().getEFactoryInstance().createFromString((EDataType)eType, "");
                    }
                    catch (Throwable eClass) {
                        // empty catch block
                    }
                }
                if (this.eFeature.isMany()) {
                    List list = (List)eObject.eGet(this.eFeature);
                    list.add(eProxy);
                } else {
                    eObject.eSet(this.eFeature, eProxy);
                }
            }
        }

        @Override
        public @NonNull EStructuralFeature getEFeature() {
            return this.eFeature;
        }

        @Override
        public @NonNull SlotState.Incremental getPrimarySlotState() {
            return this;
        }

        @Override
        public @Nullable Object getValue() {
            return this.value;
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: 
                case REASSIGNABLE: {
                    throw new InvocationFailedException(this);
                }
            }
        }

        protected boolean isAssigned() {
            return this.mode == SlotMode.ASSIGNED;
        }

        @Override
        public void revokeAssigned() {
            SlotMode mode2 = this.mode;
            this.mode = SlotMode.REASSIGNABLE;
            if (mode2 == SlotMode.ASSIGNED) {
                this.revokeTargets();
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)) + "[" + this.eFeature.getEContainingClass().getName() + "::" + this.eFeature.getName() + " for " + this.eObject + "]";
        }

        protected synchronized void unblock(@NonNull ObjectManager objectManager) {
            Object blockedInvocations2 = this.blockedInvocations;
            if (blockedInvocations2 instanceof Invocation) {
                ((Invocation)blockedInvocations2).unblock();
            } else if (blockedInvocations2 != null) {
                List blockedInvocationList = (List)blockedInvocations2;
                for (Invocation invocation : blockedInvocationList) {
                    invocation.unblock();
                }
            }
            this.blockedInvocations = null;
        }

        public static enum SlotMode {
            ASSIGNABLE,
            ASSIGNED,
            REASSIGNABLE;

        }
    }

    class ManyToManySlotState
    extends BasicSlotState {
        public ManyToManySlotState(@NonNull Object eObject, EStructuralFeature eFeature) {
            super(eObject, eFeature);
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            throw new UnsupportedOperationException();
        }
    }

    class OneToManyAggregatorSlotState
    extends BasicSlotState {
        public OneToManyAggregatorSlotState(@NonNull Object eContainer, EStructuralFeature eFeature) {
            super(eContainer, eFeature);
            assert (eFeature.isMany());
        }

        private OneToManyAggregatorSlotState(@NonNull Object eContainer, @Nullable EStructuralFeature eFeature, Object eContents) {
            super(eContainer, eFeature, eContents);
            assert (eFeature.isMany());
            assert (((EObject)eContainer).eGet(eFeature).equals(eContents));
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            assert (ecoreValue != null);
            List ecoreValues = (List)ecoreValue;
            EReference eOppositeReference = ((EReference)eFeature).getEOpposite();
            for (EObject element : ecoreValues) {
                if (element == null) continue;
                Map<EStructuralFeature, BasicSlotState> elementObjectState = IncrementalObjectManager.this.getObjectState(element);
                elementObjectState.put((EStructuralFeature)eOppositeReference, this);
            }
            this.assignedElement(eObject, (EReference)eFeature, ecoreValue);
        }

        public void assignedElement(@NonNull Object eContainer, @NonNull EReference eReference, Object eObject) {
            switch (this.mode) {
                case ASSIGNABLE: 
                case REASSIGNABLE: {
                    this.mode = BasicSlotState.SlotMode.ASSIGNED;
                    this.unblock(IncrementalObjectManager.this);
                    break;
                }
            }
        }

        @Override
        public synchronized void getting(@NonNull Object eObject, @NonNull EStructuralFeature eFeature) {
            switch (this.mode) {
                case ASSIGNABLE: 
                case REASSIGNABLE: {
                    this.mode = BasicSlotState.SlotMode.ASSIGNED;
                    this.unblock(IncrementalObjectManager.this);
                    break;
                }
            }
        }
    }

    class OneToManyElementSlotState
    extends BasicSlotState {
        public OneToManyElementSlotState(@NonNull Object eObject, EReference eFeature) {
            super(eObject, (EStructuralFeature)eFeature);
            assert (!eFeature.isMany());
            if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
                assert (eFeature.getEOpposite() == null);
            } else {
                assert (eFeature.getEOpposite() != null);
                assert (eFeature.getEOpposite().isMany());
            }
        }

        public OneToManyElementSlotState(@NonNull Object eObject, @NonNull EReference eFeature, Object eAggregator) {
            super(eObject, (EStructuralFeature)eFeature, eAggregator);
            assert (!eFeature.isMany());
            assert (eFeature.getEOpposite() != null);
            assert (eFeature.getEOpposite().isMany());
            if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER ? !$assertionsDisabled && ((EObject)eObject).eContainer() != eAggregator : !$assertionsDisabled && ((EObject)eObject).eGet((EStructuralFeature)eFeature) != eAggregator) {
                throw new AssertionError();
            }
        }

        @Override
        public synchronized void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            if (!this.isAssigned() && ecoreValue != null) {
                EObject eOpposite = (EObject)ecoreValue;
                EReference eOppositeReference = ((EReference)eFeature).getEOpposite();
                if (eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
                    eOppositeReference = ((EObject)eObject).eContainmentFeature();
                    assert (eOppositeReference != null);
                    BasicSlotState aggregatorSlotState = IncrementalObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
                    aggregatorSlotState.assigned(eOpposite, (EStructuralFeature)eOppositeReference, eObject);
                } else {
                    assert (eOppositeReference != null);
                    OneToManyAggregatorSlotState aggregatorSlotState = (OneToManyAggregatorSlotState)IncrementalObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
                    aggregatorSlotState.assignedElement(eOpposite, eOppositeReference, eObject);
                }
            }
            this.assigned(eObject, eFeature, ecoreValue);
        }

        @Override
        public @NonNull SlotState.Incremental getPrimarySlotState() {
            EObject eOpposite = (EObject)this.getValue();
            assert (eOpposite != null);
            EReference eOppositeReference = ((EReference)this.eFeature).getEOpposite();
            if (this.eFeature == OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
                eOppositeReference = ((EObject)this.eObject).eContainmentFeature();
                assert (eOppositeReference != null);
                return IncrementalObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
            }
            assert (eOppositeReference != null);
            return IncrementalObjectManager.this.getSlotState(eOpposite, (EStructuralFeature)eOppositeReference);
        }
    }

    class OneToOneSlotState
    extends BasicSlotState {
        public OneToOneSlotState(@NonNull Object eObject, EReference eFeature) {
            super(eObject, (EStructuralFeature)eFeature);
            assert (!eFeature.isMany());
            if (!eFeature.isContainer() && !eFeature.isContainment() && eFeature != OCLstdlibPackage.Literals.OCL_ELEMENT__OCL_CONTAINER) {
                assert (eFeature.getEOpposite() != null);
                assert (!eFeature.getEOpposite().isMany());
            }
        }

        private OneToOneSlotState(@NonNull Object eObject, @Nullable EReference eFeature, Object eOpposite) {
            super(eObject, (EStructuralFeature)eFeature, eOpposite);
            assert (!eFeature.isMany());
            if (eFeature.isContainer()) {
                assert (((EObject)eObject).eContainer() == eOpposite);
            } else if (eFeature.isContainment()) {
                assert (eOpposite != null);
                assert (eObject == ((EObject)eOpposite).eContainer());
            } else {
                assert (eFeature.getEOpposite() != null);
                assert (!eFeature.getEOpposite().isMany());
                assert (((EObject)eObject).eGet((EStructuralFeature)eFeature) == eOpposite);
            }
        }

        @Override
        public void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.assigned(IncrementalObjectManager.this, eObject, eFeature, ecoreValue);
        }
    }

    class SimpleSlotState
    extends BasicSlotState {
        public SimpleSlotState(@NonNull Object eObject, EStructuralFeature eFeature) {
            super(eObject, eFeature);
        }

        public SimpleSlotState(@NonNull Object eObject, @Nullable EStructuralFeature eFeature, Object ecoreValue) {
            super(eObject, eFeature, ecoreValue);
        }

        @Override
        public void assigned(@NonNull Object eObject, @NonNull EStructuralFeature eFeature, @Nullable Object ecoreValue) {
            this.assigned(IncrementalObjectManager.this, eObject, eFeature, ecoreValue);
        }
    }
}

