/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.oclstdlib.scoping.JavaClassScope;
import org.eclipse.qvtd.pivot.qvtbase.model.QVTbaseLibrary;
import org.eclipse.qvtd.pivot.qvtbase.model.QVTbaseMetamodel;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;

public class QVTbaseLibraryTests
extends XtextTestCase {
    public Map<@NonNull String, @NonNull Element> computeMoniker2ASMap(Collection<@NonNull ? extends Resource> pivotResources) {
        HashMap<@NonNull String, @NonNull Element> map = new HashMap<String, Element>();
        for (Resource resource : pivotResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                assert (eObject.eResource() == resource);
                if (!(eObject instanceof Element) || eObject instanceof TemplateParameter || eObject instanceof Comment) continue;
                Element newElement = (Element)eObject;
                String moniker = AS2Moniker.toString((Element)newElement);
                assert (moniker != null);
                Element oldElement = (Element)map.get(moniker);
                if (oldElement == null) {
                    map.put(moniker, newElement);
                    continue;
                }
                assert (newElement.getClass() == oldElement.getClass());
            }
        }
        return map;
    }

    protected Resource doLoadAS(@NonNull ResourceSet resourceSet, @NonNull URI libraryURI, @NonNull Resource javaResource, boolean validateMonikers) {
        Resource asResource = resourceSet.getResource(libraryURI, true);
        assert (asResource != null);
        QVTbaseLibraryTests.assertNoResourceErrors("Load failed", asResource);
        QVTbaseLibraryTests.assertNoUnresolvedProxies("File Model", asResource);
        QVTbaseLibraryTests.assertNoValidationErrors("File Model", asResource);
        QVTbaseLibraryTests.assertNoResourceErrors("Java Model", javaResource);
        QVTbaseLibraryTests.assertNoUnresolvedProxies("Java Model", javaResource);
        QVTbaseLibraryTests.assertNoValidationErrors("Java Model", javaResource);
        if (!validateMonikers) {
            return asResource;
        }
        List<@NonNull Resource> asResourceList = Collections.singletonList(asResource);
        Map<@NonNull String, @NonNull Element> fileMoniker2asMap = this.computeMoniker2ASMap(asResourceList);
        Map<@NonNull String, @NonNull Element> javaMoniker2asMap = this.computeMoniker2ASMap(Collections.singletonList(javaResource));
        for (String moniker : fileMoniker2asMap.keySet()) {
            Element fileElement = fileMoniker2asMap.get(moniker);
            Element javaElement = javaMoniker2asMap.get(moniker);
            if (javaElement == null) {
                boolean isExpression = false;
                Element eObject = fileElement;
                while (eObject != null) {
                    if (eObject instanceof ExpressionInOCL || eObject instanceof Constraint || eObject instanceof Annotation) {
                        isExpression = true;
                        break;
                    }
                    eObject = eObject.eContainer();
                }
                if (isExpression) continue;
            }
            QVTbaseLibraryTests.assertNotNull((String)("Missing java element for '" + moniker + "'"), (Object)javaElement);
            assert (fileElement != null);
            assert (javaElement != null);
            java.lang.Class<?> javaElementClass = javaElement.getClass();
            QVTbaseLibraryTests.assertEquals(fileElement.getClass(), javaElementClass);
            if (fileElement instanceof TypedElement) {
                Type fileType = ((TypedElement)fileElement).getType();
                Type javaType = ((TypedElement)javaElement).getType();
                QVTbaseLibraryTests.assertEquals(fileType.getClass(), javaType.getClass());
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                QVTbaseLibraryTests.assertEquals((String)fileMoniker, (String)javaMoniker);
            }
            if (fileElement instanceof Feature) {
                LibraryFeature implementation;
                String fileClass = ((Feature)fileElement).getImplementationClass();
                String javaClass = ((Feature)javaElement).getImplementationClass();
                if (fileClass == null && (implementation = ((Feature)fileElement).getImplementation()) != null) {
                    fileClass = implementation.getClass().getCanonicalName();
                }
                if (javaClass == null && (implementation = ((Feature)javaElement).getImplementation()) != null) {
                    javaClass = implementation.getClass().getCanonicalName();
                }
                QVTbaseLibraryTests.assertEquals((String)fileClass, (String)javaClass);
            }
            if (!(fileElement instanceof Class)) continue;
            ArrayList fileTypes = new ArrayList(((Class)fileElement).getSuperClasses());
            ArrayList javaTypes = new ArrayList(((Class)javaElement).getSuperClasses());
            Collections.sort(fileTypes, MonikeredComparator.INSTANCE);
            Collections.sort(javaTypes, MonikeredComparator.INSTANCE);
            QVTbaseLibraryTests.assertEquals((int)fileTypes.size(), (int)javaTypes.size());
            int i = 0;
            while (i < fileTypes.size()) {
                Element fileType = (Element)fileTypes.get(i);
                Element javaType = (Element)javaTypes.get(i);
                assert (fileType != null && javaType != null);
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                QVTbaseLibraryTests.assertEquals((String)fileMoniker, (String)javaMoniker);
                ++i;
            }
        }
        return asResource;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestUtil.doOCLstdlibSetup();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQVTbaseLibrary() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        ResourceSet resourceSet = ocl.getResourceSet();
        this.getTestProjectManager().initializeResourceSet(resourceSet);
        URI libraryURI = URI.createPlatformResourceURI((String)"org.eclipse.qvtd.pivot.qvtbase/model/QVTbaseLibrary.oclstdlib", (boolean)true);
        BaseCSResource xtextResource = (BaseCSResource)resourceSet.createResource(libraryURI);
        assert (xtextResource != null);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        assert (classLoader != null);
        JavaClassScope.getAdapter((BaseCSResource)xtextResource, (ClassLoader)classLoader);
        ocl.getEnvironmentFactory().adapt((Notifier)xtextResource);
        xtextResource.load(null);
        CS2AS cs2as = xtextResource.findCS2AS();
        assert (cs2as != null);
        QVTbaseLibraryTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        ASResource fileResource = cs2as.getASResource();
        QVTbaseLibraryTests.assertNoResourceErrors("File Model", (Resource)fileResource);
        QVTbaseLibraryTests.assertNoUnresolvedProxies("File Model", (Resource)fileResource);
        QVTbaseLibraryTests.assertNoValidationErrors("File Model", (Resource)fileResource);
        QVTbaseLibrary javaResource = QVTbaseLibrary.getDefault();
        QVTbaseLibraryTests.assertNoResourceErrors("Java Model", (Resource)javaResource);
        QVTbaseLibraryTests.assertNoUnresolvedProxies("Java Model", (Resource)javaResource);
        QVTbaseLibraryTests.assertNoValidationErrors("Java Model", (Resource)javaResource);
        List<@NonNull ASResource> fileResourceList = Collections.singletonList(fileResource);
        Map<@NonNull String, @NonNull Element> fileMoniker2asMap = this.computeMoniker2ASMap(fileResourceList);
        List<@NonNull QVTbaseLibrary> javaResourceList = Collections.singletonList(javaResource);
        Map<@NonNull String, @NonNull Element> javaMoniker2asMap = this.computeMoniker2ASMap(javaResourceList);
        for (String moniker : fileMoniker2asMap.keySet()) {
            Element fileElement = fileMoniker2asMap.get(moniker);
            Element javaElement = javaMoniker2asMap.get(moniker);
            if (javaElement == null) {
                boolean isExpression = false;
                Element eObject = fileElement;
                while (eObject != null) {
                    if (eObject instanceof ExpressionInOCL || eObject instanceof Constraint || eObject instanceof Annotation) {
                        isExpression = true;
                        break;
                    }
                    eObject = eObject.eContainer();
                }
                if (isExpression) continue;
            }
            QVTbaseLibraryTests.assertNotNull((String)("Missing java element for '" + moniker + "'"), (Object)javaElement);
            assert (fileElement != null);
            assert (javaElement != null);
            java.lang.Class<?> javaElementClass = javaElement.getClass();
            QVTbaseLibraryTests.assertEquals(fileElement.getClass(), javaElementClass);
            if (fileElement instanceof TypedElement) {
                Type fileType = ((TypedElement)fileElement).getType();
                Type javaType = ((TypedElement)javaElement).getType();
                QVTbaseLibraryTests.assertEquals(fileType.getClass(), javaType.getClass());
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                QVTbaseLibraryTests.assertEquals((String)fileMoniker, (String)javaMoniker);
            }
            if (fileElement instanceof Feature) {
                LibraryFeature implementation;
                String fileClass = ((Feature)fileElement).getImplementationClass();
                String javaClass = ((Feature)javaElement).getImplementationClass();
                if (fileClass == null && (implementation = ((Feature)fileElement).getImplementation()) != null) {
                    fileClass = implementation.getClass().getCanonicalName();
                }
                if (javaClass == null && (implementation = ((Feature)javaElement).getImplementation()) != null) {
                    javaClass = implementation.getClass().getCanonicalName();
                }
                QVTbaseLibraryTests.assertEquals((String)fileClass, (String)javaClass);
            }
            if (!(fileElement instanceof Class)) continue;
            ArrayList fileTypes = new ArrayList(((Class)fileElement).getSuperClasses());
            ArrayList javaTypes = new ArrayList(((Class)javaElement).getSuperClasses());
            Collections.sort(fileTypes, MonikeredComparator.INSTANCE);
            Collections.sort(javaTypes, MonikeredComparator.INSTANCE);
            QVTbaseLibraryTests.assertEquals((int)fileTypes.size(), (int)javaTypes.size());
            int i = 0;
            while (i < fileTypes.size()) {
                Element fileType = (Element)fileTypes.get(i);
                Element javaType = (Element)javaTypes.get(i);
                assert (fileType != null && javaType != null);
                String fileMoniker = AS2Moniker.toString((Element)fileType);
                String javaMoniker = AS2Moniker.toString((Element)javaType);
                QVTbaseLibraryTests.assertEquals((String)fileMoniker, (String)javaMoniker);
                ++i;
            }
        }
        ocl.dispose();
    }

    public void testQVTbaseLibrary_AS() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)this.getTestProjectManager());
        URI libraryURI = URI.createPlatformResourceURI((String)"org.eclipse.qvtd.pivot.qvtbase/model-gen/QVTbaseLibrary.oclas", (boolean)true);
        QVTbaseLibrary javaResource = QVTbaseLibrary.getDefault();
        Resource asResource = this.doLoadAS(ocl.getMetamodelManager().getASResourceSet(), libraryURI, (Resource)javaResource, false);
        ocl.dispose();
    }

    public void testQVTbase_AS() throws Exception {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)this.getTestProjectManager(), null);
        URI pivotURI = URI.createPlatformResourceURI((String)"org.eclipse.qvtd.pivot.qvtbase/model-gen/QVTbase.oclas", (boolean)true);
        QVTbaseMetamodel javaResource = QVTbaseMetamodel.getDefault();
        Resource asResource = this.doLoadAS(ocl.getMetamodelManager().getASResourceSet(), pivotURI, (Resource)javaResource, false);
        ocl.dispose();
    }

    public static class MonikeredComparator
    implements Comparator<Element> {
        public static final Comparator<@NonNull Element> INSTANCE = new MonikeredComparator();

        @Override
        public int compare(@NonNull Element o1, @NonNull Element o2) {
            String m1 = AS2Moniker.toString((Element)o1);
            String m2 = AS2Moniker.toString((Element)o2);
            return m1.compareTo(m2);
        }
    }
}

