/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.AbstractRootRegion2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Partition;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class LoadingPartition2Mapping
extends AbstractRootRegion2Mapping {
    private final @NonNull Map<@NonNull ClassDatum, @NonNull AppendParameter> classDatum2variable = new HashMap<ClassDatum, AppendParameter>();
    private final @NonNull Map<@NonNull Node, @NonNull Variable> node2variable = new HashMap<Node, Variable>();

    public LoadingPartition2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull EntryPoint entryPoint, @NonNull LoadingPartition partition) {
        super(visitor, (Mapping)entryPoint, (Partition)partition);
    }

    private @NonNull BufferStatement createRootConnectionVariable(@NonNull String name, boolean isStrict, @NonNull Type type, @Nullable OCLExpression initExpression) {
        BufferStatement variable = this.helper.createBufferStatement(this.getSafeName(name), isStrict, type, true, initExpression);
        this.mapping.getOwnedStatements().add((Object)variable);
        return variable;
    }

    private void createRootConnectionVariables() {
        ArrayList<@NonNull E> rootConnections = new ArrayList(QVTscheduleUtil.getRootConnections((Partition)this.partition));
        Collections.sort(rootConnections, NameUtil.NAMEABLE_COMPARATOR);
        for (NodeConnection rootConnection : rootConnections) {
            Type commonType = this.getConnectionSourcesType(rootConnection);
            Node regionNode = rootConnection.basicGetSource(this.partition);
            String name = rootConnection.getName();
            assert (name != null);
            if (regionNode != null) {
                ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)regionNode);
                AppendParameter allInstancesVariable = this.classDatum2variable.get(classDatum);
                if (allInstancesVariable == null) {
                    Type elementType = classDatum.getCollectionElementType();
                    assert (!(elementType instanceof CollectionType));
                    String safeName = this.getSafeName(name);
                    allInstancesVariable = this.helper.createAppendParameter(safeName, elementType, true);
                    this.mapping.getOwnedMappingParameters().add((Object)allInstancesVariable);
                    this.classDatum2variable.put(classDatum, allInstancesVariable);
                }
                this.connection2variable.put(rootConnection, allInstancesVariable);
                continue;
            }
            BufferStatement rootConnectionVariable = this.createRootConnectionVariable(name, false, commonType, null);
            int firstPass = rootConnection.getFirstPass();
            int lastPass = rootConnection.getLastPass();
            rootConnectionVariable.setFirstPass(Integer.valueOf(firstPass));
            if (lastPass > firstPass) {
                rootConnectionVariable.setLastPass(Integer.valueOf(lastPass));
            }
            this.connection2variable.put(rootConnection, rootConnectionVariable);
        }
    }

    @Override
    protected @NonNull OCLExpression createSelectByKind(@NonNull Node resultNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull List<@NonNull Node> getGuardNodes() {
        return QVTscheduleConstants.EMPTY_NODE_LIST;
    }

    @Override
    public @NonNull MappingParameter getGuardVariable(@NonNull Node node) {
        Variable variable = this.node2variable.get(node);
        assert (variable != null);
        return (MappingParameter)variable;
    }

    protected @NonNull Iteration getSelectIteration() {
        SetType collectionType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getSetType();
        Operation selectIteration = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"select");
        assert (selectIteration != null);
        return (Iteration)selectIteration;
    }

    protected Type getType(@NonNull IdResolver idResolver, @NonNull NodeConnection rootConnection) {
        Object commonType = null;
        for (Node node : QVTscheduleUtil.getSourceEnds((NodeConnection)rootConnection)) {
            ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)node);
            for (CompleteClass completeClass : QVTscheduleUtil.getCompleteClasses((ClassDatum)classDatum)) {
                Class nodeType = completeClass.getPrimaryClass();
                commonType = commonType == null ? nodeType : commonType.getCommonType(idResolver, (Type)nodeType);
            }
        }
        return commonType;
    }

    protected boolean isInstall(@NonNull Partition calledPartition) {
        AbstractPartition2Mapping calledRegion2Mapping = this.visitor.getPartition2Mapping(calledPartition);
        for (Node calledGuardNode : calledRegion2Mapping.getGuardNodes()) {
            NodeConnection callingConnection = calledGuardNode.getIncomingPassedConnection();
            if (callingConnection != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void synthesizeCallStatements() {
        this.createRootConnectionVariables();
        EList ownedStatements = this.mapping.getOwnedStatements();
        for (Partition callablePartition : this.connectionManager.getCallableChildren(this.partition)) {
            if (CompilerUtil.isAbstract(callablePartition)) continue;
            if (this.isInstall(callablePartition)) {
                ownedStatements.add(this.createInstall(callablePartition));
                continue;
            }
            ownedStatements.add(this.createCall(callablePartition, null));
        }
    }

    @Override
    public void synthesizeLocalStatements() {
        HashSet<@NonNull TypedModel> checkableTypedModels = new HashSet<TypedModel>();
        for (Node node : this.partition.getPartialNodes()) {
            TypedModel asTypedModel;
            TypedModel iTypedModel;
            ClassDatum classDatum = node.getClassDatum();
            if (!classDatum.isCheckable() || (iTypedModel = this.visitor.getQVTiTypedModel(asTypedModel = classDatum.getReferredTypedModel())) == null) continue;
            checkableTypedModels.add(iTypedModel);
        }
    }
}

