/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.usage;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.usage.DirectedDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.BottomVariable;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardVariable;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.util.QVTcoreVisitor;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;

public class QVTcoreDomainUsageAnalysis
extends RootDomainUsageAnalysis
implements QVTcoreVisitor<DomainUsage> {
    public QVTcoreDomainUsageAnalysis(@NonNull EnvironmentFactory environmentFactory, @NonNull Transformation transformation) {
        super(environmentFactory, transformation);
    }

    @Override
    public @NonNull DirectedDomainUsageAnalysis createDirectedDomainUsageAnalysis() {
        return new QVTcoreDirectedDomainUsageAnalysis(this);
    }

    protected @NonNull DomainUsage doNavigationAssignment(@NonNull Property property, @NonNull NavigationAssignment object) {
        DomainUsage slotUsage = this.visit((Element)object.getSlotExpression());
        DomainUsage valueUsage = this.visit((Element)object.getValue());
        DomainUsage knownSourceUsage = this.getRootAnalysis().property2containingClassUsage.get(property);
        if (knownSourceUsage != null) {
            DomainUsage knownTargetUsage = this.getRootAnalysis().getUsage((Element)property);
            assert (knownTargetUsage != null);
            this.intersection(knownSourceUsage, slotUsage);
            this.intersection(knownTargetUsage, valueUsage);
            return knownSourceUsage;
        }
        return slotUsage;
    }

    @Override
    protected @NonNull DomainUsage getAllInstancesUsage(@NonNull OperationCallExp asCallExp, @NonNull DomainUsage sourceUsage) {
        if (asCallExp.getOwnedSource().getTypeValue() instanceof DataType) {
            return this.getPrimitiveUsage();
        }
        Area area = QVTcoreUtil.getContainingArea((EObject)asCallExp);
        if (area instanceof CoreDomain) {
            DomainUsage areaUsage = this.getUsage((Element)area);
            return this.intersection(sourceUsage, areaUsage);
        }
        if (area instanceof Mapping) {
            DomainUsage inputUsage = this.getNoneUsage();
            for (Domain domain : ((Mapping)area).getDomain()) {
                if (domain.isIsEnforceable()) continue;
                inputUsage = this.union(inputUsage, this.getUsage((Element)domain));
            }
            if (inputUsage != this.getNoneUsage()) {
                return this.intersection(sourceUsage, inputUsage);
            }
            return sourceUsage;
        }
        return sourceUsage;
    }

    protected void setBoundVariablesUsages(@NonNull Rule rule) {
        RootDomainUsageAnalysis.DomainUsageConstant primitiveUsage = this.getRootAnalysis().getPrimitiveUsage();
        for (Domain domain : rule.getDomain()) {
            if (!(domain instanceof CoreDomain)) continue;
            DomainUsage usage = this.visit((Element)domain.getTypedModel());
            for (Variable variable : ((CoreDomain)domain).getGuardPattern().getVariable()) {
                if (variable == null) continue;
                DomainUsage variableUsage = this.visit((Element)variable.getType());
                if (variableUsage != primitiveUsage) {
                    variableUsage = usage;
                }
                assert (variableUsage != null);
                this.setUsage((Element)variable, variableUsage);
            }
        }
        if (rule instanceof Mapping) {
            DomainUsage middleUsage = this.getRootAnalysis().getMiddleUsage();
            for (Variable variable : ((Mapping)rule).getGuardPattern().getVariable()) {
                if (variable == null) continue;
                DomainUsage variableUsage = this.visit((Element)variable.getType());
                if (variableUsage.isMiddle()) {
                    assert (variableUsage == middleUsage);
                    variableUsage = middleUsage;
                }
                assert (variableUsage != null);
                this.setUsage((Element)variable, variableUsage);
            }
        }
        if (rule instanceof Mapping) {
            for (Mapping local : ((Mapping)rule).getLocal()) {
                if (local == null) continue;
                this.setBoundVariablesUsages((Rule)local);
            }
        }
    }

    public @NonNull DomainUsage visitAssignment(@NonNull Assignment object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitBottomPattern(@NonNull BottomPattern object) {
        for (Variable variable : object.getVariable()) {
            this.visit((Element)variable);
        }
        for (Variable variable : object.getRealizedVariable()) {
            this.visit((Element)variable);
        }
        for (Assignment assignment : object.getAssignment()) {
            this.visit((Element)assignment);
        }
        for (Predicate predicate : object.getPredicate()) {
            this.visit((Element)predicate);
        }
        return this.getDomainUsage((EObject)object);
    }

    public @NonNull DomainUsage visitBottomVariable(@NonNull BottomVariable object) {
        return this.visitVariable((Variable)object);
    }

    public @NonNull DomainUsage visitCoreDomain(@NonNull CoreDomain object) {
        DomainUsage usage = this.visit((Element)object.getTypedModel());
        this.setUsage((Element)object, usage);
        this.visit((Element)object.getGuardPattern());
        this.visit((Element)object.getBottomPattern());
        return usage;
    }

    public @NonNull DomainUsage visitCoreModel(@NonNull CoreModel object) {
        return this.visitBaseModel((BaseModel)object);
    }

    public @NonNull DomainUsage visitCorePattern(@NonNull CorePattern object) {
        return this.visitPattern((Pattern)object);
    }

    public @NonNull DomainUsage visitEnforcementOperation(@NonNull EnforcementOperation object) {
        return (DomainUsage)this.visitElement((Element)object);
    }

    public @NonNull DomainUsage visitGuardPattern(@NonNull GuardPattern object) {
        DomainUsage domainUsage = this.getDomainUsage((EObject)object);
        for (Predicate predicate : object.getPredicate()) {
            this.visit((Element)predicate);
        }
        return domainUsage;
    }

    public @NonNull DomainUsage visitGuardVariable(@NonNull GuardVariable object) {
        return this.visitVariable((Variable)object);
    }

    public @NonNull DomainUsage visitMapping(@NonNull Mapping object) {
        DomainUsage usage = this.getRootAnalysis().getNoneUsage();
        this.setUsage((Element)object, usage);
        this.visitRule((Rule)object);
        this.visit((Element)object.getGuardPattern());
        this.visit((Element)object.getBottomPattern());
        for (Mapping local : object.getLocal()) {
            this.visit((Element)local);
        }
        return usage;
    }

    public @NonNull DomainUsage visitNavigationAssignment(@NonNull NavigationAssignment object) {
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)object);
        return this.doNavigationAssignment(property, object);
    }

    public @NonNull DomainUsage visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment object) {
        return this.visitNavigationAssignment((NavigationAssignment)object);
    }

    public @NonNull DomainUsage visitPropertyAssignment(@NonNull PropertyAssignment object) {
        return this.visitNavigationAssignment((NavigationAssignment)object);
    }

    public @NonNull DomainUsage visitRealizedVariable(@NonNull RealizedVariable object) {
        return this.getDomainUsage((EObject)object);
    }

    @Override
    public @NonNull DomainUsage visitTransformation(@NonNull Transformation object) {
        RootDomainUsageAnalysis rootAnalysis = this.getRootAnalysis();
        if (rootAnalysis != this) {
            return rootAnalysis.getNoneUsage();
        }
        Variable ownedContext = QVTbaseUtil.getContextVariable((StandardLibrary)this.getEnvironmentFactory().getStandardLibrary(), (Transformation)object);
        this.setUsage((Element)ownedContext, this.getRootAnalysis().getNoneUsage());
        for (Operation operation : object.getOwnedOperations()) {
            if (operation == null) continue;
            this.getRootAnalysis().analyzeOperation(operation);
        }
        for (Rule rule : object.getRule()) {
            if (rule == null) continue;
            this.setBoundVariablesUsages(rule);
        }
        for (Rule rule : object.getRule()) {
            this.visit((Element)rule);
        }
        return this.getRootAnalysis().getNoneUsage();
    }

    public @NonNull DomainUsage visitVariable(@NonNull Variable object) {
        OCLExpression ownedInit = object.getOwnedInit();
        if (ownedInit != null) {
            return this.visit((Element)ownedInit);
        }
        Area area = QVTcoreUtil.getContainingArea((EObject)object);
        if (area instanceof Domain) {
            return this.visit((Element)area);
        }
        return this.visit((Element)object.getType());
    }

    public @NonNull DomainUsage visitVariableAssignment(@NonNull VariableAssignment object) {
        DomainUsage valueUsage = this.visit((Element)object.getValue());
        DomainUsage variableUsage = this.visit((Element)object.getTargetVariable());
        return this.intersection(variableUsage, valueUsage);
    }

    protected static class QVTcoreDirectedDomainUsageAnalysis
    extends DirectedDomainUsageAnalysis {
        public QVTcoreDirectedDomainUsageAnalysis(@NonNull QVTcoreDomainUsageAnalysis domainUsageAnalysis) {
            super(domainUsageAnalysis);
        }

        @Override
        protected void analyzePropertyAssignments(@NonNull Transformation transformation) {
            for (EObject eObject : new TreeIterable((EObject)transformation, true)) {
                if (!(eObject instanceof PropertyAssignment)) continue;
                PropertyAssignment propertyAssignment = (PropertyAssignment)eObject;
                OCLExpression slotExpression = propertyAssignment.getSlotExpression();
                assert (slotExpression != null);
                DomainUsage domainUsage = this.getUsage((Element)PivotUtil.getType((TypedElement)slotExpression));
                if (this.isOutput(domainUsage) || domainUsage.isMiddle()) continue;
                Property targetProperty = (Property)ClassUtil.nonNullState((Object)propertyAssignment.getTargetProperty());
                this.addDirtyProperty(targetProperty);
            }
            super.analyzePropertyAssignments(transformation);
        }
    }
}

