/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.DispatchClass2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;

public class RelationDispatchAnalysis
extends RegionHelper<RuleRegion> {
    protected final @NonNull RelationAnalysis relationAnalysis;
    protected final @NonNull Relation relation;

    public RelationDispatchAnalysis(@NonNull RelationAnalysis relationAnalysis, @NonNull DispatchRegion dispatchRegion) {
        super(relationAnalysis.getScheduleManager(), dispatchRegion);
        this.relationAnalysis = relationAnalysis;
        this.relation = relationAnalysis.getRule();
    }

    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        ruleRegions.add((RuleRegion)this.region);
    }

    protected void synthesizeDispatchHierarchy(@NonNull Node traceNode, @NonNull Relation2DispatchClass relation2dispatchClass, @NonNull Relation relation) {
        if (!relation.isIsAbstract()) {
            QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
            Relation2TraceClass relation2TraceClass = scheduleManager.getRuleAnalysis((Rule)relation).getRule2TraceGroup().getRule2TraceClass();
            TypedModel traceTypedModel = this.relationAnalysis.getTraceTypedModel();
            ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(traceTypedModel, relation2TraceClass.getMiddleClass());
            VariableNode dispatchedNode = this.createRealizedNode(Utility.NON_NULL_MATCHED, RelationDispatchAnalysis.getName((Nameable)relation), dispatchedClassDatum);
            DispatchClass2TraceProperty dispatchClass2traceProperty = relation2dispatchClass.getDispatchClass2TraceProperty(relation);
            this.createRealizedNavigationEdge(Utility.NON_NULL_MATCHED, traceNode, dispatchClass2traceProperty.getTraceProperty(), (Node)dispatchedNode, false);
        }
        for (Relation overridingRelation : QVTrelationUtil.getOverrides((Relation)relation)) {
            this.synthesizeDispatchHierarchy(traceNode, relation2dispatchClass, overridingRelation);
        }
    }

    public void synthesizeElements() {
        Relation2TraceGroup rule2traceGroup = this.relationAnalysis.getRule2TraceGroup();
        Relation2DispatchClass relation2dispatchClass = rule2traceGroup.getRule2DispatchClass();
        Node traceNode = this.synthesizeTraceNode(relation2dispatchClass);
        this.synthesizeTraceEdges(traceNode);
        this.synthesizeDispatchHierarchy(traceNode, relation2dispatchClass, this.relation);
    }

    protected void synthesizeTraceEdges(@NonNull Node traceNode) {
        boolean isTopLevel = this.relation.isIsTopLevel();
        Relation2TraceGroup rule2traceGroup = this.relationAnalysis.getRule2TraceGroup();
        Relation2DispatchClass rule2dispatchClass = rule2traceGroup.getRule2DispatchClass();
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            if (!this.scheduleManager.isInputInRule((Rule)this.relation, (Element)relationDomain)) continue;
            for (VariableDeclaration variable : QVTrelationUtil.getRootVariables((RelationDomain)relationDomain)) {
                VariableDeclaration2TraceProperty variableDeclaration2traceClassProperty = rule2dispatchClass.getVariableDeclaration2TraceProperty(variable);
                Property traceClassProperty = variableDeclaration2traceClassProperty.getTraceProperty();
                VariableNode targetNode = this.createOldNode(Utility.getRequiredUtility((TypedElement)variable), variable);
                boolean isPartial = this.scheduleManager.computeIsPartial((Node)targetNode, traceClassProperty);
                this.createNavigationEdge(targetNode.getUtility(), traceNode, traceClassProperty, (Node)targetNode, isPartial);
                if (!isTopLevel) continue;
                ((RuleRegion)this.region).getHeadNodes().add(targetNode);
                targetNode.setHead();
            }
        }
    }

    protected @NonNull Node synthesizeTraceNode(@NonNull Relation2DispatchClass relation2dispatchClass) {
        TypedModel traceTypedModel = this.relationAnalysis.getTraceTypedModel();
        ClassDatum dispatchedClassDatum = this.scheduleManager.getClassDatum(traceTypedModel, relation2dispatchClass.getMiddleClass());
        if (this.relation.isIsTopLevel()) {
            VariableNode realizedDispatchNode = this.createRealizedNode(Utility.DISPATCH, "dispatcher", dispatchedClassDatum);
            return realizedDispatchNode;
        }
        Node predicatedDispatchNode = this.createPredicatedNode(Utility.TRACE, "dispatcher", dispatchedClassDatum);
        ((RuleRegion)this.region).getHeadNodes().add(predicatedDispatchNode);
        predicatedDispatchNode.setHead();
        return predicatedDispatchNode;
    }
}

