/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.tests;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbase;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationFactory;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.umlx.qvtr2umlx.QVTr2UMLX;
import org.eclipse.qvtd.umlx.umlx2qvtr.UMLX2QVTr;
import org.eclipse.qvtd.umlx.utilities.UMLXStandaloneSetup;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.TestsXMLUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;

public class UMLXSerializeTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTbase.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected void doLoadTest(URI inputURI, URI pivotURI, URI umlxURI) throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)this.getTestProjectManager());
        Resource qvtrResource = this.doLoad_Concrete(ocl, inputURI, pivotURI, null);
        Resource umlxResource = qvtrResource.getResourceSet().createResource(umlxURI);
        QVTr2UMLX qvtr2umlx = new QVTr2UMLX(ocl.getEnvironmentFactory(), qvtrResource, umlxResource);
        qvtr2umlx.transform();
        umlxResource.save(null);
        UMLXSerializeTests.assertNoValidationErrors((String)umlxURI.toString(), (Resource)umlxResource);
        ocl.dispose();
    }

    protected void doRoundTripTest(@NonNull String path, @NonNull String stem, boolean skipCompare) throws Exception {
        URI normalizedURI;
        QVTrelation ocl1 = QVTrelation.newInstance((ProjectManager)this.getTestProjectManager());
        URI inputURI1 = this.getResourceURI(String.valueOf(path) + stem + ".qvtr");
        URI pivotURI1 = this.getTestURI(String.valueOf(stem) + ".qvtras");
        URI umlxURI = this.getTestURI(String.valueOf(path) + stem + ".umlx");
        URI pivotURI2 = this.getTestURI(String.valueOf(stem) + ".regenerated.qvtras");
        URIConverter uriConverter = ocl1.getResourceSet().getURIConverter();
        URIHandler uriHandler = uriConverter.getURIHandler(normalizedURI = uriConverter.normalize(umlxURI));
        if (!(uriHandler instanceof FileURIHandlerImpl)) {
            umlxURI = this.getTestURI(String.valueOf(stem) + ".umlx");
        }
        Resource qvtrResource1 = this.doLoad_Concrete((OCL)ocl1, inputURI1, pivotURI1, null);
        Resource umlxResource1 = qvtrResource1.getResourceSet().createResource(umlxURI);
        QVTr2UMLX qvtr2umlx = new QVTr2UMLX((EnvironmentFactory)ocl1.getEnvironmentFactory(), qvtrResource1, umlxResource1);
        qvtr2umlx.transform();
        umlxResource1.save(null);
        UMLXSerializeTests.assertNoValidationErrors((String)umlxURI.toString(), (Resource)umlxResource1);
        QVTrelation ocl2 = QVTrelation.newInstance((ProjectManager)this.getTestProjectManager());
        Resource umlxResource2 = ocl2.getResourceSet().getResource(umlxURI, true);
        Resource qvtrResource2 = ocl2.getMetamodelManager().getASResourceSet().createResource(pivotURI2);
        UMLX2QVTr umlx2qvtr = new UMLX2QVTr((EnvironmentFactory)ocl2.getEnvironmentFactory(), umlxResource2, qvtrResource2);
        umlx2qvtr.transform();
        qvtrResource2.save(CompilerUtil.defaultSavingOptions);
        Model asModel1 = PivotUtil.getModel((Resource)qvtrResource1);
        Model asModel2 = PivotUtil.getModel((Resource)qvtrResource2);
        asModel2.setName(asModel1.getName());
        asModel2.setExternalURI(asModel1.getExternalURI());
        TestsXMLUtil.resetTransients((Resource)qvtrResource1);
        TestsXMLUtil.resetTransients((Resource)qvtrResource2);
        this.normalize(qvtrResource1);
        this.normalize(qvtrResource2);
        if (!skipCompare) {
            UMLXSerializeTests.assertSameModel((Resource)qvtrResource1, (Resource)qvtrResource2);
        }
        ocl1.dispose();
        ocl2.dispose();
    }

    private void normalize(@NonNull Resource qvtrResource) {
        TreeIterator tit = qvtrResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Relation) {
                this.normalizeRelation((Relation)eObject);
                tit.prune();
                continue;
            }
            if (!(eObject instanceof Import)) continue;
            ((Import)eObject).getOwnedComments().clear();
            tit.prune();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void normalizeRelation(@NonNull Relation asRelation) {
        HashMap<@NonNull VariableDeclaration, @NonNull ArrayList<@NonNull Element>> variable2reference = new HashMap<VariableDeclaration, ArrayList<Element>>();
        ArrayList<OCLExpression> whenExpressions = new ArrayList<OCLExpression>();
        for (EObject eObject : new TreeIterable((EObject)asRelation, true)) {
            OCLExpression where;
            ArrayList referredVariables = null;
            if (eObject instanceof VariableExp) {
                referredVariables = Lists.newArrayList((Object[])new VariableDeclaration[]{((VariableExp)eObject).getReferredVariable()});
            } else if (eObject instanceof TemplateExp) {
                TemplateExp templateExp = (TemplateExp)eObject;
                referredVariables = Lists.newArrayList((Object[])new VariableDeclaration[]{templateExp.getBindsTo()});
                if (eObject instanceof CollectionTemplateExp) {
                    referredVariables.add(((CollectionTemplateExp)eObject).getRest());
                }
                if ((where = templateExp.getWhere()) != null) {
                    whenExpressions.add(where);
                }
            } else if (eObject instanceof DomainPattern) {
                referredVariables = Lists.newArrayList((Iterable)((DomainPattern)eObject).getBindsTo());
            }
            if (referredVariables == null) continue;
            where = referredVariables.iterator();
            while (where.hasNext()) {
                @NonNull VariableDeclaration referredVariable = (VariableDeclaration)where.next();
                List<Object> references = (List)variable2reference.get(referredVariable);
                if (references == null) {
                    references = new ArrayList<Element>();
                    variable2reference.put(referredVariable, (ArrayList<Element>)references);
                }
                references.add((Element)eObject);
            }
        }
        for (VariableDeclaration variable : variable2reference.keySet()) {
            @NonNull List references = (List)variable2reference.get(variable);
            assert (references != null);
            if (!(variable instanceof TemplateVariable)) continue;
            boolean canBeShared = true;
            for (Element reference : references) {
                if (!(reference instanceof TemplateExp)) continue;
                EObject eContainer = reference.eContainer();
                if (eContainer instanceof PropertyTemplateItem) {
                    if (reference instanceof ObjectTemplateExp) {
                        ObjectTemplateExp objectTemplateExp = (ObjectTemplateExp)reference;
                        if (!objectTemplateExp.getPart().isEmpty()) {
                            canBeShared = false;
                            break;
                        }
                        Property asProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)((PropertyTemplateItem)eContainer));
                        if (asProperty == null) continue;
                        asProperty.isIsComposite();
                        continue;
                    }
                    if (!(reference instanceof CollectionTemplateExp)) continue;
                    CollectionTemplateExp collectionTemplateExp = (CollectionTemplateExp)reference;
                    if (!collectionTemplateExp.getMember().isEmpty()) {
                        canBeShared = false;
                        break;
                    }
                    if (collectionTemplateExp.getRest() == null) continue;
                    canBeShared = false;
                    break;
                }
                canBeShared = false;
                break;
            }
            if (!canBeShared) continue;
            SharedVariable sharedVariable = QVTrelationFactory.eINSTANCE.createSharedVariable();
            sharedVariable.setName(variable.getName());
            sharedVariable.setType(variable.getType());
            sharedVariable.setIsRequired(variable.isIsRequired());
            QVTbaseUtil.replaceChild((EObject)variable, (EObject)sharedVariable);
            for (Element reference : references) {
                if (reference instanceof VariableExp) {
                    ((VariableExp)reference).setReferredVariable((VariableDeclaration)sharedVariable);
                    continue;
                }
                if (reference instanceof ObjectTemplateExp) {
                    QVTbaseUtil.replaceChild((EObject)reference, (EObject)PivotUtil.createVariableExp((VariableDeclaration)sharedVariable));
                    continue;
                }
                if (reference instanceof CollectionTemplateExp) {
                    QVTbaseUtil.replaceChild((EObject)reference, (EObject)PivotUtil.createVariableExp((VariableDeclaration)sharedVariable));
                    continue;
                }
                if (!(reference instanceof DomainPattern)) continue;
                ((DomainPattern)reference).getBindsTo().remove((Object)variable);
            }
        }
        Pattern whenPattern = asRelation.getWhen();
        for (OCLExpression whenExpression : whenExpressions) {
            PivotUtilInternal.resetContainer((EObject)whenExpression);
            Predicate asPredicate = QVTbaseFactory.eINSTANCE.createPredicate();
            asPredicate.setConditionExpression(whenExpression);
            if (whenPattern == null) {
                whenPattern = QVTbaseFactory.eINSTANCE.createPattern();
                asRelation.setWhen(whenPattern);
            }
            whenPattern.getPredicate().add((Object)asPredicate);
        }
    }

    protected void setUp() throws Exception {
        XtextCompilerUtil.doQVTrelationSetup();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            UMLXStandaloneSetup.doSetup();
        }
        super.setUp();
    }

    public void testUMLXLoad_Forward2Reverse_qvtr() throws Exception {
        URI inputURI = this.getResourceURI("org.eclipse.qvtd.xtext.qvtrelation.tests/models/forward2reverse/Forward2Reverse.qvtr");
        URI pivotURI = this.getTestURI("Forward2Reverse.qvtras");
        URI umlxURI = this.getTestURI("Forward2Reverse.umlx");
        this.doLoadTest(inputURI, pivotURI, umlxURI);
    }

    public void testUMLXLoad_Keys_qvtr() throws Exception {
        URI inputURI = this.getResourceURI("org.eclipse.qvtd.xtext.qvtrelation.tests/models/misc/Keys.qvtr");
        URI pivotURI = this.getTestURI("Keys.qvtras");
        URI umlxURI = this.getTestURI("Keys.umlx");
        this.doLoadTest(inputURI, pivotURI, umlxURI);
    }

    public void testUMLXLoad_RelToCore_qvtr() throws Exception {
        URI inputURI = this.getResourceURI("org.eclipse.qvtd.examples.qvtrelation.reltocore/model/RelToCore.qvtr");
        URI pivotURI = this.getTestURI("RelToCore.qvtras");
        URI umlxURI = this.getTestURI("RelToCore.umlx");
        this.doLoadTest(inputURI, pivotURI, umlxURI);
    }

    public void testUMLXLoad_SeqToStm_qvtr() throws Exception {
        URI inputURI = this.getResourceURI("org.eclipse.qvtd.xtext.qvtrelation.tests/models/seq2stm/SeqToStm.qvtr");
        URI pivotURI = this.getTestURI("SeqToStm.qvtras");
        URI umlxURI = this.getTestURI("SeqToStm.umlx");
        this.doLoadTest(inputURI, pivotURI, umlxURI);
    }

    public void testUMLXLoad_SimplerRelToCore_qvtr() throws Exception {
        URI inputURI = this.getResourceURI("org.eclipse.qvtd.examples.qvtrelation.reltocore/model/SimplerRelToCore.qvtr");
        URI pivotURI = this.getTestURI("SimplerRelToCore.qvtras");
        URI umlxURI = this.getTestURI("SimplerRelToCore.umlx");
        this.doLoadTest(inputURI, pivotURI, umlxURI);
    }

    public void testUMLXRoundtrip_Forward2Reverse_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/forward2reverse/", "Forward2Reverse", true);
    }

    public void testUMLXRoundtrip_HierarchicalStateMachine2FlatStateMachine_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/hstm2fstm/", "HierarchicalStateMachine2FlatStateMachine", true);
    }

    public void testUMLXRoundtrip_Iterated2Iterated_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/iterated2iterated/", "Iterated2Iterated", true);
    }

    public void testUMLXRoundtrip_Keys_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/misc/", "Keys", true);
    }

    public void testUMLXRoundtrip_MiToSiSimple_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/mitosi/", "MiToSiSimple", true);
    }

    public void testUMLXRoundtrip_PN2SC_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/pn2sc/", "PetriNet2StateChart", true);
    }

    public void testUMLXRoundtrip_SeqToStm_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.xtext.qvtrelation.tests/models/seq2stm/", "SeqToStm", true);
    }

    public void testUMLXRoundtrip_SimplerRelToCore_qvtr() throws Exception {
        this.doRoundTripTest("org.eclipse.qvtd.examples.qvtrelation.reltocore/model/", "SimplerRelToCore", true);
    }
}

