/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QvtIterationTemplate<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> myEvalVisitor;
    private EvaluationEnvironment<C, O, P, CLS, E> myEvalEnv;
    private boolean done = false;

    protected QvtIterationTemplate(EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> v) {
        this.myEvalVisitor = v;
        this.myEvalEnv = v.getEvaluationEnvironment();
    }

    public EvaluationVisitor<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getEvaluationVisitor() {
        return this.myEvalVisitor;
    }

    public EvaluationEnvironment<C, O, P, CLS, E> getEvalEnvironment() {
        return this.myEvalEnv;
    }

    public final void setDone(boolean done) {
        this.done = done;
    }

    public final boolean isDone() {
        return this.done;
    }

    public Object evaluate(Collection<?> coll, List<Variable<C, PM>> iterators, Variable<EClassifier, EParameter> target, OCLExpression<C> condition, OCLExpression<C> body, String resultName, boolean isOne) {
        if (coll.isEmpty()) {
            return this.myEvalEnv.getValueOf(resultName);
        }
        int numIters = iterators.size();
        Iterator[] javaIters = new Iterator[numIters];
        this.initializeIterators(iterators, javaIters, coll);
        while (true) {
            Object bodyVal = body == null ? null : this.myEvalVisitor.visitExpression(body);
            this.advanceTarget(target, bodyVal);
            Object resultVal = this.evaluateResult(iterators, resultName, condition, bodyVal, isOne);
            this.myEvalEnv.replace(resultName, resultVal);
            int curr = this.getNextUnfinishedIterator(javaIters);
            if (!this.moreToGo(curr, numIters)) {
                this.removeIterators(iterators);
                this.removeTarget(target);
                return this.myEvalEnv.getValueOf(resultName);
            }
            this.advanceIterators(iterators, javaIters, coll, curr);
        }
    }

    protected void initializeIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c) {
        int i = 0;
        int n = javaIters.length;
        while (i < n) {
            javaIters[i] = c.iterator();
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = (String)iterDecl.accept(this.myEvalVisitor);
            Object value = javaIters[i].next();
            this.myEvalEnv.replace(iterName, value);
            ++i;
        }
    }

    protected int getNextUnfinishedIterator(Iterator<?>[] javaIters) {
        int numIters = javaIters.length;
        int curr = 0;
        while (curr < numIters) {
            if (javaIters[curr].hasNext()) break;
            ++curr;
        }
        return curr;
    }

    protected void advanceIterators(List<Variable<C, PM>> iterators, Iterator<?>[] javaIters, Collection<?> c, int curr) {
        int i = 0;
        int n = curr;
        while (i <= n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            if (i != curr) {
                javaIters[i] = c.iterator();
            }
            Object value = javaIters[i].next();
            this.myEvalEnv.replace(iterName, value);
            ++i;
        }
    }

    protected void removeIterators(List<Variable<C, PM>> iterators) {
        int i = 0;
        int n = iterators.size();
        while (i < n) {
            Variable<C, PM> iterDecl = iterators.get(i);
            String iterName = iterDecl.getName();
            this.myEvalEnv.remove(iterName);
            ++i;
        }
    }

    protected boolean moreToGo(int curr, int numIters) {
        if (this.done) {
            return false;
        }
        return curr < numIters;
    }

    protected void advanceTarget(Variable<EClassifier, EParameter> target, Object bodyVal) {
        if (target != null) {
            String varName = target.getName();
            this.myEvalEnv.replace(varName, bodyVal);
        }
    }

    protected void removeTarget(Variable<EClassifier, EParameter> target) {
        if (target != null) {
            String varName = target.getName();
            this.myEvalEnv.remove(varName);
        }
    }

    protected abstract Object evaluateResult(List<Variable<C, PM>> var1, String var2, OCLExpression<EClassifier> var3, Object var4, boolean var5);

    protected OCLStandardLibrary<C> getOCLStandardLibrary() {
        return this.myEvalVisitor.getEnvironment().getOCLStandardLibrary();
    }

    protected Object getOclInvalid() {
        return this.getOCLStandardLibrary().getOclInvalid();
    }

    protected Boolean isConditionOk(OCLExpression<EClassifier> conditionExp, Object bodyVal) {
        Object conditionVal = conditionExp.accept(this.myEvalVisitor);
        if (conditionVal instanceof Boolean) {
            return (Boolean)conditionVal;
        }
        if (conditionVal instanceof EClassifier) {
            QvtOperationalEvaluationEnv env = (QvtOperationalEvaluationEnv)this.getEvalEnvironment();
            return QvtOperationalUtil.oclIsKindOf(bodyVal, (EClassifier)conditionVal, env);
        }
        this.setDone(true);
        return null;
    }

    protected Object returnCheckedEvaluationResult(Object addedElement, boolean isOne, String resultName) {
        if (addedElement == this.getOclInvalid()) {
            this.setDone(true);
            return this.getOclInvalid();
        }
        if (isOne) {
            this.setDone(true);
            return addedElement;
        }
        Collection resultingCollection = (Collection)this.getEvalEnvironment().getValueOf(resultName);
        resultingCollection.add(addedElement);
        return resultingCollection;
    }
}

