/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.launch;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class ProcessJob
extends WorkspaceJob
implements IProcess {
    private ILaunch launch;
    private IStreamsProxy proxy;

    public ProcessJob(String name, ILaunch launch, IStreamsProxy proxy) {
        super(name);
        this.launch = launch;
        this.proxy = proxy;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (DebugPlugin.getDefault() != null) {
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)ProcessJob.this, 8)});
                }
            }
        });
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getResult() != null;
    }

    public void terminate() {
        this.cancel();
    }

    public String getLabel() {
        String transformationURI = null;
        ILaunchConfiguration configuration = this.launch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                transformationURI = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", null);
            }
            catch (CoreException e) {
                CommonPlugin.log(e.getStatus());
            }
        }
        return transformationURI != null ? NLS.bind((String)Messages.IProcess_LabelTransform, transformationURI) : Messages.IProcess_Label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.proxy;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.common", 1, Messages.IProcess_InvalidState, null));
        }
        return this.getResult().getSeverity();
    }
}

