/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOLocalValue;
import org.eclipse.m2m.qvt.oml.debug.core.vm.ConditionChecker;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebuggableExecutorAdapter;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTODebuggerShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTODebuggerShellExtension;
import org.eclipse.m2m.qvt.oml.debug.core.vm.IQVTOVirtualMachineShell;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTODebugEvaluator;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocationExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpointManager;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VariableFinder;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.BreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.NewBreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMBreakpointRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMBreakpointResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDetailRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMDetailResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStackFrameRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStackFrameResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStartRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateEvent;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMVariableRequest;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.utilities.ASTNode;

public class QVTOVirtualMachine
implements IQVTOVirtualMachineShell {
    private final List<VMRequest> fRequests = new ArrayList<VMRequest>();
    private final BlockingQueue<VMEvent> fEvents = new ArrayBlockingQueue<VMEvent>(50);
    private IQVTODebuggerShell fDebuggerShell;
    private final VMBreakpointManager fBreakpointManager;
    private QVTODebugEvaluator fInterpreter;
    private DebuggableExecutorAdapter fExecutor;
    private boolean fRunning;
    private boolean fTerminated;
    private Object fStateMonitor = new Object();
    private final Object fLock = new Object();

    public QVTOVirtualMachine(DebuggableExecutorAdapter executorAdapter) {
        if (executorAdapter == null) {
            throw new IllegalArgumentException();
        }
        this.fExecutor = executorAdapter;
        this.fDebuggerShell = new DebuggerShell();
        this.fBreakpointManager = new VMBreakpointManager(executorAdapter.getUnit());
        this.fTerminated = false;
    }

    @Override
    public boolean isTerminated() {
        return this.fTerminated;
    }

    @Override
    public VMEvent readVMEvent() throws IOException {
        try {
            return this.fEvents.take();
        }
        catch (InterruptedException e) {
            throw new IOException("Waiting for event interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VMResponse sendRequest(VMRequest request) throws IOException {
        try {
            if (request instanceof VMStartRequest) {
                return this.start();
            }
            if (request instanceof VMBreakpointRequest) {
                return this.handleBreakPointRequest((VMBreakpointRequest)request);
            }
            if (request instanceof VMStackFrameRequest) {
                return this.handleStackFrameRequest((VMStackFrameRequest)request);
            }
            if (request instanceof VMVariableRequest) {
                return this.handleVariableRequest((VMVariableRequest)request);
            }
            if (request instanceof VMDetailRequest) {
                return this.handleValueDetailRequest((VMDetailRequest)request);
            }
        }
        catch (RuntimeException e) {
            QVTODebugCore.log(e);
            return VMResponse.createERROR();
        }
        Object object = this.fLock;
        synchronized (object) {
            this.fRequests.add(request);
            this.fLock.notifyAll();
        }
        return VMResponse.createOK();
    }

    public IValue evaluate(String expressionText, QVTODebugTarget debugTarget, long frameID) throws CoreException {
        if (this.fInterpreter == null) {
            return null;
        }
        ASTNode astNode = this.fInterpreter.getCurrentLocation().getElement();
        if (astNode == null) {
            return null;
        }
        ConditionChecker localChecker = new ConditionChecker(expressionText, astNode);
        QVTOLocalValue.LocalValue lv = new QVTOLocalValue.LocalValue();
        lv.valueObject = localChecker.evaluate(this.fInterpreter);
        lv.valueType = localChecker.getConditionType();
        return new QVTOLocalValue(debugTarget, frameID, new String[]{expressionText}, lv, new UnitLocationExecutionContext((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.fInterpreter.getEnvironment(), this.fInterpreter.getOperationalEvaluationEnv()));
    }

    public QvtOperationalEvaluationEnv getEvaluationEnv() {
        if (this.fInterpreter == null) {
            return null;
        }
        return this.fInterpreter.getOperationalEvaluationEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMResponse start() {
        Thread executorThread = new Thread(this.createVMRunnable());
        Object object = this.fStateMonitor;
        synchronized (object) {
            if (this.fRunning) {
                return VMResponse.createERROR();
            }
            executorThread.start();
            while (!this.fRunning && !this.fTerminated) {
                try {
                    this.fStateMonitor.wait();
                }
                catch (InterruptedException e) {
                    QVTODebugCore.log(QVTODebugCore.createStatus(4, "VM startup process interrupted"));
                }
            }
        }
        return VMResponse.createOK();
    }

    private VMResponse handleStackFrameRequest(VMStackFrameRequest request) {
        if (this.fInterpreter != null) {
            List<UnitLocation> locationStack = this.fInterpreter.getLocationStack();
            VMStackFrame frame = VMStackFrame.createFrame(request.frameID, locationStack);
            VMStackFrameResponse response = new VMStackFrameResponse(frame);
            if (!locationStack.isEmpty()) {
                UnitLocation topLocation = locationStack.get(0);
                response.isDeferredExecution = topLocation.isDeferredExecution();
            }
            return response;
        }
        return VMResponse.createERROR();
    }

    private VMBreakpointResponse handleBreakPointRequest(VMBreakpointRequest request) {
        VMBreakpointRequest.ActionKind actionKind = request.getActionKind();
        if (actionKind == VMBreakpointRequest.ActionKind.ADD) {
            List<BreakpointData> allBpData = request.getBreakpointData();
            if (allBpData != null) {
                ArrayList<Long> addedBpIDs = new ArrayList<Long>();
                for (BreakpointData bpData : allBpData) {
                    if (!(bpData instanceof NewBreakpointData)) continue;
                    NewBreakpointData newBreakpoint = (NewBreakpointData)bpData;
                    VMBreakpoint breakpoint = this.fBreakpointManager.createBreakpoint(newBreakpoint);
                    if (breakpoint != null) {
                        addedBpIDs.add(new Long(newBreakpoint.ID));
                        QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "Installing breakpoing:  line:" + newBreakpoint.line + " " + newBreakpoint.targetURI);
                        continue;
                    }
                    QVTODebugCore.TRACE.trace("org.eclipse.m2m.qvt.oml.debug.core/debug/vm", "Failed to create breakpoing:  line:" + newBreakpoint.line + " " + newBreakpoint.targetURI);
                }
                return new VMBreakpointResponse(addedBpIDs);
            }
        } else if (actionKind == VMBreakpointRequest.ActionKind.REMOVE) {
            this.fBreakpointManager.removeBreakpoint(request.getBreakpointID());
        } else if (actionKind == VMBreakpointRequest.ActionKind.CHANGE) {
            this.fBreakpointManager.changeBreakpoint(request.getBreakpointID(), request.getFirstBreakpointData());
        }
        return new VMBreakpointResponse();
    }

    private VMResponse handleValueDetailRequest(VMDetailRequest request) {
        UnitLocationExecutionContext context = new UnitLocationExecutionContext((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.fInterpreter.getEnvironment(), this.fInterpreter.getCurrentLocation().getEvalEnv());
        String detail = VariableFinder.computeDetail(request.getVariableURI(), context);
        return new VMDetailResponse(detail != null ? detail : "");
    }

    private VMResponse handleVariableRequest(VMVariableRequest request) {
        UnitLocationExecutionContext context = new UnitLocationExecutionContext((Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.fInterpreter.getEnvironment(), this.fInterpreter.getCurrentLocation().getEvalEnv());
        return VariableFinder.process(request, this.fInterpreter.getLocationStack(), context);
    }

    private Runnable createVMRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                int exitCode = -1;
                try {
                    try {
                        QVTOVirtualMachine.this.fExecutor.connect(QVTOVirtualMachine.this.fDebuggerShell);
                        exitCode = QVTOVirtualMachine.execute(QVTOVirtualMachine.this.fExecutor);
                    }
                    catch (Throwable e) {
                        QVTODebugCore.log(e);
                        QVTOVirtualMachine.this.fDebuggerShell.handleVMEvent(new VMTerminateEvent(exitCode));
                    }
                }
                finally {
                    QVTOVirtualMachine.this.fDebuggerShell.handleVMEvent(new VMTerminateEvent(exitCode));
                }
            }
        };
    }

    private static int execute(DebuggableExecutorAdapter executorAdapter) {
        int exitCode = 0;
        try {
            Diagnostic diagnostic = executorAdapter.execute();
            int severity = diagnostic.getSeverity();
            if (severity == 4 || severity == 8) {
                System.err.println(diagnostic.toString());
                exitCode = -1;
            }
        }
        catch (Throwable e) {
            exitCode = -2;
            e.printStackTrace();
        }
        return exitCode;
    }

    private class DebuggerShell
    implements IQVTODebuggerShellExtension {
        private DebuggerShell() {
        }

        @Override
        public VMBreakpointManager getBreakPointManager() {
            return QVTOVirtualMachine.this.fBreakpointManager;
        }

        @Override
        public void sessionStarted(QVTODebugEvaluator evaluator) {
            QVTOVirtualMachine.this.fInterpreter = evaluator;
        }

        @Override
        public boolean isSessionStarted() {
            return QVTOVirtualMachine.this.fInterpreter != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleVMEvent(VMEvent event) {
            if (event instanceof VMStartEvent) {
                Object object = QVTOVirtualMachine.this.fStateMonitor;
                synchronized (object) {
                    QVTOVirtualMachine.this.fRunning = true;
                    QVTOVirtualMachine.this.fStateMonitor.notify();
                }
            }
            if (event instanceof VMTerminateEvent) {
                Object object = QVTOVirtualMachine.this.fStateMonitor;
                synchronized (object) {
                    QVTOVirtualMachine.this.fRunning = false;
                    QVTOVirtualMachine.this.fTerminated = true;
                    QVTOVirtualMachine.this.fStateMonitor.notify();
                }
            }
            try {
                QVTOVirtualMachine.this.fEvents.add(event);
            }
            catch (IllegalStateException e) {
                System.err.println("Event queue full!!!!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VMRequest popRequest() {
            Object object = QVTOVirtualMachine.this.fLock;
            synchronized (object) {
                return QVTOVirtualMachine.this.fRequests.isEmpty() ? null : (VMRequest)QVTOVirtualMachine.this.fRequests.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VMRequest waitAndPopRequest(VMEvent suspend) throws InterruptedException {
            this.handleVMEvent(suspend);
            Object object = QVTOVirtualMachine.this.fLock;
            synchronized (object) {
                while (QVTOVirtualMachine.this.fRequests.isEmpty()) {
                    QVTOVirtualMachine.this.fLock.wait();
                }
                return (VMRequest)QVTOVirtualMachine.this.fRequests.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VMRequest peekRequest() {
            Object object = QVTOVirtualMachine.this.fLock;
            synchronized (object) {
                return QVTOVirtualMachine.this.fRequests.isEmpty() ? null : (VMRequest)QVTOVirtualMachine.this.fRequests.get(0);
            }
        }
    }
}

