/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.controls;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.project.TransformationRegistry;
import org.eclipse.m2m.internal.qvt.oml.common.ui.controls.UniSelectTransformationControl;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class BrowseInterpretedTransformationDialog
extends SelectionStatusDialog {
    private final String myInitialTransId;
    private final TransformationRegistry myRegistry;
    private final UniSelectTransformationControl.IResourceFilter myResourceFilter;
    private final UniSelectTransformationControl.ISelectionListener mySelectionListener;
    private URI mySelectedUri;
    private UniSelectTransformationControl myControl;

    public BrowseInterpretedTransformationDialog(Shell shell, UniSelectTransformationControl.IResourceFilter resourceFilter, TransformationRegistry registry, String selectedTransId, UniSelectTransformationControl.ISelectionListener selectionListener) {
        super(shell);
        this.setTitle(Messages.BrowseInterpretedTransformationDialog_Title);
        this.setMessage(Messages.BrowseInterpretedTransformationDialog_Description);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
        this.myResourceFilter = resourceFilter;
        this.myRegistry = registry;
        this.myInitialTransId = selectedTransId;
        this.mySelectionListener = selectionListener;
    }

    public URI getSelectedUri() {
        return this.mySelectedUri;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(768));
        this.createMessageArea(composite);
        UniSelectTransformationControl.SelectionListenerAdapter selectionListener = new UniSelectTransformationControl.SelectionListenerAdapter(this.mySelectionListener){

            public IStatus selectionChanged(URI uri) {
                IStatus status = BrowseInterpretedTransformationDialog.this.mySelectionListener.selectionChanged(uri);
                BrowseInterpretedTransformationDialog.this.mySelectedUri = (URI)(status.isOK() ? uri : null);
                BrowseInterpretedTransformationDialog.this.updateStatus(status);
                return status;
            }
        };
        this.myControl = new UniSelectTransformationControl(parent, this.myResourceFilter, this.myRegistry, TransformationRegistry.TRANSFORMATION_FILTER, selectionListener);
        this.myControl.selectTransformationByUri(this.myInitialTransId);
        return this.myControl;
    }

    protected void computeResult() {
    }
}

