/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;

public class CachingResourceSetProvider
extends RefactoringResourceSetProvider {
    private final Map<IProject, ResourceSet> resourceSets = Maps.newHashMap();
    private final RefactoringResourceSetProvider delegate;

    public CachingResourceSetProvider(RefactoringResourceSetProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public ResourceSet get(IProject project) {
        ResourceSet result = this.resourceSets.get(project);
        if (result != null) {
            return result;
        }
        result = this.delegate.get(project);
        this.resourceSets.put(project, result);
        return result;
    }
}

