/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.xtend.core.XtendInjectorSingleton;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;

public class Main {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Injector injector = XtendInjectorSingleton.INJECTOR;
        XtendBatchCompiler xtendBatchCompiler = (XtendBatchCompiler)injector.getInstance(XtendBatchCompiler.class);
        if (args == null || args.length == 0) {
            Main.printUsage();
            return;
        }
        Iterator<String> arguments = Arrays.asList(args).iterator();
        while (arguments.hasNext()) {
            String argument = arguments.next();
            if ("-d".equals(argument.trim())) {
                xtendBatchCompiler.setOutputPath(arguments.next().trim());
                continue;
            }
            if ("-classpath".equals(argument.trim()) || "-cp".equals(argument.trim())) {
                xtendBatchCompiler.setClassPath(arguments.next().trim());
                continue;
            }
            if ("-tempdir".equals(argument.trim()) || "-td".equals(argument.trim())) {
                xtendBatchCompiler.setTempDirectory(arguments.next().trim());
                continue;
            }
            if ("-encoding".equals(argument.trim())) {
                xtendBatchCompiler.setFileEncoding(arguments.next().trim());
                continue;
            }
            if ("-useCurrentClassLoader".equals(argument.trim())) {
                xtendBatchCompiler.setUseCurrentClassLoaderAsParent(true);
                continue;
            }
            xtendBatchCompiler.setSourcePath(argument);
        }
        if (!xtendBatchCompiler.compile()) {
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: Main <options> <source directories>");
        System.out.println("where possible options include:");
        System.out.println("-d <directory>             Specify where to place generated xtend files");
        System.out.println("-tp <path>                 Temp directory to hold generated stubs and classes");
        System.out.println("-cp <path>                 Specify where to find user class files");
        System.out.println("-encoding <encoding>       Specify character encoding used by source files");
        System.out.println("-useCurrentClassLoader\t   Use current classloader as parent classloader");
    }
}

