/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.conversion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.ValueConverterWithValueException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRichTextValueConverter
extends AbstractLexerBasedConverter<String> {
    private List<String> trailingSubsequences;

    protected abstract String getLeadingTerminal();

    protected abstract String getTrailingTerminal();

    protected String toEscapedString(String value) {
        return String.valueOf(this.getLeadingTerminal()) + value + this.getTrailingTerminal();
    }

    protected void assertValidValue(String value) {
        super.assertValidValue((Object)value);
        if (value.indexOf(171) >= 0) {
            throw new ValueConverterException("Rich string may not contain \"\u00ab\".", null, null);
        }
        if (value.indexOf("'''") >= 0) {
            throw new ValueConverterException("Rich string may not contain \"'''\".", null, null);
        }
    }

    protected List<String> getTrailingSubsequences() {
        if (this.trailingSubsequences != null) {
            return this.trailingSubsequences;
        }
        String trailingTerminal = this.getTrailingTerminal();
        ImmutableList result = Collections.emptyList();
        if (trailingTerminal.length() >= 1) {
            LinkedHashSet unique = Sets.newLinkedHashSet();
            int i = 0;
            while (i < trailingTerminal.length() - 1) {
                this.addIfAbsent(trailingTerminal.substring(i + 1), unique);
                this.addIfAbsent(trailingTerminal.substring(0, i + 1), unique);
                ++i;
            }
            result = ImmutableList.copyOf((Collection)unique);
        }
        this.trailingSubsequences = result;
        return result;
    }

    protected void addIfAbsent(String value, Set<String> set) {
        if (!set.contains(value)) {
            set.add(value);
        }
    }

    public String toValue(String string, INode node) {
        if (string == null) {
            return null;
        }
        try {
            String trailingTerminal;
            String leadingTerminal = this.getLeadingTerminal();
            if (string.length() <= leadingTerminal.length()) {
                throw this.stringLiteralIsNotClosed(node, "");
            }
            String withoutLeadingTerminal = this.getWithoutLeadingTerminal(string);
            if (withoutLeadingTerminal.endsWith(trailingTerminal = this.getTrailingTerminal())) {
                String result = withoutLeadingTerminal.substring(0, withoutLeadingTerminal.length() - trailingTerminal.length());
                return result;
            }
            List<String> trailingSubsequences = this.getTrailingSubsequences();
            for (String subsequence : trailingSubsequences) {
                if (!withoutLeadingTerminal.endsWith(subsequence)) continue;
                throw this.stringLiteralIsNotClosed(node, withoutLeadingTerminal.substring(0, withoutLeadingTerminal.length() - subsequence.length()));
            }
            throw this.stringLiteralIsNotClosed(node, withoutLeadingTerminal.substring(0, withoutLeadingTerminal.length()));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ValueConverterException(e.getMessage(), node, (Exception)e);
        }
    }

    private ValueConverterWithValueException stringLiteralIsNotClosed(INode node, String value) {
        return new ValueConverterWithValueException("String literal is not closed", node, (Object)value, null);
    }

    protected String getWithoutLeadingTerminal(String string) {
        return string.substring(this.getLeadingTerminal().length());
    }
}

