/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.ExpressionImpl;
import org.eclipse.xtend.core.macro.declaration.JvmMemberDeclarationImpl;
import org.eclipse.xtend.lib.macro.declaration.CompilationStrategy;
import org.eclipse.xtend.lib.macro.declaration.CompilationUnit;
import org.eclipse.xtend.lib.macro.declaration.MutableExecutableDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JvmExecutableDeclarationImpl<T extends JvmExecutable>
extends JvmMemberDeclarationImpl<T>
implements MutableExecutableDeclaration {
    public Iterable<MutableTypeParameterDeclaration> getTypeParameters() {
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _typeParameters = _delegate.getTypeParameters();
        Functions.Function1<JvmTypeParameter, MutableTypeParameterDeclaration> _function = new Functions.Function1<JvmTypeParameter, MutableTypeParameterDeclaration>(){

            public MutableTypeParameterDeclaration apply(JvmTypeParameter it) {
                CompilationUnit _compilationUnit = JvmExecutableDeclarationImpl.this.getCompilationUnit();
                MutableTypeParameterDeclaration _typeParameterDeclaration = _compilationUnit.toTypeParameterDeclaration(it);
                return _typeParameterDeclaration;
            }
        };
        List _map = ListExtensions.map((List)_typeParameters, (Functions.Function1)_function);
        return _map;
    }

    public boolean isVarArgs() {
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        boolean _isVarArgs = _delegate.isVarArgs();
        return _isVarArgs;
    }

    public List<MutableParameterDeclaration> getParameters() {
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _parameters = _delegate.getParameters();
        Functions.Function1<JvmFormalParameter, MutableParameterDeclaration> _function = new Functions.Function1<JvmFormalParameter, MutableParameterDeclaration>(){

            public MutableParameterDeclaration apply(JvmFormalParameter it) {
                CompilationUnit _compilationUnit = JvmExecutableDeclarationImpl.this.getCompilationUnit();
                MutableParameterDeclaration _parameterDeclaration = _compilationUnit.toParameterDeclaration(it);
                return _parameterDeclaration;
            }
        };
        List _map = ListExtensions.map((List)_parameters, (Functions.Function1)_function);
        return _map;
    }

    public List<TypeReference> getExceptions() {
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _exceptions = _delegate.getExceptions();
        Functions.Function1<JvmTypeReference, TypeReference> _function = new Functions.Function1<JvmTypeReference, TypeReference>(){

            public TypeReference apply(JvmTypeReference it) {
                CompilationUnit _compilationUnit = JvmExecutableDeclarationImpl.this.getCompilationUnit();
                TypeReference _typeReference = _compilationUnit.toTypeReference(it);
                return _typeReference;
            }
        };
        List _map = ListExtensions.map((List)_exceptions, (Functions.Function1)_function);
        return _map;
    }

    public Expression getBody() {
        Expression _expression;
        Expression _xblockexpression = null;
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmTypesBuilder _jvmTypesBuilder = _compilationUnit.getJvmTypesBuilder();
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        XExpression expression = _jvmTypesBuilder.getExpression((JvmMember)_delegate);
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        _xblockexpression = _expression = _compilationUnit_1.toExpression(expression);
        return _xblockexpression;
    }

    public void setBody(Expression body) {
        boolean _equals = Objects.equal((Object)body, null);
        if (_equals) {
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder = _compilationUnit.getJvmTypesBuilder();
            JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
            _jvmTypesBuilder.removeExistingBody((JvmMember)_delegate);
        } else {
            CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
            JvmTypesBuilder _jvmTypesBuilder_1 = _compilationUnit_1.getJvmTypesBuilder();
            JvmExecutable _delegate_1 = (JvmExecutable)this.getDelegate();
            XExpression _delegate_2 = (XExpression)((ExpressionImpl)body).getDelegate();
            _jvmTypesBuilder_1.setBody(_delegate_1, _delegate_2);
        }
    }

    public void setExceptions(TypeReference ... exceptions) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)exceptions), "exceptions");
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _exceptions = _delegate.getExceptions();
        _exceptions.clear();
        TypeReference[] typeReferenceArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _notEquals;
            TypeReference exceptionType = typeReferenceArray[n2];
            boolean bl = _notEquals = !Objects.equal((Object)exceptionType, null);
            if (_notEquals) {
                JvmExecutable _delegate_1 = (JvmExecutable)this.getDelegate();
                EList _exceptions_1 = _delegate_1.getExceptions();
                CompilationUnit _compilationUnit = this.getCompilationUnit();
                JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(exceptionType);
                _exceptions_1.add((Object)_jvmTypeReference);
            }
            ++n2;
        }
    }

    public void setVarArgs(boolean isVarArgs) {
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        _delegate.setVarArgs(isVarArgs);
    }

    public MutableTypeParameterDeclaration addTypeParameter(String name, TypeReference ... upperBounds) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)upperBounds), "upperBounds");
        JvmTypeParameter param = TypesFactory.eINSTANCE.createJvmTypeParameter();
        param.setName(name);
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _typeParameters = _delegate.getTypeParameters();
        _typeParameters.add((Object)param);
        TypeReference[] typeReferenceArray = upperBounds;
        int n = upperBounds.length;
        int n2 = 0;
        while (n2 < n) {
            TypeReference upper = typeReferenceArray[n2];
            CompilationUnit _compilationUnit = this.getCompilationUnit();
            JvmTypeReference typeRef = _compilationUnit.toJvmTypeReference(upper);
            JvmUpperBound jvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
            jvmUpperBound.setTypeReference(typeRef);
            EList _constraints = param.getConstraints();
            _constraints.add((Object)jvmUpperBound);
            ++n2;
        }
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        return _compilationUnit.toTypeParameterDeclaration(param);
    }

    public void setBody(CompilationStrategy compilationStrategy) {
        boolean _notEquals = !Objects.equal((Object)compilationStrategy, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"compilationStrategy cannot be null");
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        _compilationUnit.setCompilationStrategy(_delegate, compilationStrategy);
    }

    public MutableParameterDeclaration addParameter(String name, TypeReference type) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        boolean _notEquals = !Objects.equal((Object)type, null);
        Preconditions.checkArgument((boolean)_notEquals, (Object)"type cannot be null");
        JvmFormalParameter param = TypesFactory.eINSTANCE.createJvmFormalParameter();
        param.setName(name);
        CompilationUnit _compilationUnit = this.getCompilationUnit();
        JvmTypeReference _jvmTypeReference = _compilationUnit.toJvmTypeReference(type);
        param.setParameterType(_jvmTypeReference);
        JvmExecutable _delegate = (JvmExecutable)this.getDelegate();
        EList _parameters = _delegate.getParameters();
        _parameters.add((Object)param);
        CompilationUnit _compilationUnit_1 = this.getCompilationUnit();
        return _compilationUnit_1.toParameterDeclaration(param);
    }
}

