/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.macro.declaration.AbstractElementImpl;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.ProblemImpl;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.services.Problem;
import org.eclipse.xtend.lib.macro.services.ProblemSupport;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemSupportImpl
implements ProblemSupport {
    private CompilationUnitImpl compilationUnit;

    public ProblemSupportImpl(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    private void checkCanceled() {
        this.compilationUnit.checkCanceled();
    }

    public void addError(Element element, String message) {
        this.checkCanceled();
        Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        Resource _key = (Resource)resAndObj.getKey();
        EList _errors = _key.getErrors();
        EObject _value = (EObject)resAndObj.getValue();
        EObject _value_1 = (EObject)resAndObj.getValue();
        EStructuralFeature _significantFeature = this.getSignificantFeature(_value_1);
        int _minus = -1;
        EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "user.issue", message, _value, _significantFeature, _minus, null);
        _errors.add((Object)_eObjectDiagnosticImpl);
    }

    public void addWarning(Element element, String message) {
        this.checkCanceled();
        Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        Resource _key = (Resource)resAndObj.getKey();
        EList _warnings = _key.getWarnings();
        EObject _value = (EObject)resAndObj.getValue();
        EObject _value_1 = (EObject)resAndObj.getValue();
        EStructuralFeature _significantFeature = this.getSignificantFeature(_value_1);
        int _minus = -1;
        EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.WARNING, "user.issue", message, _value, _significantFeature, _minus, null);
        _warnings.add((Object)_eObjectDiagnosticImpl);
    }

    public List<Problem> getProblems(Element element) {
        this.checkCanceled();
        final Pair<Resource, EObject> resAndObj = this.getResourceAndEObject(element);
        Resource resource = (Resource)resAndObj.getKey();
        EList _errors = resource.getErrors();
        EList _warnings = resource.getWarnings();
        Iterable _plus = Iterables.concat((Iterable)_errors, (Iterable)_warnings);
        Iterable issues = Iterables.filter((Iterable)_plus, EObjectDiagnosticImpl.class);
        Functions.Function1<EObjectDiagnosticImpl, Boolean> _function = new Functions.Function1<EObjectDiagnosticImpl, Boolean>(){

            public Boolean apply(EObjectDiagnosticImpl diag) {
                EObject _problematicObject = diag.getProblematicObject();
                EObject _value = (EObject)resAndObj.getValue();
                boolean _equals = Objects.equal((Object)_problematicObject, (Object)_value);
                return _equals;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function);
        Functions.Function1<EObjectDiagnosticImpl, Problem> _function_1 = new Functions.Function1<EObjectDiagnosticImpl, Problem>(){

            public Problem apply(EObjectDiagnosticImpl diag) {
                String _code = diag.getCode();
                String _message = diag.getMessage();
                Severity _severity = diag.getSeverity();
                Problem.Severity _translateSeverity = ProblemSupportImpl.this.translateSeverity(_severity);
                ProblemImpl _problemImpl = new ProblemImpl(_code, _message, _translateSeverity);
                return _problemImpl;
            }
        };
        Iterable result = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        return IterableExtensions.toList((Iterable)result);
    }

    public EStructuralFeature getSignificantFeature(EObject obj) {
        EAttribute _switchResult = null;
        boolean _matched = false;
        if (!_matched && obj instanceof XtendTypeDeclaration) {
            EAttribute _xtendTypeDeclaration_Name;
            XtendTypeDeclaration _xtendTypeDeclaration = (XtendTypeDeclaration)obj;
            _matched = true;
            _switchResult = _xtendTypeDeclaration_Name = XtendPackage.eINSTANCE.getXtendTypeDeclaration_Name();
        }
        if (!_matched && obj instanceof XtendField) {
            EAttribute _xtendField_Name;
            XtendField _xtendField = (XtendField)obj;
            _matched = true;
            _switchResult = _xtendField_Name = XtendPackage.eINSTANCE.getXtendField_Name();
        }
        if (!_matched && obj instanceof XtendFunction) {
            EAttribute _xtendFunction_Name;
            XtendFunction _xtendFunction = (XtendFunction)obj;
            _matched = true;
            _switchResult = _xtendFunction_Name = XtendPackage.eINSTANCE.getXtendFunction_Name();
        }
        if (!_matched && obj instanceof JvmFormalParameter) {
            EAttribute _jvmFormalParameter_Name;
            JvmFormalParameter _jvmFormalParameter = (JvmFormalParameter)obj;
            _matched = true;
            _switchResult = _jvmFormalParameter_Name = TypesPackage.eINSTANCE.getJvmFormalParameter_Name();
        }
        return _switchResult;
    }

    private Pair<Resource, EObject> getResourceAndEObject(Element element) {
        this.checkCanceled();
        boolean _matched = false;
        if (!_matched && element instanceof AbstractElementImpl) {
            XtendFile _xtendFile;
            Resource _eResource;
            AbstractElementImpl _abstractElementImpl = (AbstractElementImpl)element;
            _matched = true;
            EObject _delegate = (EObject)_abstractElementImpl.getDelegate();
            Resource resource = _delegate.eResource();
            boolean _equals = Objects.equal((Object)resource, (Object)(_eResource = (_xtendFile = this.compilationUnit.getXtendFile()).eResource()));
            if (_equals) {
                EObject _delegate_1;
                IXtendJvmAssociations _jvmAssociations = this.compilationUnit.getJvmAssociations();
                EObject eobject = _jvmAssociations.getPrimarySourceElement(_delegate_1 = (EObject)_abstractElementImpl.getDelegate());
                boolean _equals_1 = Objects.equal((Object)eobject, null);
                if (_equals_1) {
                    EObject _delegate_2 = (EObject)_abstractElementImpl.getDelegate();
                    return Pair.of((Object)resource, (Object)_delegate_2);
                }
                return Pair.of((Object)resource, (Object)eobject);
            }
        }
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("You can only add issues on locally declared elements.");
        throw _illegalArgumentException;
    }

    private Problem.Severity translateSeverity(Severity severity) {
        Problem.Severity _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)severity, (Object)Severity.ERROR)) {
            _matched = true;
            _switchResult = Problem.Severity.ERROR;
        }
        if (!_matched && Objects.equal((Object)severity, (Object)Severity.WARNING)) {
            _matched = true;
            _switchResult = Problem.Severity.WARNING;
        }
        if (!_matched && Objects.equal((Object)severity, (Object)Severity.INFO)) {
            _matched = true;
            _switchResult = Problem.Severity.INFO;
        }
        if (!_matched && Objects.equal((Object)severity, (Object)Severity.IGNORE)) {
            _matched = true;
            _switchResult = Problem.Severity.IGNORE;
        }
        return _switchResult;
    }
}

