/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.preferences;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;

public class EclipsePreferencesProvider
implements IPreferenceValuesProvider {
    private static final Logger log = Logger.getLogger(EclipsePreferencesProvider.class);
    @Inject
    IPreferenceStoreAccess access;

    public IPreferenceValues getPreferenceValues(Resource context) {
        IProject project = this.getProject(context);
        final IPreferenceStore store = project != null ? this.access.getContextPreferenceStore(project) : this.access.getPreferenceStore();
        final ConcurrentMap computingMap = new MapMaker().makeComputingMap((Function)new Function<String, String>(){

            public String apply(String input) {
                return store.getString(input);
            }
        });
        return new IPreferenceValues(){

            public String getPreference(PreferenceKey key) {
                try {
                    String string = (String)computingMap.get(key.getId());
                    return "".equals(string) ? key.getDefaultValue() : string;
                }
                catch (Exception e) {
                    log.error((Object)("Error getting preference for key '" + key.getId() + "'."), (Throwable)e);
                    return key.getDefaultValue();
                }
            }
        };
    }

    private IProject getProject(Resource resource) {
        IProject project;
        URI uri = resource.getURI();
        if (uri.isPlatformResource() && (project = this.getWorkspaceRoot().getProject(uri.segment(1))).isAccessible()) {
            return project;
        }
        return null;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

