/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITraceURIConverter;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DisableCodeGenerationAdapter;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ErrorSafeExtensions;
import org.eclipse.xtext.xbase.compiler.FileHeaderAdapter;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.LoopExtensions;
import org.eclipse.xtext.xbase.compiler.LoopParams;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmModelGenerator
implements IGenerator {
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    @Extension
    private TypeReferences _typeReferences;
    @Inject
    @Extension
    private TreeAppendableUtil _treeAppendableUtil;
    @Inject
    @Extension
    private JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    @Extension
    private LoopExtensions _loopExtensions;
    @Inject
    @Extension
    private ErrorSafeExtensions _errorSafeExtensions;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IFileHeaderProvider fileHeaderProvider;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private JavaKeywords keywords;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private ITraceURIConverter converter;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        for (EObject obj : _contents) {
            this.internalDoGenerate(obj, fsa);
        }
    }

    protected void _internalDoGenerate(EObject obj, IFileSystemAccess fsa) {
    }

    protected void _internalDoGenerate(JvmDeclaredType type, IFileSystemAccess fsa) {
        boolean _notEquals;
        boolean _isDisabled = DisableCodeGenerationAdapter.isDisabled(type);
        if (_isDisabled) {
            return;
        }
        String _qualifiedName = type.getQualifiedName();
        boolean bl = _notEquals = !Objects.equal((Object)_qualifiedName, null);
        if (_notEquals) {
            String _qualifiedName_1 = type.getQualifiedName();
            String _replace = _qualifiedName_1.replace(".", "/");
            String _plus = String.valueOf(_replace) + ".java";
            GeneratorConfig _get = this.generatorConfigProvider.get((EObject)type);
            CharSequence _generateType = this.generateType(type, _get);
            fsa.generateFile(_plus, _generateType);
        }
    }

    public CharSequence generateType(JvmDeclaredType type, GeneratorConfig config) {
        boolean _not;
        boolean _notEquals;
        ImportManager _importManager;
        ImportManager importManager = _importManager = new ImportManager(true, type);
        TreeAppendable bodyAppendable = this.createAppendable((EObject)type, importManager, config);
        this.generateBody(type, bodyAppendable, config);
        TreeAppendable importAppendable = this.createAppendable((EObject)type, importManager, config);
        this.generateFileHeader(type, importAppendable, config);
        String _packageName = type.getPackageName();
        boolean bl = _notEquals = !Objects.equal((Object)_packageName, null);
        if (_notEquals) {
            ITreeAppendable _append = importAppendable.append("package ");
            String _packageName_1 = type.getPackageName();
            ITreeAppendable _append_1 = _append.append(_packageName_1);
            _append_1.append(";");
            TreeAppendable _newLine = importAppendable.newLine();
            _newLine.newLine();
        }
        List<String> _imports = importManager.getImports();
        for (String i : _imports) {
            ITreeAppendable _append_2 = importAppendable.append("import ");
            ITreeAppendable _append_3 = _append_2.append(i);
            ITreeAppendable _append_4 = _append_3.append(";");
            _append_4.newLine();
        }
        List<String> _imports_1 = importManager.getImports();
        boolean _isEmpty = _imports_1.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            importAppendable.newLine();
        }
        importAppendable.append(bodyAppendable);
        return importAppendable;
    }

    protected ITreeAppendable _generateBody(JvmGenericType it, ITreeAppendable appendable, final GeneratorConfig config) {
        ITreeAppendable _newLine_1;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        final ITreeAppendable childAppendable = appendable.trace((EObject)it);
        boolean _isGenerateSyntheticSuppressWarnings = config.isGenerateSyntheticSuppressWarnings();
        if (_isGenerateSyntheticSuppressWarnings) {
            this.generateAnnotationsWithSyntheticSuppressWarnings((JvmDeclaredType)it, childAppendable, config);
        } else {
            EList _annotations = it.getAnnotations();
            this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        }
        this.generateModifier((JvmMember)it, childAppendable, config);
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            childAppendable.append("interface ");
        } else {
            childAppendable.append("class ");
        }
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, childAppendable, config);
        EList _typeParameters = it.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            childAppendable.append(" ");
        }
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        ITreeAppendable _append = childAppendable.append("{");
        _append.increaseIndentation();
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _newLine = it.newLine();
                        return _newLine;
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
            }
        };
        Procedures.Procedure1<JvmMember> _function_1 = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable memberAppendable = JvmModelGenerator.this._treeAppendableUtil.traceWithComments(childAppendable, (EObject)it);
                memberAppendable.openScope();
                JvmModelGenerator.this.generateMember(it, memberAppendable, config);
                memberAppendable.closeScope();
            }
        };
        this._loopExtensions.forEach(childAppendable, _membersToBeCompiled, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        ITreeAppendable _decreaseIndentation = childAppendable.decreaseIndentation();
        ITreeAppendable _newLine = _decreaseIndentation.newLine();
        _newLine.append("}");
        _xblockexpression = _newLine_1 = appendable.newLine();
        return _xblockexpression;
    }

    public ITreeAppendable generateAnnotationsWithSyntheticSuppressWarnings(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _newLine;
        Functions.Function1<JvmAnnotationReference, Boolean> _function;
        ITreeAppendable _xblockexpression = null;
        Functions.Function1<JvmAnnotationReference, Boolean> noSuppressWarningsFilter = _function = new Functions.Function1<JvmAnnotationReference, Boolean>(){

            public Boolean apply(JvmAnnotationReference it) {
                String _name;
                JvmAnnotationType _annotation = it.getAnnotation();
                String _identifier = null;
                if (_annotation != null) {
                    _identifier = _annotation.getIdentifier();
                }
                boolean _notEquals = !Objects.equal((Object)_identifier, (Object)(_name = SuppressWarnings.class.getName()));
                return _notEquals;
            }
        };
        EList _annotations = it.getAnnotations();
        Iterable _filter = IterableExtensions.filter((Iterable)_annotations, (Functions.Function1)noSuppressWarningsFilter);
        this.generateAnnotations(_filter, appendable, true, config);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"@SuppressWarnings(\"all\")");
        ITreeAppendable _append = appendable.append((CharSequence)_builder);
        _xblockexpression = _newLine = _append.newLine();
        return _xblockexpression;
    }

    protected ITreeAppendable _generateBody(JvmEnumerationType it, ITreeAppendable appendable, final GeneratorConfig config) {
        ITreeAppendable _newLine_1;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        final ITreeAppendable childAppendable = appendable.trace((EObject)it);
        boolean _isGenerateSyntheticSuppressWarnings = config.isGenerateSyntheticSuppressWarnings();
        if (_isGenerateSyntheticSuppressWarnings) {
            this.generateAnnotationsWithSyntheticSuppressWarnings((JvmDeclaredType)it, childAppendable, config);
        } else {
            EList _annotations = it.getAnnotations();
            this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        }
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("enum ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        childAppendable.append(" ");
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable, config);
        ITreeAppendable _append = childAppendable.append("{");
        _append.increaseIndentation();
        EList _literals = it.getLiterals();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _append = it.append(",");
                        ITreeAppendable _newLine = _append.newLine();
                        return _newLine;
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
                it.setSuffix(";");
            }
        };
        Procedures.Procedure1<JvmEnumerationLiteral> _function_1 = new Procedures.Procedure1<JvmEnumerationLiteral>(){

            public void apply(JvmEnumerationLiteral it) {
                ITreeAppendable _trace = childAppendable.trace((EObject)it);
                JvmModelGenerator.this.generateEnumLiteral(it, _trace, config);
            }
        };
        this._loopExtensions.forEach(childAppendable, _literals, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Functions.Function1<JvmMember, Boolean> _function_2 = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _not = !(it instanceof JvmEnumerationLiteral);
                return _not;
            }
        };
        Iterable _filter = IterableExtensions.filter(_membersToBeCompiled, (Functions.Function1)_function_2);
        Procedures.Procedure1<LoopParams> _function_3 = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _newLine = it.newLine();
                        return _newLine;
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
            }
        };
        Procedures.Procedure1<JvmMember> _function_4 = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable _trace = childAppendable.trace((EObject)it);
                JvmModelGenerator.this.generateMember(it, _trace, config);
            }
        };
        this._loopExtensions.forEach(childAppendable, _filter, (Procedures.Procedure1<? super LoopParams>)_function_3, _function_4);
        ITreeAppendable _decreaseIndentation = childAppendable.decreaseIndentation();
        ITreeAppendable _newLine = _decreaseIndentation.newLine();
        _newLine.append("}");
        _xblockexpression = _newLine_1 = appendable.newLine();
        return _xblockexpression;
    }

    public void generateEnumLiteral(JvmEnumerationLiteral it, ITreeAppendable appendable, GeneratorConfig config) {
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, appendable, true, config);
        String _simpleName = it.getSimpleName();
        appendable.append(_simpleName);
    }

    protected ITreeAppendable _generateBody(JvmAnnotationType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _newLine_1;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable childAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, childAppendable, true, config);
        this.generateModifier((JvmMember)it, childAppendable, config);
        childAppendable.append("@interface ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        childAppendable.append(" {");
        Iterable<JvmMember> _membersToBeCompiled = this.getMembersToBeCompiled((JvmDeclaredType)it);
        Iterable _filter = Iterables.filter(_membersToBeCompiled, JvmOperation.class);
        for (JvmOperation operation : _filter) {
            this.generateAnnotationMethod(operation, childAppendable, config);
        }
        ITreeAppendable _newLine = childAppendable.newLine();
        _newLine.append("}");
        _xblockexpression = _newLine_1 = appendable.newLine();
        return _xblockexpression;
    }

    public void generateAnnotationMethod(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        JvmTypeReference _returnType = it.getReturnType();
        this._errorSafeExtensions.serializeSafely(_returnType, "Object", tracedAppendable);
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        tracedAppendable.append("()");
        this.generateDefaultExpression(it, tracedAppendable, config);
        tracedAppendable.append(";");
        appendable.decreaseIndentation();
        appendable.closeScope();
    }

    public void generateDefaultExpression(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            appendable.append(" default ");
            appendable.increaseIndentation();
            Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
            _compilationStrategy_1.apply((Object)appendable);
            appendable.decreaseIndentation();
        } else {
            boolean _isGenerateExpressions = config.isGenerateExpressions();
            if (_isGenerateExpressions) {
                boolean _notEquals_1;
                XExpression body = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)body, null);
                if (_notEquals_1) {
                    boolean _hasErrors = this._errorSafeExtensions.hasErrors(body);
                    if (_hasErrors) {
                        appendable.append("/* skipped default expression with errors */");
                    } else {
                        appendable.append(" default ");
                        JvmTypeReference _returnType = it.getReturnType();
                        this.compiler.compileAsJavaExpression(body, appendable, _returnType);
                    }
                } else {
                    boolean _notEquals_2;
                    JvmAnnotationValue _defaultValue = it.getDefaultValue();
                    boolean bl3 = _notEquals_2 = !Objects.equal((Object)_defaultValue, null);
                    if (_notEquals_2) {
                        JvmAnnotationValue _defaultValue_1 = it.getDefaultValue();
                        boolean _hasErrors_1 = this._errorSafeExtensions.hasErrors((EObject)_defaultValue_1);
                        if (_hasErrors_1) {
                            appendable.append("/* skipped default expression with errors */");
                        } else {
                            appendable.append(" default ");
                            JvmAnnotationValue _defaultValue_2 = it.getDefaultValue();
                            this.toJavaLiteral(_defaultValue_2, appendable, config);
                        }
                    }
                }
            }
        }
    }

    protected ITreeAppendable _generateModifier(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isFinal;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isStrictFloatingPoint = it.isStrictFloatingPoint();
        if (_isStrictFloatingPoint) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("strictfp ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        ITreeAppendable _append = appendable.append(_javaName);
        return _append;
    }

    protected ITreeAppendable _generateModifier(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isTransient;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            appendable.append("final ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        if (_isTransient = it.isTransient()) {
            appendable.append("transient ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isVolatile = it.isVolatile();
        if (_isVolatile) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("volatile ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isStrictFloatingPoint;
        boolean _isSynchronized;
        boolean _isFinal;
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        if (_isFinal = it.isFinal()) {
            appendable.append("final ");
        }
        if (_isSynchronized = it.isSynchronized()) {
            appendable.append("synchronized ");
        }
        if (_isStrictFloatingPoint = it.isStrictFloatingPoint()) {
            appendable.append("strictfp ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isNative = it.isNative();
        if (_isNative) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("native ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        ITreeAppendable _append = appendable.append(_javaName);
        return _append;
    }

    public String javaName(JvmVisibility visibility) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)visibility, null);
        if (_notEquals) {
            String _switchResult = null;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PRIVATE)) {
                _matched = true;
                _switchResult = "private ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PUBLIC)) {
                _matched = true;
                _switchResult = "public ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PROTECTED)) {
                _matched = true;
                _switchResult = "protected ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.DEFAULT)) {
                _matched = true;
                _switchResult = "";
            }
            return _switchResult;
        }
        return "";
    }

    public void generateExtendsClause(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && it instanceof JvmAnnotationType) {
            JvmAnnotationType _jvmAnnotationType = (JvmAnnotationType)it;
            _matched = true;
            _switchResult = "java.lang.Annotation";
        }
        if (!_matched && it instanceof JvmEnumerationType) {
            String _string;
            JvmEnumerationType _jvmEnumerationType = (JvmEnumerationType)it;
            _matched = true;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"java.lang.Enum<");
            String _identifier = _jvmEnumerationType.getIdentifier();
            _builder.append((Object)_identifier, "");
            _builder.append((Object)">");
            _switchResult = _string = _builder.toString();
        }
        if (!_matched) {
            _switchResult = "java.lang.Object";
        }
        final String implicitSuperType = _switchResult;
        boolean _or = false;
        if (it instanceof JvmAnnotationType) {
            _or = true;
        } else {
            boolean _and = false;
            if (!(it instanceof JvmGenericType)) {
                _and = false;
            } else {
                boolean _isInterface = ((JvmGenericType)it).isInterface();
                _and = it instanceof JvmGenericType && _isInterface;
            }
            boolean bl = _or = it instanceof JvmAnnotationType || _and;
        }
        if (_or) {
            EList _superTypes = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    boolean _notEquals = !Objects.equal((Object)_identifier, (Object)implicitSuperType);
                    return _notEquals;
                }
            };
            Iterable withoutObject = IterableExtensions.filter((Iterable)_superTypes, (Functions.Function1)_function);
            Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>(){

                public void apply(LoopParams it) {
                    it.setPrefix("extends ");
                    it.setSeparator(", ");
                    it.setSuffix(" ");
                }
            };
            Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

                public void apply(JvmTypeReference it, ITreeAppendable app) {
                    JvmModelGenerator.this._errorSafeExtensions.serializeSafely(it, app);
                }
            };
            this._errorSafeExtensions.forEachSafely(appendable, withoutObject, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
        } else {
            boolean _notEquals;
            EList _superTypes_1 = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function_3 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    boolean _notEquals = !Objects.equal((Object)_identifier, (Object)implicitSuperType);
                    return _notEquals;
                }
            };
            Iterable withoutObject_1 = IterableExtensions.filter((Iterable)_superTypes_1, (Functions.Function1)_function_3);
            Functions.Function1<JvmTypeReference, Boolean> _function_4 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _and = false;
                    JvmType _type = typeRef.getType();
                    if (!(_type instanceof JvmGenericType)) {
                        _and = false;
                    } else {
                        JvmType _type_1 = typeRef.getType();
                        boolean _isInterface = ((JvmGenericType)_type_1).isInterface();
                        boolean _not = !_isInterface;
                        _and = _type instanceof JvmGenericType && _not;
                    }
                    return _and;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_4);
            final JvmTypeReference superClazz = (JvmTypeReference)IterableExtensions.head((Iterable)_filter);
            Functions.Function1<JvmTypeReference, Boolean> _function_5 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _notEquals = !Objects.equal((Object)typeRef, (Object)superClazz);
                    return _notEquals;
                }
            };
            Iterable superInterfaces = IterableExtensions.filter((Iterable)withoutObject_1, (Functions.Function1)_function_5);
            boolean bl = _notEquals = !Objects.equal((Object)superClazz, null);
            if (_notEquals) {
                boolean hasErrors = this._errorSafeExtensions.hasErrors((EObject)superClazz);
                if (hasErrors) {
                    appendable.append("/* ");
                }
                try {
                    appendable.append("extends ");
                    this._errorSafeExtensions.serializeSafely(superClazz, appendable);
                    appendable.append(" ");
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception exception = (Exception)_t;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                if (hasErrors) {
                    appendable.append(" */");
                }
            }
            Procedures.Procedure1<LoopParams> _function_6 = new Procedures.Procedure1<LoopParams>(){

                public void apply(LoopParams it) {
                    it.setPrefix("implements ");
                    it.setSeparator(", ");
                    it.setSuffix(" ");
                }
            };
            Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_7 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

                public void apply(JvmTypeReference it, ITreeAppendable app) {
                    JvmModelGenerator.this._errorSafeExtensions.serializeSafely(it, app);
                }
            };
            this._errorSafeExtensions.forEachSafely(appendable, superInterfaces, (Procedures.Procedure1<? super LoopParams>)_function_6, _function_7);
        }
    }

    protected ITreeAppendable _generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        Class<?> _class = null;
        if (it != null) {
            _class = it.getClass();
        }
        String _name = null;
        if (_class != null) {
            _name = _class.getName();
        }
        String _plus = "generateMember not implemented for elements of type " + _name;
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_plus);
        throw _unsupportedOperationException;
    }

    protected ITreeAppendable _generateMember(JvmGenericType it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _generateBody;
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        _xblockexpression = _generateBody = this.generateBody((JvmDeclaredType)it, appendable, config);
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _append;
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        JvmTypeReference _type = it.getType();
        this._errorSafeExtensions.serializeSafely(_type, "Object", tracedAppendable);
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        this.generateInitialization(it, tracedAppendable, config);
        _xblockexpression = _append = tracedAppendable.append(";");
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmOperation it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        JvmTypeReference _returnType = it.getReturnType();
        boolean _equals = Objects.equal((Object)_returnType, null);
        if (_equals) {
            tracedAppendable.append("void");
        } else {
            JvmTypeReference _returnType_1 = it.getReturnType();
            this._errorSafeExtensions.serializeSafely(_returnType_1, "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        boolean _or = false;
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            _or = true;
        } else {
            boolean _hasBody = this.hasBody((JvmExecutable)it);
            boolean _not = !_hasBody;
            boolean bl = _or = _isAbstract || _not;
        }
        if (_or) {
            tracedAppendable.append(";");
        } else {
            tracedAppendable.append(" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        }
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateMember(JvmConstructor it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable _xblockexpression = null;
        appendable.newLine();
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable, config);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, true, config);
        this.generateModifier((JvmMember)it, tracedAppendable, config);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable, config);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable, config);
        tracedAppendable.append(" ");
        this.generateExecutableBody((JvmExecutable)it, tracedAppendable, config);
        appendable.closeScope();
        _xblockexpression = appendable;
        return _xblockexpression;
    }

    public void generateInitialization(JvmField it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            appendable.append(" = ");
            appendable.increaseIndentation();
            Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
            _compilationStrategy_1.apply((Object)appendable);
            appendable.decreaseIndentation();
        } else {
            boolean _notEquals_1;
            XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
            boolean _and = false;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)expression, null);
            if (!_notEquals_1) {
                _and = false;
            } else {
                boolean _isGenerateExpressions = config.isGenerateExpressions();
                boolean bl3 = _and = _notEquals_1 && _isGenerateExpressions;
            }
            if (_and) {
                boolean _hasErrors = this._errorSafeExtensions.hasErrors(expression);
                if (_hasErrors) {
                    appendable.append(" /* Skipped initializer because of errors */");
                } else {
                    appendable.append(" = ");
                    JvmTypeReference _type = it.getType();
                    this.compiler.compileAsJavaExpression(expression, appendable, _type);
                }
            }
        }
    }

    public void generateTypeParameterDeclaration(JvmTypeParameterDeclarator it, final ITreeAppendable appendable, final GeneratorConfig config) {
        EList _typeParameters = it.getTypeParameters();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix("<");
                it.setSeparator(", ");
                it.setSuffix("> ");
            }
        };
        Procedures.Procedure1<JvmTypeParameter> _function_1 = new Procedures.Procedure1<JvmTypeParameter>(){

            public void apply(JvmTypeParameter it) {
                JvmModelGenerator.this.generateTypeParameterDeclaration(it, appendable, config);
            }
        };
        this._loopExtensions.forEach(appendable, _typeParameters, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateTypeParameterDeclaration(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _name = it.getName();
        _traceSignificant.append(_name);
        this.generateTypeParameterConstraints(it, tracedAppendable, config);
    }

    public void generateTypeParameterConstraints(JvmTypeParameter it, ITreeAppendable appendable, GeneratorConfig config) {
        EList _constraints = it.getConstraints();
        Iterable upperBounds = Iterables.filter((Iterable)_constraints, JvmUpperBound.class);
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix(" extends ");
                it.setSeparator(" & ");
            }
        };
        Procedures.Procedure2<JvmUpperBound, ITreeAppendable> _function_1 = new Procedures.Procedure2<JvmUpperBound, ITreeAppendable>(){

            public void apply(JvmUpperBound it, ITreeAppendable app) {
                JvmTypeReference _typeReference = it.getTypeReference();
                JvmModelGenerator.this._errorSafeExtensions.serializeSafely(_typeReference, app);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, upperBounds, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateThrowsClause(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        final LinkedHashMap toBeGenerated = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        EList _exceptions = it.getExceptions();
        Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

            public void apply(JvmTypeReference it) {
                boolean _not;
                JvmType _type = it.getType();
                boolean _containsKey = toBeGenerated.containsKey(_type);
                boolean bl = _not = !_containsKey;
                if (_not) {
                    JvmType _type_1 = it.getType();
                    toBeGenerated.put(_type_1, it);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_exceptions, (Procedures.Procedure1)_function);
        Collection _values = toBeGenerated.values();
        Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix(" throws ");
                it.setSeparator(", ");
            }
        };
        Procedures.Procedure2<JvmTypeReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmTypeReference, ITreeAppendable>(){

            public void apply(JvmTypeReference it, ITreeAppendable app) {
                ITreeAppendable _trace = app.trace((EObject)it);
                JvmType _type = it.getType();
                _trace.append(_type);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, _values, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateParameters(JvmExecutable it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        EList _parameters = it.getParameters();
        boolean _isEmpty = _parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _parameters_1 = it.getParameters();
            int _size = _parameters_1.size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _not_1;
                EList _parameters_2;
                int _size_1;
                int _plus = i + 1;
                boolean last = _plus == (_size_1 = (_parameters_2 = it.getParameters()).size());
                EList _parameters_3 = it.getParameters();
                JvmFormalParameter p = (JvmFormalParameter)_parameters_3.get(i.intValue());
                boolean _and = false;
                if (!last) {
                    _and = false;
                } else {
                    boolean _isVarArgs = it.isVarArgs();
                    _and = last && _isVarArgs;
                }
                this.generateParameter(p, appendable, _and, config);
                boolean bl2 = _not_1 = !last;
                if (!_not_1) continue;
                appendable.append(", ");
            }
        }
    }

    public void generateParameter(JvmFormalParameter it, ITreeAppendable appendable, boolean vararg, GeneratorConfig config) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        EList _annotations = it.getAnnotations();
        this.generateAnnotations((Iterable<JvmAnnotationReference>)_annotations, tracedAppendable, false, config);
        tracedAppendable.append("final ");
        if (vararg) {
            boolean _not;
            JvmTypeReference _parameterType = it.getParameterType();
            boolean bl = _not = !(_parameterType instanceof JvmGenericArrayTypeReference);
            if (_not) {
                tracedAppendable.append("/* Internal Error: Parameter was vararg but not an array type. */");
            } else {
                JvmTypeReference _parameterType_1 = it.getParameterType();
                JvmTypeReference _componentType = ((JvmGenericArrayTypeReference)_parameterType_1).getComponentType();
                this._errorSafeExtensions.serializeSafely(_componentType, "Object", tracedAppendable);
            }
            tracedAppendable.append("...");
        } else {
            JvmTypeReference _parameterType_2 = it.getParameterType();
            this._errorSafeExtensions.serializeSafely(_parameterType_2, "Object", tracedAppendable);
        }
        tracedAppendable.append(" ");
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        String name = tracedAppendable.declareVariable(it, _makeJavaIdentifier);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        _traceSignificant.append(name);
    }

    public boolean hasBody(JvmExecutable op) {
        boolean _notEquals;
        boolean _or = false;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            _or = true;
        } else {
            XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
            boolean _notEquals_1 = !Objects.equal((Object)_associatedExpression, null);
            _or = _notEquals || _notEquals_1;
        }
        return _or;
    }

    public void generateExecutableBody(JvmExecutable op, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            Iterable<Issue> errors = this._errorSafeExtensions.getErrors((EObject)op);
            boolean _isEmpty = IterableExtensions.isEmpty(errors);
            if (_isEmpty) {
                ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
                ITreeAppendable _append = _increaseIndentation.append("{");
                _append.newLine();
                Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
                _compilationStrategy_1.apply((Object)appendable);
                ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
                ITreeAppendable _newLine = _decreaseIndentation.newLine();
                _newLine.append("}");
            } else {
                this.generateBodyWithIssues(appendable, errors);
            }
        } else {
            boolean _notEquals_1;
            XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
            boolean _and = false;
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)expression, null);
            if (!_notEquals_1) {
                _and = false;
            } else {
                boolean _isGenerateExpressions = config.isGenerateExpressions();
                boolean bl3 = _and = _notEquals_1 && _isGenerateExpressions;
            }
            if (_and) {
                Iterable<Issue> errors_1 = this._errorSafeExtensions.getErrors(expression);
                boolean _isEmpty_1 = IterableExtensions.isEmpty(errors_1);
                if (_isEmpty_1) {
                    JvmTypeReference _switchResult = null;
                    boolean _matched = false;
                    if (!_matched && op instanceof JvmOperation) {
                        JvmTypeReference _returnType;
                        JvmOperation _jvmOperation = (JvmOperation)op;
                        _matched = true;
                        _switchResult = _returnType = _jvmOperation.getReturnType();
                    }
                    if (!_matched && op instanceof JvmConstructor) {
                        JvmTypeReference _typeForName;
                        JvmConstructor _jvmConstructor = (JvmConstructor)op;
                        _matched = true;
                        _switchResult = _typeForName = this._typeReferences.getTypeForName(Void.TYPE, (Notifier)_jvmConstructor, new JvmTypeReference[0]);
                    }
                    if (!_matched) {
                        _switchResult = null;
                    }
                    JvmTypeReference returnType = _switchResult;
                    boolean _and_1 = false;
                    boolean _and_2 = false;
                    if (!(expression instanceof XBlockExpression)) {
                        _and_2 = false;
                    } else {
                        EList<XExpression> _expressions = ((XBlockExpression)expression).getExpressions();
                        int _size = _expressions.size();
                        boolean _notEquals_2 = _size != 1;
                        boolean bl4 = _and_2 = expression instanceof XBlockExpression && _notEquals_2;
                    }
                    if (!_and_2) {
                        _and_1 = false;
                    } else {
                        boolean bl5 = _and_1 = _and_2 && returnType instanceof JvmVoid;
                    }
                    if (_and_1) {
                        XBlockExpression block = (XBlockExpression)expression;
                        EList<XExpression> _expressions_1 = block.getExpressions();
                        boolean _isEmpty_2 = _expressions_1.isEmpty();
                        if (_isEmpty_2) {
                            appendable.append("{}");
                        } else {
                            EList _exceptions = op.getExceptions();
                            Set _set = IterableExtensions.toSet((Iterable)_exceptions);
                            this.compiler.compile(expression, appendable, returnType, _set);
                        }
                    } else {
                        ITreeAppendable _append_1 = appendable.append("{");
                        _append_1.increaseIndentation();
                        EList _exceptions_1 = op.getExceptions();
                        Set _set_1 = IterableExtensions.toSet((Iterable)_exceptions_1);
                        this.compiler.compile(expression, appendable, returnType, _set_1);
                        ITreeAppendable _decreaseIndentation_1 = appendable.decreaseIndentation();
                        ITreeAppendable _newLine_1 = _decreaseIndentation_1.newLine();
                        _newLine_1.append("}");
                    }
                } else {
                    this.generateBodyWithIssues(appendable, errors_1);
                }
            } else if (op instanceof JvmOperation) {
                ITreeAppendable _increaseIndentation_1 = appendable.increaseIndentation();
                ITreeAppendable _append_2 = _increaseIndentation_1.append("{");
                _append_2.newLine();
                appendable.append("throw new UnsupportedOperationException(\"");
                String _simpleName = op.getSimpleName();
                appendable.append(_simpleName);
                appendable.append(" is not implemented\");");
                ITreeAppendable _decreaseIndentation_2 = appendable.decreaseIndentation();
                ITreeAppendable _newLine_2 = _decreaseIndentation_2.newLine();
                _newLine_2.append("}");
            } else if (op instanceof JvmConstructor) {
                ITreeAppendable _append_3 = appendable.append("{");
                ITreeAppendable _newLine_3 = _append_3.newLine();
                _newLine_3.append("}");
            }
        }
    }

    public ITreeAppendable generateBodyWithIssues(final ITreeAppendable appendable, Iterable<Issue> errors) {
        ITreeAppendable _append_2;
        ITreeAppendable _xblockexpression = null;
        ITreeAppendable _append = appendable.append("{");
        ITreeAppendable _increaseIndentation = _append.increaseIndentation();
        ITreeAppendable _newLine = _increaseIndentation.newLine();
        _newLine.append("throw new Error(\"Unresolved compilation problems:\"");
        appendable.increaseIndentation();
        Procedures.Procedure1<Issue> _function = new Procedures.Procedure1<Issue>(){

            public void apply(Issue it) {
                ITreeAppendable _newLine = appendable.newLine();
                ITreeAppendable _append = _newLine.append("+ \"\\n");
                String _message = it.getMessage();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_message);
                ITreeAppendable _append_1 = _append.append(_doConvertToJavaString);
                _append_1.append("\"");
            }
        };
        IterableExtensions.forEach(errors, (Procedures.Procedure1)_function);
        ITreeAppendable _append_1 = appendable.append(");");
        ITreeAppendable _decreaseIndentation = _append_1.decreaseIndentation();
        ITreeAppendable _decreaseIndentation_1 = _decreaseIndentation.decreaseIndentation();
        ITreeAppendable _newLine_1 = _decreaseIndentation_1.newLine();
        _xblockexpression = _append_2 = _newLine_1.append("}");
        return _xblockexpression;
    }

    protected String doConvertToJavaString(String input) {
        String _convertToJavaString = Strings.convertToJavaString((String)input, (boolean)true);
        return _convertToJavaString;
    }

    public void generateFileHeader(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isNullOrEmpty;
        boolean _not;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, FileHeaderAdapter.class);
        FileHeaderAdapter fileHeaderAdapter = (FileHeaderAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _headerText = null;
        if (fileHeaderAdapter != null) {
            _headerText = fileHeaderAdapter.getHeaderText();
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_headerText));
        if (_not) {
            String _headerText_1 = fileHeaderAdapter.getHeaderText();
            Resource _eResource = it.eResource();
            List _fileHeaderNodes = this.fileHeaderProvider.getFileHeaderNodes(_eResource);
            this.generateDocumentation(_headerText_1, _fileHeaderNodes, appendable, config);
        }
    }

    public void generateJavaDoc(EObject it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _isNullOrEmpty;
        boolean _not;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = (DocumentationAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _documentation = null;
        if (adapter != null) {
            _documentation = adapter.getDocumentation();
        }
        boolean bl = _not = !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_documentation));
        if (_not) {
            boolean _equals;
            Set<EObject> sourceElements = this.jvmModelAssociations.getSourceElements(it);
            boolean _and = false;
            int _size = sourceElements.size();
            boolean bl2 = _equals = _size == 1;
            if (!_equals) {
                _and = false;
            } else {
                boolean bl3 = _and = _equals && this.documentationProvider instanceof IEObjectDocumentationProviderExtension;
            }
            if (_and) {
                EObject _head = (EObject)IterableExtensions.head(sourceElements);
                List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes(_head);
                this.addJavaDocImports(it, appendable, documentationNodes);
                String _documentation_1 = adapter.getDocumentation();
                this.generateDocumentation(_documentation_1, documentationNodes, appendable, config);
            } else {
                String _documentation_2 = adapter.getDocumentation();
                List _emptyList = CollectionLiterals.emptyList();
                this.generateDocumentation(_documentation_2, _emptyList, appendable, config);
            }
        }
    }

    public void addJavaDocImports(EObject it, ITreeAppendable appendable, List<INode> documentationNodes) {
        for (INode node : documentationNodes) {
            List _computeTypeRefRegions = this.javaDocTypeReferenceProvider.computeTypeRefRegions(node);
            for (ReplaceRegion region : _computeTypeRefRegions) {
                String _packageName_1;
                boolean _notEquals_3;
                boolean _notEquals_2;
                boolean _equals;
                boolean _notEquals;
                String text = region.getText();
                boolean _and = false;
                boolean bl = _notEquals = !Objects.equal((Object)text, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    int _length = text.length();
                    boolean _greaterThan = _length > 0;
                    boolean bl2 = _and = _notEquals && _greaterThan;
                }
                if (!_and) continue;
                QualifiedName fqn = this.qualifiedNameConverter.toQualifiedName(text);
                EObject context = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                boolean _and_1 = false;
                int _segmentCount = fqn.getSegmentCount();
                boolean bl3 = _equals = _segmentCount == 1;
                if (!_equals) {
                    _and_1 = false;
                } else {
                    boolean _notEquals_1 = !Objects.equal((Object)context, null);
                    boolean bl4 = _and_1 = _equals && _notEquals_1;
                }
                if (!_and_1) continue;
                IScope scope = this.scopeProvider.getScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE);
                IEObjectDescription candidate = scope.getSingleElement(fqn);
                boolean bl5 = _notEquals_2 = !Objects.equal((Object)candidate, null);
                if (!_notEquals_2) continue;
                EObject _xifexpression = null;
                EObject _eObjectOrProxy = candidate.getEObjectOrProxy();
                boolean _eIsProxy = _eObjectOrProxy.eIsProxy();
                if (_eIsProxy) {
                    EObject _resolve;
                    EObject _eObjectOrProxy_1 = candidate.getEObjectOrProxy();
                    _xifexpression = _resolve = EcoreUtil.resolve((EObject)_eObjectOrProxy_1, (EObject)context);
                } else {
                    EObject _eObjectOrProxy_2;
                    _xifexpression = _eObjectOrProxy_2 = candidate.getEObjectOrProxy();
                }
                JvmType jvmType = (JvmType)_xifexpression;
                boolean _and_2 = false;
                if (!(jvmType instanceof JvmDeclaredType)) {
                    _and_2 = false;
                } else {
                    boolean _eIsProxy_1 = jvmType.eIsProxy();
                    boolean _not = !_eIsProxy_1;
                    boolean bl6 = _and_2 = jvmType instanceof JvmDeclaredType && _not;
                }
                if (!_and_2) continue;
                JvmDeclaredType referencedType = (JvmDeclaredType)jvmType;
                JvmDeclaredType contextDeclarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)it, JvmDeclaredType.class);
                String _packageName = referencedType.getPackageName();
                boolean bl7 = _notEquals_3 = !Objects.equal((Object)_packageName, (Object)(_packageName_1 = contextDeclarator.getPackageName()));
                if (!_notEquals_3) continue;
                ImportManager importManager = this.getImportManager(appendable);
                importManager.addImportFor(jvmType);
            }
        }
    }

    public ImportManager getImportManager(ITreeAppendable appendable) {
        try {
            ImportManager _xblockexpression = null;
            Class<?> _class = appendable.getClass();
            Field stateField = _class.getDeclaredField("state");
            stateField.setAccessible(true);
            Object stateValue = stateField.get(appendable);
            Class<?> _class_1 = stateValue.getClass();
            Field importManagerField = _class_1.getDeclaredField("importManager");
            importManagerField.setAccessible(true);
            Object _get = importManagerField.get(stateValue);
            _xblockexpression = (ImportManager)_get;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected ITreeAppendable generateDocumentation(String text, List<INode> documentationNodes, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _not;
        ITreeAppendable _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        StringConcatenation doc = _builder;
        doc.newLine();
        doc.append((Object)" * ");
        doc.append((Object)text, " * ");
        doc.newLine();
        doc.append((Object)" */");
        ITreeAppendable _xifexpression = null;
        boolean _isEmpty = documentationNodes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ITreeAppendable _newLine;
            ITreeAppendable _xblockexpression_1 = null;
            ITextRegionWithLineInformation documentationTrace = ITextRegionWithLineInformation.EMPTY_REGION;
            for (INode node : documentationNodes) {
                ITextRegionWithLineInformation _merge;
                int _offset = node.getOffset();
                int _length = node.getLength();
                int _startLine = node.getStartLine();
                int _endLine = node.getEndLine();
                TextRegionWithLineInformation _textRegionWithLineInformation = new TextRegionWithLineInformation(_offset, _length, _startLine, _endLine);
                documentationTrace = _merge = documentationTrace.merge((ITextRegionWithLineInformation)_textRegionWithLineInformation);
            }
            LocationData _locationData = new LocationData(documentationTrace, null);
            ITreeAppendable _trace = appendable.trace((ILocationData)_locationData);
            String _string = doc.toString();
            _trace.append(_string);
            _xifexpression = _xblockexpression_1 = (_newLine = appendable.newLine());
        } else {
            ITreeAppendable _newLine;
            String _string = doc.toString();
            ITreeAppendable _append = appendable.append(_string);
            _xifexpression = _newLine = _append.newLine();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void generateAnnotations(Iterable<JvmAnnotationReference> annotations, ITreeAppendable appendable, final boolean withLineBreak, final GeneratorConfig config) {
        Functions.Function1<ITreeAppendable, ITreeAppendable> _function;
        Functions.Function1<ITreeAppendable, ITreeAppendable> sep = _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

            public ITreeAppendable apply(ITreeAppendable it) {
                ITreeAppendable _append;
                ITreeAppendable _newLine;
                ITreeAppendable _xifexpression = null;
                _xifexpression = withLineBreak ? (_newLine = it.newLine()) : (_append = it.append(" "));
                return _xifexpression;
            }
        };
        Procedures.Procedure1<LoopParams> _function_1 = new Procedures.Procedure1<LoopParams>((Functions.Function1)sep){
            private final /* synthetic */ Functions.Function1 val$sep;
            {
                this.val$sep = function1;
            }

            public void apply(LoopParams it) {
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)this.val$sep);
                it.setSuffix((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)this.val$sep);
            }
        };
        Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable> _function_2 = new Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable>(){

            public void apply(JvmAnnotationReference it, ITreeAppendable app) {
                JvmModelGenerator.this.generateAnnotation(it, app, config);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, annotations, (Procedures.Procedure1<? super LoopParams>)_function_1, _function_2);
    }

    public void generateAnnotations(JvmAnnotationAnnotationValue it, ITreeAppendable appendable, final boolean withLineBreak, final GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _xifexpression = null;
                        if (withLineBreak) {
                            ITreeAppendable _newLine;
                            ITreeAppendable _append = it.append(",");
                            _xifexpression = _newLine = _append.newLine();
                        } else {
                            ITreeAppendable _append_1;
                            _xifexpression = _append_1 = it.append(", ");
                        }
                        return _xifexpression;
                    }
                };
                it.setSeparator((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function);
                Functions.Function1<ITreeAppendable, ITreeAppendable> _function_1 = new Functions.Function1<ITreeAppendable, ITreeAppendable>(){

                    public ITreeAppendable apply(ITreeAppendable it) {
                        ITreeAppendable _xifexpression = null;
                        if (withLineBreak) {
                            ITreeAppendable _newLine;
                            _xifexpression = _newLine = it.newLine();
                        }
                        return _xifexpression;
                    }
                };
                it.setSuffix((Functions.Function1<? super ITreeAppendable, ? extends ITreeAppendable>)_function_1);
            }
        };
        Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable> _function_1 = new Procedures.Procedure2<JvmAnnotationReference, ITreeAppendable>(){

            public void apply(JvmAnnotationReference it, ITreeAppendable app) {
                JvmModelGenerator.this.generateAnnotation(it, app, config);
            }
        };
        this._errorSafeExtensions.forEachSafely(appendable, _values, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void generateAnnotation(JvmAnnotationReference it, final ITreeAppendable appendable, final GeneratorConfig config) {
        appendable.append("@");
        JvmAnnotationType _annotation = it.getAnnotation();
        appendable.append((JvmType)_annotation);
        EList _values = it.getValues();
        Procedures.Procedure1<LoopParams> _function = new Procedures.Procedure1<LoopParams>(){

            public void apply(LoopParams it) {
                it.setPrefix("(");
                it.setSeparator(", ");
                it.setSuffix(")");
            }
        };
        Procedures.Procedure1<JvmAnnotationValue> _function_1 = new Procedures.Procedure1<JvmAnnotationValue>(){

            public void apply(JvmAnnotationValue it) {
                JvmModelGenerator.this.toJava(it, appendable, config);
            }
        };
        this._loopExtensions.forEach(appendable, _values, (Procedures.Procedure1<? super LoopParams>)_function, _function_1);
    }

    public void toJava(JvmAnnotationValue it, ITreeAppendable appendable, GeneratorConfig config) {
        boolean _notEquals;
        JvmOperation _operation = it.getOperation();
        boolean bl = _notEquals = !Objects.equal((Object)_operation, null);
        if (_notEquals) {
            JvmOperation _operation_1 = it.getOperation();
            String _simpleName = _operation_1.getSimpleName();
            appendable.append(_simpleName);
            appendable.append(" = ");
        } else {
            boolean _greaterThan;
            EObject _eContainer = it.eContainer();
            EList _values = ((JvmAnnotationReference)_eContainer).getValues();
            int _size = _values.size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                appendable.append("value = ");
            }
        }
        this.toJavaLiteral(it, appendable, config);
    }

    protected void _toJavaLiteral(final JvmAnnotationAnnotationValue value, final ITreeAppendable appendable, final GeneratorConfig config) {
        EList _values = value.getValues();
        Procedures.Procedure1<JvmAnnotationReference> _function = new Procedures.Procedure1<JvmAnnotationReference>(){

            public void apply(JvmAnnotationReference it) {
                JvmModelGenerator.this.generateAnnotations(value, appendable, false, config);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmShortAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Short> _function = new Procedures.Procedure1<Short>(){

            public void apply(Short it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmIntAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Integer> _function = new Procedures.Procedure1<Integer>(){

            public void apply(Integer it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmLongAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Long> _function = new Procedures.Procedure1<Long>(){

            public void apply(Long it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmByteAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Byte> _function = new Procedures.Procedure1<Byte>(){

            public void apply(Byte it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmDoubleAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Double> _function = new Procedures.Procedure1<Double>(){

            public void apply(Double it) {
                boolean _isNaN;
                String _switchResult = null;
                boolean _matched = false;
                if (!_matched && (_isNaN = Double.isNaN(it))) {
                    _matched = true;
                    _switchResult = "Double.NaN";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Double.POSITIVE_INFINITY)) {
                    _matched = true;
                    _switchResult = "Double.POSITIVE_INFINITY";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Double.NEGATIVE_INFINITY)) {
                    _matched = true;
                    _switchResult = "Double.NEGATIVE_INFINITY";
                }
                if (!_matched) {
                    String _plus;
                    String _string = it.toString();
                    _switchResult = _plus = String.valueOf(_string) + "d";
                }
                appendable.append(_switchResult);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmFloatAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Float> _function = new Procedures.Procedure1<Float>(){

            public void apply(Float it) {
                boolean _isNaN;
                String _switchResult = null;
                boolean _matched = false;
                if (!_matched && (_isNaN = Float.isNaN(it.floatValue()))) {
                    _matched = true;
                    _switchResult = "Float.NaN";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.POSITIVE_INFINITY))) {
                    _matched = true;
                    _switchResult = "Float.POSITIVE_INFINITY";
                }
                if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.NEGATIVE_INFINITY))) {
                    _matched = true;
                    _switchResult = "Float.NEGATIVE_INFINITY";
                }
                if (!_matched) {
                    String _plus;
                    String _string = it.toString();
                    _switchResult = _plus = String.valueOf(_string) + "f";
                }
                appendable.append(_switchResult);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmCharAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Character> _function = new Procedures.Procedure1<Character>(){

            public void apply(Character it) {
                String _string = it.toString();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_string);
                String _plus = "'" + _doConvertToJavaString;
                String _plus_1 = String.valueOf(_plus) + "'";
                appendable.append(_plus_1);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmStringAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                String _string = it.toString();
                String _doConvertToJavaString = JvmModelGenerator.this.doConvertToJavaString(_string);
                String _plus = "\"" + _doConvertToJavaString;
                String _plus_1 = String.valueOf(_plus) + "\"";
                appendable.append(_plus_1);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmTypeAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

            public void apply(JvmTypeReference it) {
                JvmType _type = it.getType();
                ITreeAppendable _append = appendable.append(_type);
                _append.append(".class");
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmEnumAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<JvmEnumerationLiteral> _function = new Procedures.Procedure1<JvmEnumerationLiteral>(){

            public void apply(JvmEnumerationLiteral it) {
                JvmDeclaredType _declaringType = it.getDeclaringType();
                appendable.append((JvmType)_declaringType);
                appendable.append(".");
                String _simpleName = it.getSimpleName();
                appendable.append(_simpleName);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmBooleanAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        Procedures.Procedure1<Boolean> _function = new Procedures.Procedure1<Boolean>(){

            public void apply(Boolean it) {
                String _string = it.toString();
                appendable.append(_string);
            }
        };
        this._loopExtensions.forEachWithShortcut(appendable, _values, _function);
    }

    protected void _toJavaLiteral(JvmCustomAnnotationValue it, final ITreeAppendable appendable, GeneratorConfig config) {
        EList _values = it.getValues();
        boolean _isEmpty = _values.isEmpty();
        if (_isEmpty) {
            appendable.append("{}");
        } else {
            EList _values_1 = it.getValues();
            Iterable _filter = Iterables.filter((Iterable)_values_1, XExpression.class);
            Procedures.Procedure1<XExpression> _function = new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    JvmModelGenerator.this.compiler.toJavaExpression(it, appendable);
                }
            };
            this._loopExtensions.forEachWithShortcut(appendable, _filter, _function);
        }
    }

    public TreeAppendable createAppendable(EObject context, ImportManager importManager, GeneratorConfig config) {
        boolean _notEquals;
        TreeAppendable _treeAppendable;
        TreeAppendable appendable = _treeAppendable = new TreeAppendable(importManager, this.converter, this.locationProvider, this.jvmModelAssociations, context, "  ", "\n");
        JvmGenericType type = this.containerType(context);
        boolean bl = _notEquals = !Objects.equal((Object)type, null);
        if (_notEquals) {
            boolean _notEquals_1;
            JvmGenericType _containerType = this.containerType(context);
            appendable.declareVariable(_containerType, "this");
            JvmGenericType _containerType_1 = this.containerType(context);
            JvmTypeReference superType = _containerType_1.getExtendedClass();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)superType, null);
            if (_notEquals_1) {
                JvmType _type = superType.getType();
                appendable.declareVariable(_type, "super");
            }
        }
        return appendable;
    }

    public JvmGenericType containerType(EObject context) {
        JvmGenericType _xifexpression = null;
        boolean _equals = Objects.equal((Object)context, null);
        if (_equals) {
            _xifexpression = null;
        } else {
            JvmGenericType _xifexpression_1 = null;
            if (context instanceof JvmGenericType) {
                _xifexpression_1 = (JvmGenericType)context;
            } else {
                JvmGenericType _containerType;
                EObject _eContainer = context.eContainer();
                _xifexpression_1 = _containerType = this.containerType(_eContainer);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected String makeJavaIdentifier(String name) {
        String _plus;
        String _xifexpression = null;
        boolean _isJavaKeyword = this.keywords.isJavaKeyword(name);
        _xifexpression = _isJavaKeyword ? (_plus = String.valueOf(name) + "_") : name;
        return _xifexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmEnumerationType type) {
        Iterable _filter;
        Iterable _xblockexpression = null;
        String _identifier = type.getIdentifier();
        String _plus = String.valueOf(_identifier) + ".";
        String _plus_1 = String.valueOf(_plus) + "valueOf(java.lang.String)";
        String _identifier_1 = type.getIdentifier();
        String _plus_2 = String.valueOf(_identifier_1) + ".";
        String _plus_3 = String.valueOf(_plus_2) + "values()";
        final Set syntheticEnumMethods = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{_plus_1, _plus_3}));
        EList _members = type.getMembers();
        Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _and = false;
                if (!(it instanceof JvmOperation)) {
                    _and = false;
                } else {
                    String _identifier = it.getIdentifier();
                    boolean _contains = syntheticEnumMethods.contains(_identifier);
                    _and = it instanceof JvmOperation && _contains;
                }
                boolean _not = !_and;
                return _not;
            }
        };
        _xblockexpression = _filter = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        return _xblockexpression;
    }

    protected Iterable<JvmMember> _getMembersToBeCompiled(JvmDeclaredType it) {
        EList _members = it.getMembers();
        Functions.Function1<JvmMember, Boolean> _function = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _and = false;
                if (!(it instanceof JvmConstructor)) {
                    _and = false;
                } else {
                    boolean _isSingleSyntheticDefaultConstructor = JvmModelGenerator.this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor((JvmConstructor)it);
                    _and = it instanceof JvmConstructor && _isSingleSyntheticDefaultConstructor;
                }
                boolean _not = !_and;
                return _not;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function);
        return _filter;
    }

    public void internalDoGenerate(EObject type, IFileSystemAccess fsa) {
        if (type instanceof JvmDeclaredType) {
            this._internalDoGenerate((JvmDeclaredType)type, fsa);
            return;
        }
        if (type != null) {
            this._internalDoGenerate(type, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, fsa).toString());
    }

    public ITreeAppendable generateBody(JvmDeclaredType it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmAnnotationType) {
            return this._generateBody((JvmAnnotationType)it, appendable, config);
        }
        if (it instanceof JvmEnumerationType) {
            return this._generateBody((JvmEnumerationType)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateBody((JvmGenericType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateModifier(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateModifier((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateModifier((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateModifier((JvmField)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateModifier((JvmGenericType)it, appendable, config);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateModifier((JvmDeclaredType)it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public ITreeAppendable generateMember(JvmMember it, ITreeAppendable appendable, GeneratorConfig config) {
        if (it instanceof JvmConstructor) {
            return this._generateMember((JvmConstructor)it, appendable, config);
        }
        if (it instanceof JvmOperation) {
            return this._generateMember((JvmOperation)it, appendable, config);
        }
        if (it instanceof JvmField) {
            return this._generateMember((JvmField)it, appendable, config);
        }
        if (it instanceof JvmGenericType) {
            return this._generateMember((JvmGenericType)it, appendable, config);
        }
        if (it != null) {
            return this._generateMember(it, appendable, config);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, config).toString());
    }

    public void toJavaLiteral(JvmAnnotationValue value, ITreeAppendable appendable, GeneratorConfig config) {
        if (value instanceof JvmAnnotationAnnotationValue) {
            this._toJavaLiteral((JvmAnnotationAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmBooleanAnnotationValue) {
            this._toJavaLiteral((JvmBooleanAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmByteAnnotationValue) {
            this._toJavaLiteral((JvmByteAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCharAnnotationValue) {
            this._toJavaLiteral((JvmCharAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmCustomAnnotationValue) {
            this._toJavaLiteral((JvmCustomAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmDoubleAnnotationValue) {
            this._toJavaLiteral((JvmDoubleAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmEnumAnnotationValue) {
            this._toJavaLiteral((JvmEnumAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmFloatAnnotationValue) {
            this._toJavaLiteral((JvmFloatAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmIntAnnotationValue) {
            this._toJavaLiteral((JvmIntAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmLongAnnotationValue) {
            this._toJavaLiteral((JvmLongAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmShortAnnotationValue) {
            this._toJavaLiteral((JvmShortAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmStringAnnotationValue) {
            this._toJavaLiteral((JvmStringAnnotationValue)value, appendable, config);
            return;
        }
        if (value instanceof JvmTypeAnnotationValue) {
            this._toJavaLiteral((JvmTypeAnnotationValue)value, appendable, config);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value, appendable, config).toString());
    }

    public Iterable<JvmMember> getMembersToBeCompiled(JvmDeclaredType type) {
        if (type instanceof JvmEnumerationType) {
            return this._getMembersToBeCompiled((JvmEnumerationType)type);
        }
        if (type != null) {
            return this._getMembersToBeCompiled(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }
}

