/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;

@NonNullByDefault
public class TypeAssigner
implements ITypeAssigner {
    private final AbstractTypeComputationState state;

    protected TypeAssigner(AbstractTypeComputationState state) {
        this.state = state;
    }

    public AbstractTypeComputationState getForkedState() {
        return this.state;
    }

    public void assignType(JvmIdentifiableElement element, @Nullable LightweightTypeReference actualType) {
        this.assignType(element, actualType, true);
    }

    protected void assignType(JvmIdentifiableElement element, @Nullable LightweightTypeReference actualType, boolean addToChildScope) {
        if (actualType != null) {
            this.state.getResolvedTypes().setType(element, actualType);
        } else {
            this.state.getResolvedTypes().setType(element, new AnyTypeReference(this.state.getReferenceOwner()));
        }
        if (addToChildScope) {
            this.state.addLocalToCurrentScope(element);
        }
    }

    protected OwnedConverter getConverter() {
        return this.state.getResolvedTypes().getConverter();
    }

    public ITypeReferenceOwner getReferenceOwner() {
        return this.state.getReferenceOwner();
    }

    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference reference) {
        return this.getConverter().toLightweightReference(reference);
    }
}

