/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class UnboundTypeParameterPreservingSubstitutor
extends TypeParameterSubstitutor<Set<JvmTypeParameter>> {
    public UnboundTypeParameterPreservingSubstitutor(Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> typeParameterMapping, ITypeReferenceOwner owner) {
        super(typeParameterMapping, owner);
    }

    @Override
    protected LightweightTypeReference doVisitUnboundTypeReference(UnboundTypeReference reference, Set<JvmTypeParameter> visiting) {
        return reference.copyInto(this.getOwner());
    }

    @Override
    @Nullable
    protected LightweightTypeReference getBoundTypeArgument(ParameterizedTypeReference reference, JvmTypeParameter type, Set<JvmTypeParameter> visiting) {
        LightweightTypeReference boundReference;
        LightweightMergedBoundTypeArgument boundTypeArgument = this.getTypeParameterMapping().get(type);
        if (boundTypeArgument != null && (boundReference = boundTypeArgument.getTypeReference()) != null && reference != boundReference) {
            if (boundReference instanceof UnboundTypeReference) {
                return boundReference.copyInto(this.getOwner());
            }
            JvmType boundType = boundReference.getType();
            if (boundType != type) {
                if (visiting.add(type)) {
                    try {
                        LightweightTypeReference result;
                        LightweightTypeReference lightweightTypeReference = result = boundReference.accept(this, visiting);
                        return lightweightTypeReference;
                    }
                    finally {
                        visiting.remove(type);
                    }
                }
                return reference;
            }
        }
        return null;
    }

    @Override
    protected Set<JvmTypeParameter> createVisiting() {
        return Sets.newHashSetWithExpectedSize((int)3);
    }
}

