/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticNameClashResolver {
    @Inject
    private IXtendJvmAssociations associations;

    public void resolveNameClashes(JvmGenericType type) {
        String simpleName;
        HashMultimap classScope = HashMultimap.create();
        ArrayList renameableMembers = Lists.newArrayList();
        int i = 1;
        for (JvmMember member : type.getMembers()) {
            simpleName = member.getSimpleName();
            if (simpleName != null) {
                if (!this.isRenameable((JvmIdentifiableElement)member)) {
                    classScope.put((Object)simpleName, (Object)member);
                } else {
                    renameableMembers.add(member);
                }
            }
            if (!(member instanceof JvmFeature)) continue;
            for (JvmGenericType localType : ((JvmFeature)member).getLocalClasses()) {
                localType.setSimpleName(String.valueOf(localType.getSimpleName()) + '_' + i++);
            }
        }
        for (JvmMember renameable : renameableMembers) {
            if (this.collides((JvmIdentifiableElement)renameable, simpleName = renameable.getSimpleName(), (Multimap<String, JvmIdentifiableElement>)classScope)) {
                String currentName;
                int count = 0;
                do {
                    if (count != Integer.MAX_VALUE) continue;
                    throw new IllegalStateException("Cannot find a collision-free name for " + renameable.getIdentifier());
                } while (this.collides((JvmIdentifiableElement)renameable, currentName = String.valueOf(simpleName) + "_" + ++count, (Multimap<String, JvmIdentifiableElement>)classScope));
                renameable.setSimpleName(currentName);
                classScope.put((Object)currentName, (Object)renameable);
                continue;
            }
            classScope.put((Object)simpleName, (Object)renameable);
        }
    }

    protected boolean collides(JvmIdentifiableElement element, String currentName, Multimap<String, JvmIdentifiableElement> scope) {
        if (scope.containsKey((Object)currentName)) {
            if (element instanceof JvmOperation) {
                for (JvmIdentifiableElement other : scope.get((Object)currentName)) {
                    if (other instanceof JvmOperation && ((JvmOperation)element).getParameters().size() != ((JvmOperation)other).getParameters().size()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean isRenameable(JvmIdentifiableElement element) {
        String simpleName = element.getSimpleName();
        if (!simpleName.startsWith("_")) {
            return false;
        }
        EObject source = this.associations.getPrimarySourceElement((EObject)element);
        return this.isCreateExtension(source) && (simpleName.startsWith("_createCache_") || simpleName.startsWith("_init_")) || this.isAnonymousExtensionField(source);
    }

    protected boolean isAnonymousExtensionField(EObject source) {
        return source instanceof XtendField && ((XtendField)source).isExtension() && Strings.isEmpty((String)((XtendField)source).getName());
    }

    protected boolean isCreateExtension(EObject source) {
        return source instanceof XtendFunction && ((XtendFunction)source).getCreateExtensionInfo() != null;
    }
}

