/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.resource.DescriptionFlags;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.resource.XbaseResourceDescriptionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class XtendResourceDescriptionStrategy
extends XbaseResourceDescriptionStrategy {
    public static final String ACTIVE_ANNOTATION_TIMESTAMP = "ACTIVE_ANNOTATION_TIMESTAMP";
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private DescriptionFlags descriptionFlags;

    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        boolean isJvmType = eObject instanceof JvmType;
        if (isJvmType) {
            super.createEObjectDescriptions(eObject, acceptor);
        }
        return isJvmType;
    }

    public boolean createReferenceDescriptions(EObject from, URI exportedContainerURI, IAcceptor<IReferenceDescription> acceptor) {
        return false;
    }

    protected void createUserData(EObject eObject, ImmutableMap.Builder<String, String> userData) {
        super.createUserData(eObject, userData);
        if (eObject instanceof JvmOperation) {
            this.addFlags(this.getFlags((JvmOperation)eObject), userData);
        } else if (eObject instanceof JvmField) {
            this.addFlags(this.getFlags((JvmField)eObject), userData);
        } else if (eObject instanceof XtendFunction) {
            this.addFlags(this.getFlags((XtendFunction)eObject), userData);
        } else if (eObject instanceof XtendField) {
            this.addFlags(this.getFlags((XtendField)eObject), userData);
        } else if (eObject instanceof JvmAnnotationType && this.isActiveAnnotation((JvmAnnotationType)eObject)) {
            userData.put((Object)ACTIVE_ANNOTATION_TIMESTAMP, (Object)String.valueOf(System.currentTimeMillis()));
        }
    }

    protected void addFlags(int flags, ImmutableMap.Builder<String, String> userData) {
        if (flags != 0) {
            userData.put((Object)"Flags", (Object)Integer.toString(flags));
        }
    }

    protected int getFlags(JvmOperation operation) {
        int flags = 0;
        if (this.dispatchHelper.isDispatcherFunction(operation)) {
            flags = this.descriptionFlags.setDispatcherOperation(flags);
        }
        if (operation.isStatic()) {
            flags = this.descriptionFlags.setStatic(flags);
        }
        return flags;
    }

    protected int getFlags(JvmField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendFunction function) {
        return function.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected boolean isActiveAnnotation(JvmAnnotationType annotationType) {
        for (JvmAnnotationReference anno : annotationType.getAnnotations()) {
            JvmAnnotationType annotation = anno.getAnnotation();
            if (annotation == null || annotation.eIsProxy() || !"org.eclipse.xtend.lib.macro.Active".equals(annotation.getIdentifier())) continue;
            return true;
        }
        return false;
    }
}

