/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.scoping.AbstractKnownTypesScope;
import org.eclipse.xtend.core.scoping.AbstractScope;
import org.eclipse.xtend.core.scoping.XtendImportedNamespaceScopeProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedTypesScope
extends AbstractKnownTypesScope {
    private final JvmDeclaredType innermost;
    private final XtendImportedNamespaceScopeProvider typeScopeProvider;

    public NestedTypesScope(JvmDeclaredType innermost, XtendImportedNamespaceScopeProvider typeScopeProvider, AbstractScope parent) {
        super(parent);
        this.innermost = innermost;
        this.typeScopeProvider = typeScopeProvider;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.doGetSingleElement(name);
        if (result != null) {
            return Collections.singletonList(result);
        }
        return super.getElements(name);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        if (type instanceof JvmDeclaredType) {
            JvmDeclaredType declarator = this.innermost;
            while (declarator != null) {
                if (declarator != type && EcoreUtil.isAncestor((EObject)declarator, (EObject)type)) {
                    this.doGetDescriptions(type, (JvmType)declarator, 0, result);
                }
                declarator = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)declarator.eContainer(), JvmDeclaredType.class);
            }
        }
        super.doGetElements(type, result);
    }

    @Override
    protected void doGetDescriptions(JvmType type, JvmType declarator, int index, List<IEObjectDescription> result) {
        String typeName = type.getQualifiedName('.');
        String declaratorName = declarator.getQualifiedName('.');
        int declaratorLength = declaratorName.length();
        String subName = typeName.substring(declaratorLength + 1);
        List segments = Strings.split((String)subName, (char)'.');
        result.add(EObjectDescription.create((QualifiedName)QualifiedName.create((List)segments), (EObject)type));
        result.add(EObjectDescription.create((String)subName.replace('.', '$'), (EObject)type));
    }

    @Override
    protected IEObjectDescription doGetSingleElement(QualifiedName name, String firstSegment, int dollarIndex) {
        QualifiedName splitted;
        IEObjectDescription result;
        JvmDeclaredType declaredType = this.innermost;
        while (declaredType != null) {
            IEObjectDescription result2 = this.doGetSingleElement(declaredType, name, firstSegment, dollarIndex);
            if (result2 != null) {
                return result2;
            }
            declaredType = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)declaredType.eContainer(), JvmDeclaredType.class);
        }
        if (dollarIndex > 0 && name.getSegmentCount() == 1 && (result = this.doGetSingleElement(splitted = QualifiedName.create((List)Strings.split((String)name.getFirstSegment(), (char)'$')), splitted.getFirstSegment(), -1)) != null) {
            return new AliasedEObjectDescription(name, result);
        }
        return null;
    }

    protected IEObjectDescription doGetSingleElement(JvmDeclaredType declarator, QualifiedName name, String firstSegment, int dollarIndex) {
        JvmTypeReference superTypeReference;
        if (declarator.isLocal() && InferredTypeIndicator.isInferred((JvmTypeReference)(superTypeReference = (JvmTypeReference)Iterables.getLast((Iterable)declarator.getSuperTypes())))) {
            return this.findNestedTypeInLocalTypeNonResolving(declarator, name, firstSegment, dollarIndex);
        }
        Iterable nestedTypes = declarator.findAllNestedTypesByName(firstSegment);
        for (JvmDeclaredType nested : nestedTypes) {
            JvmType nestedType = this.findNestedType((JvmType)nested, 0, name);
            if (nestedType == null) continue;
            return this.toDescription(name, nestedType, dollarIndex, 0);
        }
        return null;
    }

    protected IEObjectDescription findNestedTypeInLocalTypeNonResolving(JvmDeclaredType localType, QualifiedName name, String firstSegment, int dollarIndex) {
        EList members = localType.getMembers();
        int i = 0;
        while (i < members.size()) {
            JvmType candidate;
            JvmDeclaredType nestedType;
            JvmMember member = (JvmMember)members.get(i);
            if (member instanceof JvmDeclaredType && firstSegment.equals((nestedType = (JvmDeclaredType)member).getSimpleName()) && (candidate = this.findNestedType((JvmType)nestedType, 0, name)) != null) {
                return this.toDescription(name, candidate, dollarIndex, 0);
            }
            ++i;
        }
        JvmDeclaredType superType = this.typeScopeProvider.getSuperTypeOfLocalTypeNonResolving(localType);
        if (superType == null) {
            return null;
        }
        return this.doGetSingleElement(superType, name, firstSegment, dollarIndex);
    }
}

