/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.wizards;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.ide.wizards.FieldInitializerUtil;
import org.eclipse.xtend.ide.wizards.Messages;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;

public abstract class AbstractNewXtendElementWizardPage
extends NewTypeWizardPage {
    protected static final int COLS = 4;
    private IResource resource;
    @Inject
    private FieldInitializerUtil util;
    @Inject
    private IWhitespaceInformationProvider whitespaceInformationProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    public AbstractNewXtendElementWizardPage(int typeKind, String title) {
        super(typeKind, title);
    }

    protected abstract void doStatusUpdate();

    protected abstract String getElementCreationErrorMessage();

    protected int createXtendElement(IProgressMonitor monitor, IFile xtendFile, String indentation, String lineSeparator) {
        int size = 0;
        try {
            String content = this.createContent(monitor, xtendFile, indentation, lineSeparator);
            size = content.length();
            xtendFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, monitor);
            this.setResource((IResource)xtendFile);
        }
        catch (CoreException e) {
            this.displayError(this.getElementCreationErrorMessage(), e.getMessage());
        }
        return size;
    }

    private String createContent(IProgressMonitor monitor, IFile xtendFile, String indentation, String lineSeparator) throws CoreException {
        ICompilationUnit compilationUnit = this.getCompilationUnitStub();
        String fileComment = this.getFileComment(compilationUnit, lineSeparator);
        String typeComment = this.getTypeComment(compilationUnit, lineSeparator);
        String typeContent = this.getTypeContent(indentation, lineSeparator);
        String packageDeclaration = this.getPackageDeclaration(lineSeparator);
        return StubUtility.getCompilationUnitContent((ICompilationUnit)compilationUnit, (String)packageDeclaration, (String)fileComment, (String)typeComment, (String)typeContent, (String)lineSeparator);
    }

    protected abstract String getPackageDeclaration(String var1);

    protected abstract String getTypeContent(String var1, String var2);

    private ICompilationUnit getCompilationUnitStub() {
        String compilationUnitName = this.getCompilationUnitName(this.getTypeName());
        return new CompilationUnit((PackageFragment)this.getPackageFragment(), compilationUnitName, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    protected Composite createCommonControls(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, 4);
        this.createPackageControls(composite, 4);
        this.createSeparator(composite, 4);
        this.createTypeNameControls(composite, 4);
        return composite;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected void init(IStructuredSelection selection) {
        IJavaElement elem = this.util.getSelectedResource(selection);
        this.initContainerPage(elem);
        this.initTypePage(elem);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected int createType() {
        final int[] size = new int[1];
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    try {
                        if (!AbstractNewXtendElementWizardPage.this.getPackageFragment().exists()) {
                            try {
                                AbstractNewXtendElementWizardPage.this.getPackageFragmentRoot().createPackageFragment(AbstractNewXtendElementWizardPage.this.getPackageFragment().getElementName(), true, monitor);
                            }
                            catch (JavaModelException e) {
                                AbstractNewXtendElementWizardPage.this.displayError(Messages.ERROR_CREATING_PACKAGE, e.getMessage());
                            }
                        }
                        IResource res = AbstractNewXtendElementWizardPage.this.getPackageFragment().getResource();
                        IFile xtendFile = ((IFolder)res).getFile(String.valueOf(AbstractNewXtendElementWizardPage.this.getTypeName()) + ".xtend");
                        URI uri = AbstractNewXtendElementWizardPage.this.storage2UriMapper.getUri((IStorage)xtendFile);
                        size[0] = AbstractNewXtendElementWizardPage.this.createXtendElement(monitor, xtendFile, AbstractNewXtendElementWizardPage.this.whitespaceInformationProvider.getIndentationInformation(uri).getIndentString(), AbstractNewXtendElementWizardPage.this.whitespaceInformationProvider.getLineSeparatorInformation(uri).getLineSeparator());
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException();
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return 0;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)this.getElementCreationErrorMessage(), (String)realException.getMessage());
        }
        return size[0];
    }

    protected void displayError(final String title, final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)AbstractNewXtendElementWizardPage.this.getShell(), (String)title, (String)message);
            }
        });
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    protected IStatus typeNameChanged() {
        IFolder folder;
        IResource resource;
        IPackageFragment packageFragment = this.getPackageFragment();
        if (packageFragment != null && (resource = packageFragment.getResource()) instanceof IFolder && (folder = (IFolder)resource).getFile(String.valueOf(this.getTypeName()) + ".xtend").exists()) {
            String packageName = "";
            if (!packageFragment.isDefaultPackage()) {
                packageName = String.valueOf(packageFragment.getElementName()) + ".";
            }
            return new StatusInfo(4, String.valueOf(Messages.TYPE_EXISTS_0) + packageName + this.getTypeName() + Messages.TYPE_EXISTS_1);
        }
        return super.typeNameChanged();
    }

    public IResource getResource() {
        return this.resource;
    }

    protected void setResource(IResource resource) {
        this.resource = resource;
    }
}

