/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.IXtextModelListenerExtension;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AttributedPosition;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ITextAttributeProvider;
import org.eclipse.xtext.ui.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingReconciler
implements ITextInputListener,
IXtextModelListener,
IXtextModelListenerExtension,
IHighlightedPositionAcceptor {
    @Inject(optional=true)
    private ISemanticHighlightingCalculator calculator;
    @Inject
    private ITextAttributeProvider attributeProvider;
    private XtextEditor editor;
    private XtextSourceViewer sourceViewer;
    private HighlightingPresenter presenter;
    private final List<AttributedPosition> addedPositions = new ArrayList<AttributedPosition>();
    private List<AttributedPosition> removedPositions = new ArrayList<AttributedPosition>();
    private Map<PositionHandle, Integer> handleToListIndex = Maps.newHashMap();
    private int removedPositionCount;
    private final Object fReconcileLock = new Object();
    private boolean reconciling = false;

    private void startReconcilingPositions() {
        this.presenter.addAllPositions(this.removedPositions);
        this.removedPositionCount = this.removedPositions.size();
        int i = 0;
        while (i < this.removedPositionCount) {
            AttributedPosition position = this.removedPositions.get(i);
            this.handleToListIndex.put(new PositionHandle(position.getOffset(), position.getLength(), position.getHighlighting()), i);
            ++i;
        }
    }

    private void reconcilePositions(XtextResource resource) {
        MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(this.calculator);
        acceptor.provideHighlightingFor(resource, this);
        List<AttributedPosition> oldPositions = this.removedPositions;
        ArrayList<AttributedPosition> newPositions = new ArrayList<AttributedPosition>(this.removedPositionCount);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            AttributedPosition current = oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.removedPositions = newPositions;
    }

    @Override
    public void addPosition(int offset, int length, String ... ids) {
        AttributedPosition position;
        TextAttribute highlighting;
        TextAttribute textAttribute = highlighting = ids.length == 1 ? this.attributeProvider.getAttribute(ids[0]) : this.attributeProvider.getMergedAttributes(ids);
        if (highlighting == null) {
            return;
        }
        boolean isExisting = false;
        PositionHandle handle = new PositionHandle(offset, length, highlighting);
        Integer index = this.handleToListIndex.remove(handle);
        if (index != null) {
            position = this.removedPositions.get(index);
            if (position == null) {
                throw new IllegalStateException("Position may not be null if the handle is still present.");
            }
            isExisting = true;
            this.removedPositions.set(index, null);
            --this.removedPositionCount;
        }
        if (!isExisting && this.presenter != null) {
            position = this.presenter.createHighlightedPosition(offset, length, highlighting);
            this.addedPositions.add(position);
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List<AttributedPosition> addedPositions, List<AttributedPosition> removedPositions) {
        Runnable runnable = this.presenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        Display display = this.getDisplay();
        display.asyncExec(runnable);
    }

    private Display getDisplay() {
        XtextEditor editor = this.editor;
        if (editor == null) {
            if (this.sourceViewer != null) {
                return this.sourceViewer.getControl().getDisplay();
            }
            return null;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return null;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return null;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    private void stopReconcilingPositions() {
        this.removedPositions.clear();
        this.removedPositionCount = 0;
        this.handleToListIndex.clear();
        this.addedPositions.clear();
    }

    public void install(XtextEditor editor, XtextSourceViewer sourceViewer, HighlightingPresenter presenter) {
        this.presenter = presenter;
        this.editor = editor;
        this.sourceViewer = sourceViewer;
        if (this.calculator != null) {
            if (editor == null) {
                ((IXtextDocument)sourceViewer.getDocument()).addModelListener(this);
            } else if (editor.getDocument() != null) {
                editor.getDocument().addModelListener(this);
            }
            sourceViewer.addTextInputListener(this);
        }
        this.refresh();
    }

    public void uninstall() {
        if (this.presenter != null) {
            this.presenter.setCanceled(true);
        }
        if (this.sourceViewer.getDocument() != null && this.calculator != null) {
            XtextDocument document = (XtextDocument)this.sourceViewer.getDocument();
            document.removeModelListener(this);
            this.sourceViewer.removeTextInputListener(this);
        }
        this.editor = null;
        this.sourceViewer = null;
        this.presenter = null;
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            ((IXtextDocument)oldInput).removeModelListener(this);
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.refresh();
            ((IXtextDocument)newInput).addModelListener(this);
        }
    }

    public void refresh() {
        if (this.calculator != null) {
            new Job("calculating highlighting"){

                protected IStatus run(IProgressMonitor monitor) {
                    ((XtextDocument)HighlightingReconciler.this.sourceViewer.getDocument()).readOnly(new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource state) throws Exception {
                            HighlightingReconciler.this.modelChanged(state);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            Display display = this.getDisplay();
            display.asyncExec(this.presenter.createSimpleUpdateRunnable());
        }
    }

    @Override
    public void modelChanged(XtextResource resource) {
        this.modelChanged(resource, CancelIndicator.NullImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void modelChanged(XtextResource resource, CancelIndicator cancelIndicator) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.reconciling) {
                return;
            }
            this.reconciling = true;
        }
        HighlightingPresenter highlightingPresenter = this.presenter;
        try {
            block24: {
                block23: {
                    if (highlightingPresenter == null) break block23;
                    highlightingPresenter.setCanceled(cancelIndicator.isCanceled());
                    if (!highlightingPresenter.isCanceled()) break block24;
                }
                this.stopReconcilingPositions();
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.reconciling = false;
                    return;
                }
            }
            this.startReconcilingPositions();
            if (!highlightingPresenter.isCanceled() && !cancelIndicator.isCanceled()) {
                this.reconcilePositions(resource);
            }
            TextPresentation[] textPresentation = new TextPresentation[1];
            if (!highlightingPresenter.isCanceled()) {
                textPresentation[0] = highlightingPresenter.createPresentation(this.addedPositions, this.removedPositions);
            }
            if (!highlightingPresenter.isCanceled() && !cancelIndicator.isCanceled()) {
                this.updatePresentation(textPresentation[0], this.addedPositions, this.removedPositions);
            }
        }
        catch (Throwable throwable) {
            this.stopReconcilingPositions();
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.reconciling = false;
                throw throwable;
            }
        }
        this.stopReconcilingPositions();
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.reconciling = false;
            return;
        }
    }

    @Deprecated
    protected boolean isModelInSyncWithDocument(XtextResource resource) {
        return true;
    }

    public void setCalculator(ISemanticHighlightingCalculator calculator) {
        this.calculator = calculator;
    }

    public ISemanticHighlightingCalculator getCalculator() {
        return this.calculator;
    }

    private static class PositionHandle {
        private final int offset;
        private final int length;
        private final TextAttribute textAttribute;

        private PositionHandle(int offset, int length, TextAttribute textAttribute) {
            this.offset = offset;
            this.length = length;
            this.textAttribute = textAttribute;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + this.offset;
            result = 31 * result + (this.textAttribute == null ? 0 : this.textAttribute.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            PositionHandle other = (PositionHandle)obj;
            return this.offset == other.offset && this.length == other.length && this.textAttribute == other.textAttribute;
        }
    }
}

