/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractReturnAwareTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractStackedTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.NoExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeComputationStateWithExpectation
extends AbstractStackedTypeComputationState {
    private final LightweightTypeReference expectedType;

    protected TypeComputationStateWithExpectation(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, AbstractTypeComputationState parent, LightweightTypeReference typeReference) {
        super(resolvedTypes, featureScopeSession, parent);
        this.expectedType = typeReference;
    }

    @Override
    public List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState actualState) {
        AbstractTypeExpectation result = this.createTypeExpectation(this.expectedType, actualState, false);
        return Collections.singletonList(result);
    }

    protected AbstractTypeExpectation createTypeExpectation(LightweightTypeReference expectedType, AbstractTypeComputationState actualState, boolean returnType) {
        AbstractReturnAwareTypeExpectation result = null;
        if (expectedType != null) {
            LightweightTypeReference copied = expectedType.copyInto(actualState.getReferenceOwner());
            result = new TypeExpectation(copied, actualState, returnType);
        } else {
            result = new NoExpectation(actualState, returnType);
        }
        return result;
    }

    protected LightweightTypeReference getExpectedType() {
        return this.expectedType;
    }
}

