/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.tokens;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.tokens.IEnumLiteralSerializer;

public class EnumLiteralSerializer
implements IEnumLiteralSerializer {
    @Inject
    protected ITokenDiagnosticProvider diagnosticProvider;
    @Inject
    protected TokenUtil tokenUtil;

    protected Keyword getLiteral(EObject context, RuleCall ruleCall, Object value) {
        EnumRule rule = (EnumRule)ruleCall.getRule();
        if (rule.getAlternatives() instanceof EnumLiteralDeclaration) {
            EnumLiteralDeclaration decl = (EnumLiteralDeclaration)rule.getAlternatives();
            if (decl.getEnumLiteral().getInstance().equals(value)) {
                return decl.getLiteral();
            }
        } else {
            for (AbstractElement element : ((Alternatives)rule.getAlternatives()).getElements()) {
                EnumLiteralDeclaration decl = (EnumLiteralDeclaration)element;
                if (!decl.getEnumLiteral().getInstance().equals(value)) continue;
                return decl.getLiteral();
            }
        }
        return null;
    }

    protected Keyword getLiteral(INode node) {
        if (node != null) {
            for (ILeafNode leaf : node.getLeafNodes()) {
                if (!(leaf.getGrammarElement() instanceof EnumLiteralDeclaration)) continue;
                return ((EnumLiteralDeclaration)leaf.getGrammarElement()).getLiteral();
            }
        }
        return null;
    }

    public boolean isValid(EObject context, RuleCall ruleCall, Object value, ISerializationDiagnostic.Acceptor errorAcceptor) {
        return this.getLiteral(context, ruleCall, value) != null;
    }

    public String serializeAssignedEnumLiteral(EObject context, RuleCall ruleCall, Object value, INode node, ISerializationDiagnostic.Acceptor errorAcceptor) {
        Keyword nodeLit = this.getLiteral(node);
        Keyword modelLit = this.getLiteral(context, ruleCall, value);
        if (modelLit == null) {
            if (errorAcceptor != null) {
                errorAcceptor.accept(this.diagnosticProvider.getInvalidEnumValueDiagnostic(context, ruleCall, value));
            }
            return null;
        }
        if (nodeLit != null && nodeLit.equals(modelLit)) {
            return this.tokenUtil.serializeNode(node);
        }
        return modelLit.getValue();
    }
}

