/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.doubleClicking;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector;

public class FixedCharCountPartitionDoubleClickSelector
extends AbstractPartitionDoubleClickSelector {
    private int fLeftBorder;
    private int fRightBorder;

    public FixedCharCountPartitionDoubleClickSelector(String partitioning, int leftBorder, int rightBorder) {
        super(partitioning);
        this.fLeftBorder = leftBorder;
        this.fRightBorder = rightBorder;
    }

    protected IRegion getSelectedRegion(IDocument document, ITypedRegion completePartition) throws BadLocationException {
        if (this.fLeftBorder == 0 && this.fRightBorder == 0) {
            return completePartition;
        }
        if (this.fRightBorder == -1) {
            String delimiter = document.getLineDelimiter(document.getLineOfOffset(completePartition.getOffset() + completePartition.getLength() - 1));
            this.fRightBorder = delimiter == null ? 0 : delimiter.length();
        }
        return new Region(completePartition.getOffset() + this.fLeftBorder, completePartition.getLength() - this.fLeftBorder - this.fRightBorder);
    }
}

