/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArgumentSlot;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AmbiguousFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.CandidateCompareResult;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitFirstArgument;
import org.eclipse.xtext.xbase.typesystem.internal.ImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.SuspiciouslyOverloadedCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.util.FeatureKinds;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;
import org.eclipse.xtext.xbase.typesystem.util.VarianceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class FeatureLinkingCandidate
extends AbstractPendingLinkingCandidate<XAbstractFeatureCall>
implements IFeatureLinkingCandidate,
IFeatureNames {
    public FeatureLinkingCandidate(XAbstractFeatureCall featureCall, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        super(featureCall, description, expectation, state);
    }

    @Override
    protected ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> second) {
        return new AmbiguousFeatureLinkingCandidate(this, second);
    }

    @Override
    protected ILinkingCandidate createSuspiciousLinkingCandidate(AbstractPendingLinkingCandidate<?> chosenCandidate) {
        return new SuspiciouslyOverloadedCandidate((FeatureLinkingCandidate)chosenCandidate, this);
    }

    @Override
    protected boolean isRawTypeContext() {
        LightweightTypeReference receiverType = this.getReceiverType();
        return receiverType != null && receiverType.isRawType();
    }

    @Override
    protected void initializeMapping(JvmTypeParameter typeParameter, Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> result) {
        ITypeReferenceOwner owner = this.getState().getReferenceOwner();
        if (typeParameter.getDeclarator() instanceof JvmType && owner.getDeclaredTypeParameters().contains(typeParameter)) {
            ParameterizedTypeReference typeReference = new ParameterizedTypeReference(owner, (JvmType)typeParameter);
            result.put(typeParameter, new LightweightMergedBoundTypeArgument(typeReference, VarianceInfo.INVARIANT));
        } else {
            super.initializeMapping(typeParameter, result);
        }
    }

    @Override
    protected List<XExpression> getArguments() {
        List<XExpression> syntacticArguments = this.getSyntacticArguments();
        XExpression firstArgument = this.getFirstArgument();
        if (firstArgument != null) {
            return this.createArgumentList(firstArgument, syntacticArguments);
        }
        return syntacticArguments;
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        if (this.isInvalidStaticSyntax()) {
            String message = String.format("The static %1$s %2$s%3$s should be accessed in a static way", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.instance_access_to_static_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (!this.isStatic() && this.isStaticAccessSyntax()) {
            EObject featureOwner = this.getFeature().eContainer();
            String message = String.format("Cannot make a static reference to the non-static %1$s %2$s%3$s", this.getFeatureTypeName(), this.getFeature().getSimpleName(), this.getFeatureParameterTypesAsString());
            if (featureOwner instanceof JvmDeclaredType) {
                message = String.valueOf(message) + " from the type " + ((JvmDeclaredType)featureOwner).getSimpleName();
            }
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        if (super.validate(result)) {
            XClosure containingClosure;
            JvmIdentifiableElement feature;
            if (this.isExplicitOperationCallOrBuilderSyntax() && !(this.getFeature() instanceof JvmExecutable)) {
                String typeName = this.getFeatureTypeName();
                String code = "org.eclipse.xtext.xbase.validation.IssueCodes.field_access_with_parentheses";
                if (!(this.getFeature() instanceof JvmField)) {
                    code = "org.eclipse.xtext.xbase.validation.IssueCodes.local_var_access_with_parentheses";
                }
                String message = "Cannot access the " + typeName + " " + this.getFeature().getSimpleName() + " with parentheses";
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, code, message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
            if (this.getFeature() instanceof JvmType && !this.getState().isInstanceContext()) {
                String featureName = this.getFeatureCall().getConcreteSyntaxFeatureName();
                if (!SELF.getFirstSegment().equals(featureName)) {
                    String message = String.format("Cannot use %s in a static context", this.getFeatureCall().getConcreteSyntaxFeatureName());
                    EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.static_access_to_instance_member", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                    result.accept((Object)diagnostic);
                    return false;
                }
            }
            if ((feature = this.getFeature()) instanceof XVariableDeclaration && ((XVariableDeclaration)feature).isWriteable() && (containingClosure = (XClosure)EcoreUtil2.getContainerOfType(this.getExpression(), XClosure.class)) != null && !EcoreUtil.isAncestor((EObject)containingClosure, (EObject)feature)) {
                String message = String.format("Cannot refer to the non-final variable %s inside a lambda expression", feature.getSimpleName());
                EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_mutable_variable_access", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
                result.accept((Object)diagnostic);
                return false;
            }
        }
        if (this.isGetClassOnTypeLiteral() && "class".equals(this.description.getName().getFirstSegment())) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException();
            }
            receiverType = receiverType.getTypeArguments().get(0);
            String message = String.format("The syntax for type literals is typeof(%s) or %s.", receiverType.getSimpleName(), receiverType.getSimpleName());
            EObjectDiagnosticImpl diagnostic = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.unexpected_invocation_on_type_literal", message, this.getExpression(), (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, null);
            result.accept((Object)diagnostic);
            return false;
        }
        return true;
    }

    protected boolean isInvalidStaticSyntax() {
        boolean result;
        boolean bl = result = this.isStatic() && !this.isExtension() && this.isAssignmentOrMemberFeatureCall() && !this.isStaticWithDeclaringType();
        return result;
    }

    protected boolean isStaticWithDeclaringType() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isStaticWithDeclaringType();
        }
        if (featureCall instanceof XAssignment) {
            return this.isStaticWithDeclaringType((XAssignment)featureCall);
        }
        return false;
    }

    protected boolean isStaticWithDeclaringType(XAssignment assignment) {
        return assignment.isExplicitStatic() || this.isImplicitlyStatic(assignment);
    }

    protected boolean isImplicitlyStatic(XAssignment assignment) {
        return assignment.isStatic() && this.isTypeLiteral(assignment.getAssignable());
    }

    protected boolean isTypeLiteral(XExpression expression) {
        return expression instanceof XAbstractFeatureCall && ((XAbstractFeatureCall)expression).isTypeLiteral();
    }

    protected boolean isExplicitOperationCallOrBuilderSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XBinaryOperation || featureCall instanceof XAssignment) {
            return false;
        }
        return featureCall.isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected String getFeatureTypeName() {
        JvmIdentifiableElement feature = this.getFeature();
        String result = FeatureKinds.getTypeName(feature);
        return result;
    }

    protected boolean isStaticAccessSyntax() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            return ((XMemberFeatureCall)featureCall).isExplicitStatic();
        }
        return false;
    }

    protected boolean isAssignmentOrMemberFeatureCall() {
        if (this.getImplicitReceiverType() != null) {
            return true;
        }
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XAssignment) {
            return this.isSimpleAssignment((XAssignment)featureCall);
        }
        return featureCall instanceof XMemberFeatureCall;
    }

    protected boolean isSimpleAssignment(XAssignment assignment) {
        return assignment.getAssignable() != null;
    }

    protected List<XExpression> createArgumentList(XExpression head, List<XExpression> tail) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(tail.size() + 1));
        result.add(head);
        for (XExpression expression : tail) {
            result.add(expression);
        }
        return result;
    }

    @Override
    public int getArityMismatch() {
        int result = super.getArityMismatch();
        if (this.isStatic() && (this.getImplicitReceiver() != null || this.getSyntacticReceiverIfPossibleArgument() != null && !this.isExtension())) {
            result = result < 0 ? --result : ++result;
        }
        return result;
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return new FeatureLinkHelper().getSyntacticArguments(this.getFeatureCall());
    }

    @Override
    public boolean isExtension() {
        return this.description.isExtension();
    }

    @Override
    protected boolean hasReceiver() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return this.description.isStatic();
    }

    protected boolean isSyntacticReceiverPossibleArgument() {
        return this.description.isSyntacticReceiverPossibleArgument();
    }

    @Override
    public boolean isTypeLiteral() {
        return false;
    }

    @Override
    protected CandidateCompareResult getExpectedTypeCompareResultOther(AbstractPendingLinkingCandidate<?> right) {
        JvmIdentifiableElement otherImplicitReceiverFeature;
        if (!(right instanceof FeatureLinkingCandidate) || this.getState().isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.suspiciously_overloaded_feature")) {
            return CandidateCompareResult.OTHER;
        }
        FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
        XExpression otherImplicitReceiver = casted.getImplicitReceiver();
        if (otherImplicitReceiver instanceof XAbstractFeatureCall && this.getImplicitReceiver() instanceof XAbstractFeatureCall && (otherImplicitReceiverFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature()) != ((XAbstractFeatureCall)this.getImplicitReceiver()).getFeature()) {
            return CandidateCompareResult.SUSPICIOUS_OTHER;
        }
        return CandidateCompareResult.OTHER;
    }

    @Override
    protected EnumSet<ConformanceHint> getConformanceHints(int idx, boolean recompute) {
        if (idx == 0 && this.getReceiver() != null) {
            EnumSet<ConformanceHint> result = this.getReceiverConformanceHints();
            return result;
        }
        return super.getConformanceHints(idx, recompute);
    }

    @Override
    @Nullable
    protected LightweightTypeReference getSubstitutedExpectedType(int idx) {
        if (idx == 0 && this.getReceiver() != null) {
            return null;
        }
        return super.getSubstitutedExpectedType(idx);
    }

    protected boolean isExplicitOperationCall() {
        return this.getFeatureCall().isExplicitOperationCallOrBuilderSyntax();
    }

    @Override
    protected CandidateCompareResult compareByBucket(AbstractPendingLinkingCandidate<?> right) {
        if (this.isExtension() && right.isExtension()) {
            if (this.description.getShadowingKey().equals(right.description.getShadowingKey())) {
                if (this.description.getBucketId() == right.description.getBucketId()) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                if (this.isAmbiguousExtensionProvider(right)) {
                    return CandidateCompareResult.AMBIGUOUS;
                }
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.AMBIGUOUS;
        }
        return super.compareByBucket(right);
    }

    protected boolean isAmbiguousExtensionProvider(AbstractPendingLinkingCandidate<?> right) {
        XExpression otherImplicitReceiver;
        XExpression implicitReceiver = this.getImplicitReceiver();
        if (implicitReceiver instanceof XAbstractFeatureCall && (otherImplicitReceiver = right.description.getImplicitReceiver()) instanceof XAbstractFeatureCall) {
            JvmIdentifiableElement feature = ((XAbstractFeatureCall)implicitReceiver).getFeature();
            JvmIdentifiableElement otherFeature = ((XAbstractFeatureCall)otherImplicitReceiver).getFeature();
            if (feature.eContainer() == otherFeature.eContainer()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CandidateCompareResult compareByArityWith(AbstractPendingLinkingCandidate<?> right) {
        CandidateCompareResult result = super.compareByArityWith(right);
        if (result == CandidateCompareResult.AMBIGUOUS) {
            boolean isExecutable = this.getFeature() instanceof JvmExecutable;
            if (isExecutable != right.getFeature() instanceof JvmExecutable && this.isVisible() == right.isVisible() && this.isTypeLiteral() == right.isTypeLiteral()) {
                if (this.getExpression() instanceof XAssignment) {
                    if (isExecutable) {
                        return CandidateCompareResult.OTHER;
                    }
                    return CandidateCompareResult.THIS;
                }
                if (this.isExplicitOperationCall()) {
                    if (isExecutable) {
                        return CandidateCompareResult.THIS;
                    }
                    return CandidateCompareResult.OTHER;
                }
                if (isExecutable) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.THIS;
            }
            if (this.getFeature() == right.getFeature() && right instanceof FeatureLinkingCandidate) {
                FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
                if (this.isStatic() && casted.isStatic() && this.getReceiver() == casted.getReceiver() && this.isSyntacticReceiverPossibleArgument() == casted.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.THIS;
                }
            }
        }
        return result;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int argumentIndex, EnumSet<ConformanceHint> leftConformance, EnumSet<ConformanceHint> rightConformance) {
        boolean rightFirstArgumentMismatch;
        CandidateCompareResult result = super.compareByArgumentTypes(right, argumentIndex, leftConformance, rightConformance);
        if (result != CandidateCompareResult.EQUALLY_INVALID && result != CandidateCompareResult.AMBIGUOUS || leftConformance.contains((Object)ConformanceHint.SUCCESS) || !(right instanceof FeatureLinkingCandidate)) {
            return result;
        }
        boolean firstArgumentMismatch = this.isFirstArgument(argumentIndex);
        if (firstArgumentMismatch != (rightFirstArgumentMismatch = ((FeatureLinkingCandidate)right).isFirstArgument(argumentIndex))) {
            if (firstArgumentMismatch) {
                return CandidateCompareResult.OTHER;
            }
            return CandidateCompareResult.THIS;
        }
        return result;
    }

    protected boolean isFirstArgument(int argumentIndex) {
        if (argumentIndex > 1 || this.getFirstArgument() == null) {
            return false;
        }
        if (this.isStatic()) {
            return argumentIndex == 0;
        }
        return argumentIndex == 1;
    }

    @Override
    protected CandidateCompareResult compareByArgumentTypes(AbstractPendingLinkingCandidate<?> right, int leftBoxing, int rightBoxing, int leftDemand, int rightDemand) {
        if (leftDemand != rightDemand) {
            if (leftDemand < rightDemand) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        if (right instanceof FeatureLinkingCandidate) {
            FeatureLinkingCandidate casted = (FeatureLinkingCandidate)right;
            if (this.isExtension() != casted.isExtension()) {
                if (this.isExtension()) {
                    return CandidateCompareResult.OTHER;
                }
                return CandidateCompareResult.THIS;
            }
            if (this.isStatic() != casted.isStatic()) {
                if (this.isSyntacticReceiverPossibleArgument() == casted.isSyntacticReceiverPossibleArgument()) {
                    if (this.isStatic()) {
                        return CandidateCompareResult.OTHER;
                    }
                    return CandidateCompareResult.THIS;
                }
                if (this.isStatic() && !this.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.THIS;
                }
                if (casted.isStatic() && !casted.isSyntacticReceiverPossibleArgument()) {
                    return CandidateCompareResult.OTHER;
                }
            }
        }
        if (leftBoxing != rightBoxing) {
            if (leftBoxing < rightBoxing) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    @Override
    protected void preApply() {
        this.applyImplicitReceiver();
        super.preApply();
        XExpression implicitFirstArgument = this.getImplicitFirstArgument();
        if (implicitFirstArgument != null) {
            new ImplicitFirstArgument(this.getFeatureCall(), (XAbstractFeatureCall)implicitFirstArgument, this.getState()).applyToComputationState();
        }
        this.getState().markAsRefinedTypeIfNecessary(this);
        this.discardRefinementTypeIfReassigned();
    }

    protected void applyImplicitReceiver() {
        XExpression implicitReceiver;
        if (!this.isStatic() && (implicitReceiver = this.getImplicitReceiver()) != null) {
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            LightweightTypeReference receiverType = this.getImplicitReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
            if (expectedReceiverType != null) {
                expectedReceiverType = expectedReceiverType.copyInto(resolvedTypes.getReferenceOwner());
            }
            if (receiverType.isSynonym()) {
                receiverType = receiverType.getMultiTypeComponents().get(0);
            }
            TypeExpectation expectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
            resolvedTypes.acceptType(implicitReceiver, expectation, receiverType.copyInto(resolvedTypes.getReferenceOwner()), false, ConformanceHint.UNCHECKED);
            if (implicitReceiver instanceof XAbstractFeatureCall) {
                new ImplicitReceiver(this.getFeatureCall(), (XAbstractFeatureCall)implicitReceiver, this.getState()).applyToComputationState();
            } else {
                throw new IllegalStateException("unexpected implicit receiver, was: " + implicitReceiver);
            }
        }
    }

    @Override
    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        super.resolveAgainstActualType(declaredType, actualType, state);
        if (!this.isStatic() || (!actualType.getTypeArguments().isEmpty() || actualType.isArray()) && this.getDeclaredTypeParameters().isEmpty()) {
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(state.getReferenceOwner());
            collector.processPairedReferences(declaredType, actualType);
        }
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Lists.transform(this.getFeatureCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    protected void resolveArgumentType(XExpression argument, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (argument == this.getSyntacticReceiverIfPossibleArgument()) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType != null) {
                this.resolveKnownArgumentType(argument, receiverType, declaredType, argumentState);
            }
        } else if (argument == this.getImplicitFirstArgument()) {
            LightweightTypeReference argumentType = this.getImplicitFirstArgumentType();
            if (argumentType != null) {
                this.resolveKnownArgumentType(argument, argumentType, declaredType, argumentState);
            }
        } else {
            super.resolveArgumentType(argument, declaredType, argumentState);
        }
    }

    protected void resolveKnownArgumentType(XExpression argument, LightweightTypeReference knownType, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (!(argumentState instanceof AbstractLinkingCandidate.ArgumentTypeComputationState)) {
            throw new IllegalArgumentException("argumentState was " + argumentState);
        }
        AbstractLinkingCandidate.ArgumentTypeComputationState castedArgumentState = (AbstractLinkingCandidate.ArgumentTypeComputationState)argumentState;
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference copiedDeclaredType = declaredType != null ? declaredType.copyInto(resolvedTypes.getReferenceOwner()) : null;
        TypeExpectation expectation = new TypeExpectation(copiedDeclaredType, castedArgumentState, false);
        LightweightTypeReference copiedReceiverType = knownType.copyInto(resolvedTypes.getReferenceOwner());
        ConformanceHint defaultHint = castedArgumentState.getDefaultHint();
        if (defaultHint == null) {
            resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED);
        } else {
            resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED, defaultHint);
        }
        if (copiedDeclaredType != null) {
            this.resolveAgainstActualType(copiedDeclaredType, copiedReceiverType, castedArgumentState);
        }
    }

    @Override
    protected void computeVarArgumentType(IFeatureCallArgumentSlot slot, TypeParameterSubstitutor<?> substitutor) {
        List<XExpression> arguments;
        if (this.isExtension() && (arguments = slot.getArgumentExpressions()).size() == 1 && arguments.get(0) == this.getFirstArgument()) {
            this.computeFixedArityArgumentType(slot, substitutor);
            return;
        }
        super.computeVarArgumentType(slot, substitutor);
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        if (this.isStatic()) {
            if (this.getFeature() instanceof JvmConstructor) {
                return this.description.getImplicitReceiverTypeParameterMapping();
            }
            return super.getDeclaratorParameterMapping();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverTypeParameterMapping();
        }
        return this.description.getSyntacticReceiverTypeParameterMapping();
    }

    @Nullable
    protected XExpression getReceiver() {
        if (this.isStatic()) {
            return null;
        }
        XExpression result = this.getImplicitReceiver();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    @Nullable
    protected LightweightTypeReference getReceiverType() {
        if (this.isStatic()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitReceiver() != null ? this.getImplicitReceiverType() : this.getSyntacticReceiverType();
        return result;
    }

    protected EnumSet<ConformanceHint> getReceiverConformanceHints() {
        if (this.isStatic()) {
            throw new IllegalStateException();
        }
        if (this.getImplicitReceiver() != null) {
            return this.description.getImplicitReceiverConformanceHints();
        }
        if (this.getSyntacticReceiverIfPossibleArgument() != null) {
            return this.description.getSyntacticReceiverConformanceHints();
        }
        throw new IllegalStateException();
    }

    @Nullable
    protected XExpression getFirstArgument() {
        if (!this.isExtension()) {
            return null;
        }
        XExpression firstArgument = this.getImplicitFirstArgument();
        if (firstArgument != null) {
            return firstArgument;
        }
        return this.getSyntacticReceiverIfPossibleArgument();
    }

    @Nullable
    protected LightweightTypeReference getFirstArgumentType() {
        if (!this.isExtension()) {
            return null;
        }
        LightweightTypeReference result = this.getImplicitFirstArgumentType();
        if (result != null) {
            return result;
        }
        return this.getSyntacticReceiverType();
    }

    @Nullable
    protected XExpression getImplicitReceiver() {
        return this.description.getImplicitReceiver();
    }

    @Nullable
    protected LightweightTypeReference getImplicitReceiverType() {
        return this.description.getImplicitReceiverType();
    }

    @Nullable
    protected XExpression getSyntacticReceiver() {
        return this.description.getSyntacticReceiver();
    }

    @Nullable
    protected XExpression getSyntacticReceiverIfPossibleArgument() {
        if (this.description.isSyntacticReceiverPossibleArgument()) {
            return this.getSyntacticReceiver();
        }
        return null;
    }

    @Nullable
    protected LightweightTypeReference getSyntacticReceiverType() {
        return this.description.getSyntacticReceiverType();
    }

    @Nullable
    protected XExpression getImplicitFirstArgument() {
        return this.description.getImplicitFirstArgument();
    }

    @Nullable
    protected LightweightTypeReference getImplicitFirstArgumentType() {
        return this.description.getImplicitFirstArgumentType();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        if (feature instanceof JvmConstructor) {
            return this.getState().getConverter().toLightweightReference(this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]));
        }
        if (this.isGetClass(feature)) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            List<JvmType> rawTypes = receiverType.getRawTypes();
            if (rawTypes.isEmpty()) {
                return super.getDeclaredType(feature);
            }
            ParameterizedTypeReference result = new ParameterizedTypeReference(receiverType.getOwner(), ((JvmOperation)feature).getReturnType().getType());
            WildcardTypeReference wildcard = new WildcardTypeReference(receiverType.getOwner());
            wildcard.addUpperBound(new ParameterizedTypeReference(receiverType.getOwner(), rawTypes.get(0)));
            result.addTypeArgument(wildcard);
            return result;
        }
        return super.getDeclaredType(feature);
    }

    protected boolean isGetClassOnTypeLiteral() {
        IFeatureLinkingCandidate linkingCandidate;
        XExpression receiver;
        JvmIdentifiableElement feature = this.getFeature();
        return this.isGetClass(feature) && (receiver = this.getSyntacticReceiver()) instanceof XAbstractFeatureCall && (linkingCandidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)receiver)) != null && linkingCandidate.isTypeLiteral();
    }

    protected boolean isGetClass(JvmIdentifiableElement feature) {
        JvmOperation getClassOperation;
        return feature instanceof JvmOperation && feature.getSimpleName().equals("getClass") && (getClassOperation = (JvmOperation)feature).getParameters().isEmpty() && "java.lang.Object".equals(getClassOperation.getDeclaringType().getIdentifier());
    }

    @Override
    public void applyToModel() {
        XAssignment casted;
        XExpression syntacticReceiver;
        this.resolveLinkingProxy(XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, 0);
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        if (featureCall instanceof XMemberFeatureCall) {
            XMemberFeatureCall casted2 = (XMemberFeatureCall)featureCall;
            XExpression syntacticReceiver2 = casted2.getMemberCallTarget();
            if (this.isStaticWithDeclaringType(syntacticReceiver2)) {
                casted2.setStaticWithDeclaringType(true);
            }
        } else if (featureCall instanceof XAssignment && this.isStaticWithDeclaringType(syntacticReceiver = (casted = (XAssignment)featureCall).getAssignable())) {
            casted.setStaticWithDeclaringType(true);
        }
    }

    private boolean isStaticWithDeclaringType(XExpression syntacticReceiver) {
        IFeatureLinkingCandidate candidate;
        return this.isStatic() && syntacticReceiver instanceof XAbstractFeatureCall && !this.isExtension() && (candidate = this.getState().getResolvedTypes().getLinkingCandidate((XAbstractFeatureCall)syntacticReceiver)) != null && candidate.isTypeLiteral();
    }

    @Override
    protected Severity getUnhandledExceptionSeverity(JvmExecutable executable) {
        if (this.getFeature() instanceof JvmConstructor) {
            return Severity.ERROR;
        }
        return super.getUnhandledExceptionSeverity(executable);
    }
}

