/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.resource.Resource;

public class PDEClasspathContainer {
    private static final Map<IPath, IAccessRule> ACCESSIBLE_RULES = new ConcurrentHashMap<IPath, IAccessRule>();
    private static final Map<IPath, IAccessRule> DISCOURAGED_RULES = new ConcurrentHashMap<IPath, IAccessRule>();
    private static final IAccessRule EXCLUDE_ALL_RULE = JavaCore.newAccessRule((IPath)IPath.fromOSString((String)"**/*"), (int)257);

    protected void addProjectEntry(IProject project, List<Rule> rules, boolean exportsExternalAnnotations, List<IClasspathEntry> entries) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IAccessRule[] accessRules = rules != null ? PDEClasspathContainer.getAccessRules(rules) : null;
            IClasspathAttribute[] extraAttribs = this.getClasspathAttributesForProject(project, exportsExternalAnnotations);
            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])extraAttribs, (boolean)false);
            if (!entries.contains(entry)) {
                entries.add(entry);
            }
        }
    }

    private IClasspathAttribute[] getClasspathAttributesForProject(IProject project, boolean exportsExternalAnnotations) throws JavaModelException {
        if (exportsExternalAnnotations) {
            String annotationPath = JavaCore.create((IProject)project).getOutputLocation().toString();
            return new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"annotationpath", (String)annotationPath)};
        }
        return new IClasspathAttribute[0];
    }

    public static IClasspathEntry[] getExternalEntries(IPluginModelBase model) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        PDEClasspathContainer.addExternalPlugin(model, List.of(), entries);
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected static void addExternalPlugin(IPluginModelBase model, List<Rule> rules, List<IClasspathEntry> entries) {
        boolean isJarShape = new File(model.getInstallLocation()).isFile();
        if (isJarShape) {
            File[] extractedLibraries;
            IPath srcPath = ClasspathUtilCore.getSourceAnnotation(model, ".", isJarShape);
            if (srcPath == null) {
                srcPath = IPath.fromOSString((String)model.getInstallLocation());
            }
            PDEClasspathContainer.addLibraryEntry(IPath.fromOSString((String)model.getInstallLocation()), srcPath, rules, PDEClasspathContainer.getClasspathAttributes(model), entries);
            File[] fileArray = extractedLibraries = PDECore.getDefault().getModelManager().getExternalModelManager().getExtractedLibraries(model);
            int n = extractedLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                File libraryFile = fileArray[n2];
                IPath path = IPath.fromOSString((String)libraryFile.getAbsolutePath());
                PDEClasspathContainer.addLibraryEntry(path, path, rules, PDEClasspathContainer.getClasspathAttributes(model), entries);
                ++n2;
            }
        } else {
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            if (libraries.length == 0) {
                IPath srcPath = ClasspathUtilCore.getSourceAnnotation(model, ".", isJarShape);
                if (srcPath == null) {
                    srcPath = IPath.fromOSString((String)model.getInstallLocation());
                }
                PDEClasspathContainer.addLibraryEntry(IPath.fromOSString((String)model.getInstallLocation()), srcPath, rules, PDEClasspathContainer.getClasspathAttributes(model), entries);
            } else {
                IPluginLibrary[] iPluginLibraryArray = libraries;
                int n = libraries.length;
                int n3 = 0;
                while (n3 < n) {
                    IPluginLibrary library = iPluginLibraryArray[n3];
                    if (!"resource".equals(library.getType())) {
                        String name;
                        String expandedName;
                        model = (IPluginModelBase)library.getModel();
                        IPath path = ClasspathUtilCore.getPath(model, expandedName = ClasspathUtilCore.expandLibraryName(name = library.getName()), isJarShape);
                        if (path == null && !model.isFragmentModel() && ClasspathUtilCore.containsVariables(name) && (model = PDEClasspathContainer.resolveLibraryInFragments(model, expandedName)) != null && model.isEnabled()) {
                            path = ClasspathUtilCore.getPath(model, expandedName, isJarShape);
                        }
                        if (path != null) {
                            PDEClasspathContainer.addLibraryEntry(path, ClasspathUtilCore.getSourceAnnotation(model, expandedName, isJarShape), rules, PDEClasspathContainer.getClasspathAttributes(model), entries);
                        }
                    }
                    ++n3;
                }
            }
        }
    }

    protected static void addLibraryEntry(IPath path, IPath srcPath, List<Rule> rules, IClasspathAttribute[] attributes, List<IClasspathEntry> entries) {
        IClasspathEntry entry = null;
        entry = rules != null ? JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null, (IAccessRule[])PDEClasspathContainer.getAccessRules(rules), (IClasspathAttribute[])attributes, (boolean)false) : JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attributes, (boolean)false);
        if (!entries.contains(entry)) {
            entries.add(entry);
        }
    }

    protected static IAccessRule[] getAccessRules(List<Rule> rules) {
        IAccessRule[] accessRules = new IAccessRule[rules.size() + 1];
        int i = 0;
        for (Rule rule : rules) {
            IPath path = rule.path;
            IAccessRule iAccessRule = accessRules[i++] = rule.discouraged ? DISCOURAGED_RULES.computeIfAbsent(path, p -> JavaCore.newAccessRule((IPath)p, (int)2)) : ACCESSIBLE_RULES.computeIfAbsent(path, p -> JavaCore.newAccessRule((IPath)p, (int)0));
        }
        accessRules[rules.size()] = EXCLUDE_ALL_RULE;
        return accessRules;
    }

    private static IClasspathAttribute[] getClasspathAttributes(IPluginModelBase model) {
        ArrayList<IClasspathAttribute> attributes = new ArrayList<IClasspathAttribute>();
        JavadocLocationManager manager = PDECore.getDefault().getJavadocLocationManager();
        String location = manager.getJavadocLocation(model);
        if (location != null) {
            attributes.add(JavaCore.newClasspathAttribute((String)"javadoc_location", (String)location));
        }
        if (model.getPluginBase().exportsExternalAnnotations()) {
            String installLocation = model.getInstallLocation();
            attributes.add(JavaCore.newClasspathAttribute((String)"annotationpath", (String)installLocation));
        }
        return (IClasspathAttribute[])attributes.toArray(IClasspathAttribute[]::new);
    }

    protected static IPluginModelBase resolveLibraryInFragments(IPluginModelBase model, String libraryName) {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            BundleDescription[] fragments;
            BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                if (new File(fragment.getLocation(), libraryName).exists()) {
                    return PluginRegistry.findModel((Resource)fragment);
                }
                ++n2;
            }
        }
        return null;
    }

    record Rule(IPath path, boolean discouraged) {
        @Override
        public String toString() {
            return this.discouraged ? this.path.toString() + " [discouraged]" : this.path.toString();
        }
    }
}

