/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.stash.StashCreateUI;
import org.eclipse.jgit.lib.Repository;

public class StashCreateHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        StashCreateUI stashCreateUI = new StashCreateUI(repository);
        stashCreateUI.createStash(this.getShell(event));
        return null;
    }

    @Override
    public boolean isEnabled() {
        Repository repository = this.getRepository();
        return StashCreateHandler.isEnabled(repository);
    }

    static boolean isEnabled(Repository repository) {
        if (repository == null) {
            return false;
        }
        if (!repository.getRepositoryState().canCommit()) {
            return false;
        }
        IndexDiffCacheEntry entry = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repository);
        if (entry == null) {
            return false;
        }
        IndexDiffData diff = entry.getIndexDiff();
        if (diff == null) {
            return false;
        }
        return !diff.getAdded().isEmpty() || !diff.getChanged().isEmpty() || !diff.getRemoved().isEmpty() || !diff.getUntracked().isEmpty() || !diff.getModified().isEmpty() || !diff.getMissing().isEmpty();
    }
}

