/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class PatternMatchingForInstanceofFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<PatternMatchingForInstanceofFixOperation> operations = new ArrayList<PatternMatchingForInstanceofFixOperation>();
        PatternMatchingForInstanceofFinder finder = new PatternMatchingForInstanceofFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PatternMatchingForInstanceofFixCore(FixMessages.PatternMatchingForInstanceofFix_refactor, compilationUnit, ops);
    }

    protected PatternMatchingForInstanceofFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class PatternMatchingForInstanceofFinder
    extends ASTVisitor {
        private List<PatternMatchingForInstanceofFixOperation> fResult;

        public PatternMatchingForInstanceofFinder(List<PatternMatchingForInstanceofFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            InstanceofVisitor instanceofVisitor = new InstanceofVisitor(visited);
            visited.accept((ASTVisitor)instanceofVisitor);
            return instanceofVisitor.getResult();
        }

        final class InstanceofVisitor
        extends ASTVisitor {
            private final Block startNode;
            private boolean result = true;

            public InstanceofVisitor(Block startNode) {
                this.startNode = startNode;
            }

            public boolean getResult() {
                return this.result;
            }

            public boolean visit(Block visited) {
                return this.startNode == visited;
            }

            public boolean visit(InstanceofExpression visited) {
                InfixExpression infixExp;
                if (!ASTNodes.isPassive((ASTNode)visited.getLeftOperand()) || visited.getRightOperand().resolveBinding() == null) {
                    return true;
                }
                boolean isPositiveCaseToAnalyze = true;
                InstanceofExpression currentNode = visited;
                while (!(currentNode.getParent() == null || currentNode.getParent() instanceof IfStatement && currentNode.getLocationInParent() == IfStatement.EXPRESSION_PROPERTY)) {
                    switch (currentNode.getParent().getNodeType()) {
                        case 36: {
                            break;
                        }
                        case 38: {
                            if (!ASTNodes.hasOperator((PrefixExpression)currentNode.getParent(), PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                                return true;
                            }
                            isPositiveCaseToAnalyze = !isPositiveCaseToAnalyze;
                            break;
                        }
                        case 27: {
                            if (!(isPositiveCaseToAnalyze ? !ASTNodes.hasOperator((InfixExpression)currentNode.getParent(), InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.AND) : !ASTNodes.hasOperator((InfixExpression)currentNode.getParent(), InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.OR))) break;
                            return true;
                        }
                        default: {
                            return true;
                        }
                    }
                    currentNode = currentNode.getParent();
                }
                if (currentNode.getParent() == null) {
                    return true;
                }
                if (currentNode instanceof InfixExpression && (infixExp = (InfixExpression)currentNode).getOperator() != InfixExpression.Operator.CONDITIONAL_AND && infixExp.getOperator() != InfixExpression.Operator.CONDITIONAL_OR) {
                    return true;
                }
                IfStatement ifStatement = (IfStatement)currentNode.getParent();
                if (isPositiveCaseToAnalyze) {
                    return this.maybeMatchPattern(visited, ifStatement.getThenStatement());
                }
                if (ifStatement.getElseStatement() != null) {
                    return this.maybeMatchPattern(visited, ifStatement.getElseStatement());
                }
                if (ASTNodes.fallsThrough(ifStatement.getThenStatement())) {
                    return this.maybeMatchPattern(visited, ASTNodes.getNextSibling((Statement)ifStatement));
                }
                return true;
            }

            private boolean maybeMatchPattern(InstanceofExpression visited, Statement conditionalStatements) {
                CastExpression castExpression;
                VariableDeclarationStatement variableDeclarationExpression;
                VariableDeclarationFragment variableDeclarationFragment;
                List<Statement> statements = ASTNodes.asList(conditionalStatements);
                if (!statements.isEmpty() && (variableDeclarationFragment = ASTNodes.getUniqueFragment((Statement)(variableDeclarationExpression = ASTNodes.as(statements.get(0), VariableDeclarationStatement.class)))) != null && Objects.equals(visited.getRightOperand().resolveBinding(), variableDeclarationExpression.getType().resolveBinding()) && (castExpression = ASTNodes.as(variableDeclarationFragment.getInitializer(), CastExpression.class)) != null && Objects.equals(visited.getRightOperand().resolveBinding(), castExpression.getType().resolveBinding()) && ASTNodes.match((ASTNode)visited.getLeftOperand(), (ASTNode)castExpression.getExpression()) && ASTNodes.isPassive((ASTNode)visited.getLeftOperand())) {
                    PatternMatchingForInstanceofFinder.this.fResult.add(new PatternMatchingForInstanceofFixOperation(visited, variableDeclarationExpression, variableDeclarationFragment.getName()));
                    return false;
                }
                return true;
            }
        }
    }

    public static class PatternMatchingForInstanceofFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final InstanceofExpression nodeToComplete;
        private final VariableDeclarationStatement statementToRemove;
        private final SimpleName expressionToMove;

        public PatternMatchingForInstanceofFixOperation(InstanceofExpression nodeToComplete, VariableDeclarationStatement statementToRemove, SimpleName expressionToMove) {
            this.nodeToComplete = nodeToComplete;
            this.statementToRemove = statementToRemove;
            this.expressionToMove = expressionToMove;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PatternMatchingForInstanceofCleanup_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            PatternInstanceofExpression newInstanceof = ast.newPatternInstanceofExpression();
            newInstanceof.setLeftOperand(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getLeftOperand()));
            SingleVariableDeclaration newSVDecl = ast.newSingleVariableDeclaration();
            newSVDecl.setName(ASTNodes.createMoveTarget(rewrite, this.expressionToMove));
            newSVDecl.setType(ASTNodes.createMoveTarget(rewrite, this.nodeToComplete.getRightOperand()));
            if (Modifier.isFinal((int)this.statementToRemove.getModifiers())) {
                newSVDecl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.fromFlagValue((int)16)));
            }
            if (ast.apiLevel() == 20 && ast.isPreviewEnabled() || ast.apiLevel() > 20) {
                TypePattern newTypePattern = ast.newTypePattern();
                newTypePattern.setPatternVariable((VariableDeclaration)newSVDecl);
                newInstanceof.setPattern((Pattern)newTypePattern);
            } else {
                newInstanceof.setRightOperand(newSVDecl);
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.nodeToComplete, (ASTNode)newInstanceof, group);
            if (ASTNodes.canHaveSiblings((Statement)this.statementToRemove) || this.statementToRemove.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.statementToRemove, group);
            } else {
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.statementToRemove, (ASTNode)ast.newBlock(), group);
            }
            importRemover.registerRemovedNode((ASTNode)this.statementToRemove);
        }
    }
}

