/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine;

import java.math.BigDecimal;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.runner.Version;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class JUnit4VersionCheck {
    private static final Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+).*");
    private static final BigDecimal minVersion = new BigDecimal("4.12");

    JUnit4VersionCheck() {
    }

    static void checkSupported() {
        try {
            JUnit4VersionCheck.checkSupported(Version::id);
        }
        catch (NoClassDefFoundError e) {
            throw new JUnitException("Invalid class/module path: junit-vintage-engine is present but junit:junit is not. Please either remove junit-vintage-engine or add junit:junit, or alternatively use an excludeEngines(\"junit-vintage\") filter.");
        }
    }

    static void checkSupported(Supplier<String> versionSupplier) {
        String versionString = JUnit4VersionCheck.readVersion(versionSupplier);
        BigDecimal version = JUnit4VersionCheck.parseVersion(versionString);
        if (version.compareTo(minVersion) < 0) {
            throw new JUnitException("Unsupported version of junit:junit: " + versionString + ". Please upgrade to version " + minVersion + " or later.");
        }
    }

    static BigDecimal parseVersion(String versionString) {
        try {
            Matcher matcher = versionPattern.matcher(versionString);
            if (matcher.matches()) {
                return new BigDecimal(matcher.group(1));
            }
        }
        catch (Exception e) {
            throw new JUnitException("Failed to parse version of junit:junit: " + versionString, (Throwable)e);
        }
        throw new JUnitException("Failed to parse version of junit:junit: " + versionString);
    }

    private static String readVersion(Supplier<String> versionSupplier) {
        try {
            return versionSupplier.get();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)t);
            throw new JUnitException("Failed to read version of junit:junit", t);
        }
    }
}

