/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.TypeAnnotations;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.builder.BuildContext;
import org.eclipse.pde.api.tools.internal.builder.BuildStamps;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.osgi.framework.Version;

public class IncrementalApiBuilder {
    private static final int UNKNOWN = 0;
    private static final int CLASS_FILE = 1;
    private static final int JAVA__FILE = 2;
    private static final int STRUCTURAL = 1;
    private static final int DESCRIPTION = 2;
    ApiAnalysisBuilder builder = null;
    BuildContext context = null;
    IApiBaseline workspaceBaseline = null;

    public IncrementalApiBuilder(ApiAnalysisBuilder builder) {
        this.builder = builder;
    }

    public void build(IApiBaseline baseline, IApiBaseline wbaseline, IResourceDelta[] deltas, State state, BuildState buildstate, IProgressMonitor monitor) throws CoreException {
        IProject project = this.builder.getProject();
        this.workspaceBaseline = wbaseline;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)BuilderMessages.IncrementalBuilder_builder_for_project, (Object)project.getName()), (int)1);
        this.context = new BuildContext();
        try {
            try {
                String[] projectNames = buildstate.getReexportedComponents();
                HashSet<IProject> depprojects = null;
                if (projectNames.length != 0) {
                    depprojects = new HashSet<IProject>();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject pj = null;
                    String[] stringArray = projectNames;
                    int n = projectNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String projectName = stringArray[n2];
                        pj = root.getProject(projectName);
                        if (pj.isAccessible() && baseline != null && baseline.getApiComponent(projectName) == null) {
                            depprojects.add(pj);
                        }
                        ++n2;
                    }
                }
                long prev = buildstate.getBuildPathCRC();
                long curr = BuildState.computeBuildPathCRC(project);
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(curr != prev);
                IResourceDelta[] iResourceDeltaArray = deltas;
                int n = deltas.length;
                int n3 = 0;
                while (n3 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n3];
                    delta.accept((IResourceDeltaVisitor)visitor);
                    ++n3;
                }
                this.buildContext(project, state, visitor.changes, depprojects);
                this.build(project, baseline, wbaseline, state, buildstate, (IProgressMonitor)localmonitor.split(1));
            }
            catch (OperationCanceledException oce) {
                if (ApiPlugin.DEBUG_BUILDER) {
                    System.out.println("ApiAnalysisBuilder: Trapped OperationCanceledException");
                }
                this.context.dispose();
            }
        }
        finally {
            this.context.dispose();
        }
    }

    void build(IProject project, IApiBaseline baseline, IApiBaseline wbaseline, State state, BuildState buildstate, IProgressMonitor monitor) {
        IPluginModelBase currentModel;
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)BuilderMessages.api_analysis_on_0, (int)3);
        localmonitor.subTask(NLS.bind((String)BuilderMessages.ApiAnalysisBuilder_finding_affected_source_files, (Object)project.getName()));
        if (this.context.hasTypes() && (currentModel = this.builder.getCurrentModel()) != null) {
            Version version;
            String id = currentModel.getBundleDescription().getSymbolicName();
            IApiComponent comp = wbaseline.getApiComponent(id, version = currentModel.getBundleDescription().getVersion());
            if (comp == null) {
                return;
            }
            this.extClean(project, buildstate, (IProgressMonitor)localmonitor.split(1));
            this.builder.getAnalyzer().analyzeComponent(buildstate, null, null, baseline, comp, this.context, (IProgressMonitor)localmonitor.split(1));
            localmonitor.split(1);
            this.builder.createMarkers();
        }
    }

    private void addDependentTypeToContext(IFile file, int kind) {
        String type = this.resolveTypeName((IResource)file, 2);
        if (type == null) {
            return;
        }
        if ((1 & kind) > 0 && !this.context.containsStructuralChange(type)) {
            this.builder.cleanupCompatibilityMarkers((IResource)file);
        }
        if ((2 & kind) > 0 && !this.context.containsDescriptionChange(type) && !this.context.containsDescriptionDependent(type)) {
            this.builder.cleanupUsageMarkers((IResource)file);
            this.builder.cleanUnusedFilterMarkers((IResource)file);
            this.context.recordDescriptionDependent(type);
        }
        this.addInnerTypesToDependents(file, kind);
    }

    private void addInnerTypesToDependents(IFile file, int kind) {
        ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
        IType[] types = null;
        try {
            types = unit.getAllTypes();
            String typename = null;
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                typename = type.getFullyQualifiedName('$');
                if ((2 & kind) > 0 && !this.context.containsDescriptionChange(typename) && !this.context.containsDescriptionDependent(typename)) {
                    this.context.recordDescriptionDependent(typename);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void addInnerTypes(IFile file, int kind) {
        ICompilationUnit unit = (ICompilationUnit)JavaCore.create((IFile)file);
        IType[] types = null;
        try {
            types = unit.getAllTypes();
            String typename = null;
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                typename = type.getFullyQualifiedName('$');
                if ((1 & kind) > 0 && !this.context.containsStructuralChange(typename)) {
                    this.context.recordStructuralChange(typename);
                }
                if ((2 & kind) > 0 && !this.context.containsDescriptionChange(typename)) {
                    this.context.recordDescriptionChanged(typename);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    void buildContext(IProject project, State state, List<Change> changes, HashSet<IProject> depprojects) {
        StringSet structural = null;
        StringSet description = null;
        for (Change change : changes) {
            IResource member;
            boolean contained = change.isContained(project, depprojects);
            if ((change.changeKind & 1) > 0) {
                if (change.deltaKind != 2) {
                    if (structural == null) {
                        structural = new StringSet(16);
                    }
                    structural.add(change.typeName);
                }
                if (contained) {
                    this.context.recordStructuralChange(change.typeName);
                    if (change.deltaKind == 2) {
                        this.context.recordRemovedType(change.typeName);
                    }
                }
            }
            if ((change.changeKind & 2) > 0) {
                if (description == null) {
                    description = new StringSet(16);
                }
                description.add(change.typeName);
                if (contained) {
                    this.context.recordDescriptionChanged(change.typeName);
                }
            }
            if (!contained) continue;
            if (change.fileKind == 2) {
                this.builder.cleanupMarkers((IResource)change.resource);
                this.addInnerTypes(change.resource, change.changeKind);
                continue;
            }
            String path = (String)state.typeLocators.get(change.typeName);
            if (path == null || (member = this.builder.getProject().findMember(path)) == null || member.getType() != 1) continue;
            IFile source = (IFile)member;
            this.builder.cleanupMarkers((IResource)source);
            this.addInnerTypes(source, change.changeKind);
        }
        if (changes.size() == 1 && structural != null && description != null) {
            types = structural.values;
            if (types.length > 0) {
                this.addDependents(project, state, types, 3);
            }
        } else {
            if (structural != null && (types = structural.values).length > 0) {
                this.addDependents(project, state, types, 1);
            }
            if (description != null && (types = description.values).length > 0) {
                this.addDependents(project, state, types, 2);
            }
        }
    }

    private void addDependents(IProject project, State state, String[] types, int kind) {
        char[][] internedSimpleNames;
        StringSet packages = new StringSet(16);
        StringSet typenames = new StringSet(16);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type != null) {
                this.splitName(type, packages, typenames);
            }
            ++n2;
        }
        char[][][] internedQualifiedNames = ReferenceCollection.internQualifiedNames((StringSet)packages);
        if (internedQualifiedNames.length < packages.elementSize) {
            internedQualifiedNames = null;
        }
        if ((internedSimpleNames = ReferenceCollection.internSimpleNames((StringSet)typenames, (boolean)true)).length < typenames.elementSize) {
            internedSimpleNames = null;
        }
        Set entrySet = state.getReferences().entrySet();
        for (Map.Entry entry : entrySet) {
            IFile file;
            String typeLocator = (String)entry.getKey();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (!refs.includes(internedQualifiedNames, internedSimpleNames, null) || (file = project.getFile(typeLocator)) == null) continue;
            if (ApiPlugin.DEBUG_BUILDER) {
                System.out.println("ApiAnalysisBuilder:   adding affected source file " + file.getName());
            }
            this.addDependentTypeToContext(file, kind);
        }
    }

    void splitName(String typename, StringSet packages, StringSet simpleTypes) {
        int idx = typename.lastIndexOf(47);
        String packageName = idx < 0 ? "" : typename.substring(0, idx);
        String typeName = idx < 0 ? typename : typename.substring(idx + 1, typename.length());
        if ((idx = typeName.indexOf(36)) > 0) {
            typeName = typeName.substring(0, idx);
        }
        if (simpleTypes.add(typeName) && packages.add(packageName) && ApiPlugin.DEBUG_BUILDER) {
            System.out.println("ApiAnalysisBuilder:   will look for dependents of " + typeName + " in " + packageName);
        }
    }

    void extClean(IProject project, BuildState state, IProgressMonitor monitor) {
        String[] types;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        String[] stringArray = types = this.context.getRemovedTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            state.cleanup(type);
            ++n2;
        }
        subMonitor.split(1);
        IResource resource = project.findMember(ApiAnalysisBuilder.MANIFEST_PATH);
        if (resource != null) {
            try {
                IMarker marker;
                IMarker[] markers = resource.findMarkers("org.eclipse.pde.api.tools.compatibility", false, 0);
                String tname = null;
                IMarker[] iMarkerArray = markers;
                int n3 = markers.length;
                int n4 = 0;
                while (n4 < n3) {
                    marker = iMarkerArray[n4];
                    tname = Util.getTypeNameFromMarker(marker);
                    if (this.context.containsStructuralChange(tname)) {
                        marker.delete();
                    }
                    ++n4;
                }
                subMonitor.split(1);
                iMarkerArray = markers = resource.findMarkers("org.eclipse.pde.api.tools.unused_filters", false, 0);
                n3 = markers.length;
                n4 = 0;
                while (n4 < n3) {
                    marker = iMarkerArray[n4];
                    tname = Util.getTypeNameFromMarker(marker);
                    if (this.context.containsStructuralChange(tname)) {
                        marker.delete();
                    }
                    ++n4;
                }
                subMonitor.split(1);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    String resolveTypeName(IResource resource, int kind) {
        HashSet<IPath> paths;
        IPath typepath = resource.getFullPath();
        int type = kind;
        if (kind == 0) {
            if (Util.isClassFile(resource.getName())) {
                type = 1;
            } else if (Util.isJavaFileName(resource.getName())) {
                type = 2;
            }
        }
        switch (type) {
            case 2: {
                HashSet<IPath> hashSet = this.builder.src_locs.get(resource.getProject());
                break;
            }
            case 1: {
                HashSet<IPath> hashSet = this.builder.output_locs.get(resource.getProject());
                break;
            }
            default: {
                HashSet<IPath> hashSet = paths = null;
            }
        }
        if (paths != null) {
            for (IPath path : paths) {
                if (!path.isPrefixOf(typepath)) continue;
                typepath = typepath.removeFirstSegments(path.segmentCount()).removeFileExtension();
                return typepath.toString();
            }
        }
        return null;
    }

    static class Change {
        int changeKind;
        int fileKind;
        int deltaKind;
        IProject project;
        IFile resource;
        String typeName;

        Change(int kind, int deltaKind, IFile resource, String typeName, int fileKind) {
            this.changeKind = kind;
            this.deltaKind = deltaKind;
            this.resource = resource;
            this.project = resource.getProject();
            this.typeName = typeName;
            this.fileKind = fileKind;
        }

        boolean isContained(IProject lproject, HashSet<IProject> others) {
            return this.project.equals((Object)lproject) || others != null && others.contains(this.project);
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        List<Change> changes = new ArrayList<Change>();
        boolean buildpathChanged = false;

        ResourceDeltaVisitor(boolean pathChanged) {
            this.buildpathChanged = pathChanged;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            return switch (delta.getResource().getType()) {
                case 2, 4, 8 -> true;
                case 1 -> {
                    String type;
                    IFile resource = (IFile)delta.getResource();
                    String fileName = resource.getName();
                    if (Util.isClassFile(fileName)) {
                        String typename;
                        if (delta.getKind() == 2) {
                            String typename = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 1);
                            if (typename != null) {
                                if (ApiPlugin.DEBUG_BUILDER) {
                                    System.out.println("ApiAnalysisBuilder: Found removed class file " + typename);
                                }
                                this.changes.add(new Change(1, delta.getKind(), resource, typename, 1));
                            }
                        } else if (this.buildpathChanged && delta.getKind() == 4 && (delta.getFlags() & 0x100) > 0 && (typename = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 1)) != null) {
                            this.changes.add(new Change(1, delta.getKind(), resource, typename, 1));
                        }
                    } else if (Util.isJavaFileName(fileName) && (type = IncrementalApiBuilder.this.resolveTypeName((IResource)resource, 2)) != null) {
                        Change change = new Change(1, delta.getKind(), resource, type, 2);
                        this.changes.add(change);
                        IApiComponent component = IncrementalApiBuilder.this.workspaceBaseline.getApiComponent(resource.getProject());
                        if (component != null) {
                            try {
                                TypeAnnotations ta;
                                IApiAnnotations annotations = component.getApiDescription().resolveAnnotations(Factory.typeDescriptor(type.replace('/', '.')));
                                if (annotations instanceof TypeAnnotations && (ta = (TypeAnnotations)annotations).getBuildStamp() == BuildStamps.getBuildStamp(resource.getProject())) {
                                    change.changeKind |= 2;
                                }
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }
}

