/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.op.EGitGpgConfig;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.team.core.TeamException;

public class TagOperation
implements IEGitOperation {
    @NonNull
    private final Repository repository;
    private boolean force;
    private boolean annotated = true;
    private Boolean sign;
    @NonNull
    private String name = "";
    private String message;
    private RevCommit target;
    private PersonIdent tagger;
    private CredentialsProvider credentialsProvider;

    public TagOperation(@NonNull Repository repository) {
        this.repository = repository;
    }

    public TagOperation setForce(boolean force) {
        this.force = force;
        return this;
    }

    public boolean isForce() {
        return this.force;
    }

    public TagOperation setAnnotated(boolean annotated) {
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public TagOperation setSign(Boolean sign) {
        this.sign = sign;
        return this;
    }

    @Nullable
    public Boolean getSign() {
        return this.sign;
    }

    public TagOperation setName(@NonNull String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TagOperation setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public TagOperation setTarget(@NonNull RevCommit target) {
        this.target = target;
        return this;
    }

    public RevCommit getTarget() {
        return this.target;
    }

    public TagOperation setTagger(PersonIdent tagger) {
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public TagOperation setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName(MessageFormat.format(CoreText.TagOperation_performingTagging, this.getName()));
        try {
            Throwable throwable = null;
            Object var4_8 = null;
            try (Git git = new Git(this.repository);){
                CredentialsProvider provider;
                TagCommand command = git.tag().setName(this.getName()).setForceUpdate(this.isForce()).setObjectId((RevObject)this.getTarget());
                if (!this.isAnnotated()) {
                    GpgConfig config;
                    if (Boolean.FALSE.equals(this.sign)) {
                        this.setMessage(null);
                        this.setTagger(null);
                        command.setAnnotated(false);
                    } else if (this.sign == null && !(config = new GpgConfig((Config)this.repository.getConfig())).isSignAllTags()) {
                        this.setMessage(null);
                        this.setTagger(null);
                        command.setAnnotated(false);
                    }
                }
                command.setMessage(this.getMessage()).setTagger(this.getTagger());
                if (this.sign != null) {
                    command.setSigned(this.sign.booleanValue());
                }
                if ((provider = this.getCredentialsProvider()) != null) {
                    command.setCredentialsProvider(provider);
                }
                command.setGpgConfig((GpgConfig)new EGitGpgConfig((Config)this.repository.getConfig()));
                command.call();
                progress.worked(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GpgConfigurationException e) {
            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (RefAlreadyExistsException e) {
            if (!RefUpdate.Result.NO_CHANGE.equals((Object)e.getUpdateResult())) {
                throw new TeamException(MessageFormat.format(CoreText.TagOperation_taggingFailure, this.getName(), e.getMessage()), (Throwable)e);
            }
        }
        catch (GitAPIException e) {
            throw new TeamException(MessageFormat.format(CoreText.TagOperation_taggingFailure, this.getName(), e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

