/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.osgi.framework.BundleContext;

public class TestingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.testing.ecl";
    private static TestingPlugin plugin = null;
    private Map<String, List<Object>> globals = new HashMap<String, List<Object>>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static TestingPlugin getDefault() {
        return plugin;
    }

    public static IStatus createErrStatus(String message) {
        return TestingPlugin.createErrStatus(message, null);
    }

    public static void logErr(String message, Throwable t) {
        TestingPlugin.getDefault().getLog().log(TestingPlugin.createErrStatus(message, t));
    }

    public static IStatus createErrStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.rcptt.tests.ecl", message, t);
    }

    public static String encodeExecStatus(ExecutionStatus status) {
        String msg;
        IStatus cause;
        StringBuilder buffer = new StringBuilder();
        String message = status.getMessage();
        if (message == null || message.length() == 0) {
            message = "Execution failed";
        }
        buffer.append(message);
        if (status.hasLocation()) {
            buffer.append(" at ");
            buffer.append(status.getLine());
            buffer.append(":");
            buffer.append(status.getColumn());
        }
        if ((cause = status.getCause()) != null && (msg = cause.getMessage()) != null && msg.length() > 0) {
            buffer.append("\n");
            buffer.append("Caused by:");
            msg = msg.replace("\n", "\n\t");
            buffer.append("\n").append("\t").append(msg);
        }
        buffer.append("\n");
        Throwable t = status.getException();
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                buffer.append("\tat ");
                buffer.append(trace[i]);
                buffer.append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }

    public Map<String, List<Object>> getGlobals() {
        return this.globals;
    }
}

