/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.core.text;

import org.eclipse.pde.internal.core.text.DocumentNodeFactory;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSFactoryProperties;
import org.eclipse.pde.internal.ds.core.IDSFactoryProperty;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSComponent;
import org.eclipse.pde.internal.ds.core.text.DSFactoryProperties;
import org.eclipse.pde.internal.ds.core.text.DSFactoryProperty;
import org.eclipse.pde.internal.ds.core.text.DSImplementation;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.core.text.DSProperties;
import org.eclipse.pde.internal.ds.core.text.DSProperty;
import org.eclipse.pde.internal.ds.core.text.DSProvide;
import org.eclipse.pde.internal.ds.core.text.DSReference;
import org.eclipse.pde.internal.ds.core.text.DSService;

public class DSDocumentFactory
extends DocumentNodeFactory
implements IDSDocumentFactory {
    private final DSModel fModel;

    public DSDocumentFactory(DSModel model) {
        this.fModel = model;
    }

    public IDocumentElementNode createDocumentNode(String name, IDocumentElementNode parent) {
        int index = name.indexOf(58);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (this.isRoot(name)) {
            return this.createComponent();
        }
        if (parent.getXMLTagName().equals("component")) {
            if (this.isImplementation(name)) {
                return this.createImplementation();
            }
            if (this.isProperties(name)) {
                return this.createProperties();
            }
            if (this.isProperty(name)) {
                return this.createProperty();
            }
            if ("factory-properties".equals(name)) {
                return this.createFactoryProperties();
            }
            if ("factory-property".equals(name)) {
                return this.createFactoryProperty();
            }
            if (this.isService(name)) {
                return this.createService();
            }
            if (this.isReference(name)) {
                return this.createReference();
            }
        }
        if (parent.getXMLTagName().equals("service") && this.isProvide(name)) {
            return this.createProvide();
        }
        return super.createDocumentNode(name, parent);
    }

    @Override
    public IDSProvide createProvide() {
        return new DSProvide(this.fModel);
    }

    @Override
    public IDSProperty createProperty() {
        return new DSProperty(this.fModel);
    }

    @Override
    public IDSFactoryProperty createFactoryProperty() {
        return new DSFactoryProperty(this.fModel);
    }

    @Override
    public IDSReference createReference() {
        return new DSReference(this.fModel);
    }

    @Override
    public IDSService createService() {
        return new DSService(this.fModel);
    }

    @Override
    public IDSProperties createProperties() {
        return new DSProperties(this.fModel);
    }

    @Override
    public IDSFactoryProperties createFactoryProperties() {
        return new DSFactoryProperties(this.fModel);
    }

    @Override
    public IDSImplementation createImplementation() {
        return new DSImplementation(this.fModel);
    }

    @Override
    public IDSComponent createComponent() {
        return new DSComponent(this.fModel);
    }

    private boolean isReference(String name) {
        return name.equals("reference");
    }

    private boolean isService(String name) {
        return name.equals("service");
    }

    private boolean isProperties(String name) {
        return name.equals("properties");
    }

    private boolean isImplementation(String name) {
        return name.equals("implementation");
    }

    private boolean isRoot(String name) {
        return name.equals("component");
    }

    private boolean isProperty(String name) {
        return name.equals("property");
    }

    private boolean isProvide(String name) {
        return name.equals("provide");
    }
}

