/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.recording;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.recording.CommandInfo;
import org.eclipse.rcptt.core.recording.CommandSet;
import org.eclipse.rcptt.core.recording.IRecordingMonitor;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaScenarioContainer;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.RecordingModeRequest;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.UpdateControlCommand;
import org.eclipse.rcptt.tesla.core.protocol.raw.AssertionFocus;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandTransfer;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetFeature;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaMode;
import org.eclipse.rcptt.tesla.internal.core.network.DataSerializer;
import org.eclipse.rcptt.tesla.internal.core.network.IConnectionMonitor;
import org.eclipse.rcptt.tesla.recording.core.ITeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.TeslaNetworkRecorder;

public class NetworkRecorder
extends TeslaNetworkRecorder {
    private static final String RAW_EVENTS_FEATURE = "raw_events";
    private static final String NOT_NATIVE_EVENTS_IGNORED_FEATURE = "not_native_events_ignored";
    private TeslaScenarioContainer assertContainer = new TeslaScenarioContainer();
    private IAssertModeListener assertModeListener;
    private boolean assertMode = false;

    public NetworkRecorder(String host, int port, IRecordingMonitor monitor) {
        super(host, port, (IConnectionMonitor)monitor);
    }

    public boolean isAssertMode() {
        return this.assertMode;
    }

    protected IRecordingMonitor getMonitor() {
        return (IRecordingMonitor)this.monitor;
    }

    public void toAssertMode(String ... classes) throws IOException {
        this.assertContainer = new TeslaScenarioContainer();
        this.assertMode = true;
        this.setMode(TeslaMode.ASSERTIONS, classes);
    }

    public void toRecordMode() throws IOException {
        this.assertMode = false;
        this.setMode(TeslaMode.RECORDING, new String[0]);
    }

    public void addAsserts(CommandSet commands, Assert[] asserts) {
        TeslaScenarioContainer container = this.getContainer();
        CommandInfo[] commandInfoArray = commands.getCommands();
        int n = commandInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandInfo info = commandInfoArray[n2];
            container.add(info.getCommand(), info.getElements(), info.getControls(), null);
            ++n2;
        }
        commandInfoArray = asserts;
        n = asserts.length;
        n2 = 0;
        while (n2 < n) {
            CommandInfo asrt = commandInfoArray[n2];
            container.add((Command)asrt, null, null, null);
            ++n2;
        }
        for (ITeslaRecorder.ITeslaRecordListener listener : this.getListeners()) {
            listener.handleContainerChange();
        }
    }

    protected void processTransfer(CommandTransfer transfer) throws IOException {
        if (transfer.getCommand() instanceof Type) {
            if (this.isStopRecordRequest((Type)transfer.getCommand())) {
                this.getMonitor().stopRecord();
                return;
            }
            if (this.isAssertModeRequest((Type)transfer.getCommand())) {
                this.getMonitor().assertMode();
                if (this.assertModeListener != null) {
                    this.assertModeListener.doAssertMode();
                }
                return;
            }
        } else if (transfer.getCommand() instanceof UpdateControlCommand) {
            this.updateControl(transfer, (UpdateControlCommand)transfer.getCommand());
            return;
        }
        if (this.assertMode) {
            this.assertContainer.processTransfer(transfer.getCommand(), (List)transfer.getElements(), transfer.getKind(), (List)transfer.getControls(), transfer.getIndex(), (List)transfer.getRawEvents());
            if (transfer.getCommand() instanceof AssertionFocus) {
                AssertionFocus focus = (AssertionFocus)transfer.getCommand();
                this.addWidget(focus);
            }
            if (transfer.getCommand() instanceof RecordingModeRequest) {
                this.getMonitor().recordMode();
            }
        } else {
            if (transfer.getCommand() instanceof AssertionFocus) {
                return;
            }
            super.processTransfer(transfer);
        }
    }

    private void updateControl(CommandTransfer transfer, UpdateControlCommand command) {
        Element element = command.getElements();
        if (element != null) {
            Command cmd = this.getCommand(element, this.assertContainer);
            if (cmd == null) {
                return;
            }
            EList elementMapping = this.assertContainer.getScenario().getElementMapping();
            for (CommandToElementEntry commandToElementEntry : elementMapping) {
                if (!commandToElementEntry.getCommand().equals(cmd)) continue;
                commandToElementEntry.getControls().clear();
                commandToElementEntry.getControls().addAll((Collection)transfer.getControls());
            }
        }
    }

    private Command getCommand(Element element, TeslaScenarioContainer container) {
        if (element == null || element.getId() == null) {
            return null;
        }
        List commands = container.getCommands();
        int i = commands.size() - 1;
        while (i >= 0) {
            Command cmd = (Command)commands.get(i);
            List elements = container.getElements(cmd);
            if (elements != null) {
                for (Element elementToCheck : elements) {
                    if (!element.getId().equals(elementToCheck.getId())) continue;
                    return cmd;
                }
            }
            --i;
        }
        return null;
    }

    protected boolean isAssertModeRequest(Type command) {
        return false;
    }

    protected boolean isRecordingModeRequest(Type command) {
        return false;
    }

    protected boolean isStartRecordRequest(Type command) {
        return false;
    }

    protected boolean isStopRecordRequest(Type command) {
        return false;
    }

    protected boolean isReplayRequest(Type command) {
        return false;
    }

    private void addWidget(AssertionFocus focus) {
        try {
            if (focus.isPointFixed()) {
                CommandSet commands = CommandSet.create(focus, this.assertContainer);
                this.getMonitor().assertAdded(commands);
            } else {
                this.getMonitor().assertAdded(null);
            }
        }
        catch (Exception e) {
            RcpttPlugin.log(e);
        }
    }

    public void setFeature(String name, String value) {
        SetFeature newMode = RawFactory.eINSTANCE.createSetFeature();
        newMode.setName(name);
        newMode.setValue(value);
        try {
            if (!this.isConnected()) {
                this.doConnect(this.monitor);
            }
            if (this.output != null) {
                DataSerializer.writeEObject((DataOutputStream)this.output, (EObject)newMode);
            }
        }
        catch (IOException e) {
            RcpttPlugin.log(e);
        }
    }

    public void enableRawEvents(boolean rawSupported) {
        this.setFeature(RAW_EVENTS_FEATURE, rawSupported ? "true" : "false");
    }

    public void setNotNativeEventsIgnored(boolean ignored) {
        this.setFeature(NOT_NATIVE_EVENTS_IGNORED_FEATURE, ignored ? "true" : "false");
    }

    public void setAssertModeListener(IAssertModeListener iAssertModeListener) {
        this.assertModeListener = iAssertModeListener;
    }

    public void resetAssertSelection() {
        try {
            DataSerializer.writeEObject((DataOutputStream)this.output, (EObject)RawFactory.eINSTANCE.createResetAssertSelection());
        }
        catch (IOException e) {
            RcpttPlugin.log(e);
        }
    }

    public static interface IAssertModeListener {
        public void doAssertMode();
    }
}

