/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.debug.BreakpointResource;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.LaunchConfiguration;
import org.eclipse.rcptt.debug.LaunchType;

public class DebugContextAdapter {
    final DebugContext model;

    public DebugContextAdapter(DebugContext context) {
        this.model = context;
    }

    public LaunchConfiguration getConfiguration(String name) {
        assert (name != null);
        for (LaunchType type : this.model.getLaunchTypes()) {
            for (LaunchConfiguration conf : type.getConfigurations()) {
                assert (conf.getName() != null);
                if (!conf.getName().equals(name)) continue;
                return conf;
            }
        }
        throw new IllegalArgumentException("No configuration named " + name);
    }

    public List<LaunchType> getNonEmptyLaunchTypes() {
        ArrayList<LaunchType> rv = new ArrayList<LaunchType>();
        for (LaunchType type : this.model.getLaunchTypes()) {
            if (type.getConfigurations().size() <= 0) continue;
            rv.add(type);
        }
        return rv;
    }

    public List<BreakpointResource> getNonEmptyBreakpointResources() {
        ArrayList<BreakpointResource> rv = new ArrayList<BreakpointResource>();
        for (BreakpointResource type : this.model.getBreakpointResources()) {
            if (type.getBreakpoints().size() <= 0) continue;
            rv.add(type);
        }
        return rv;
    }

    public static NamedElement findAttribute(List<NamedElement> attributes, String name) {
        for (NamedElement attribute : attributes) {
            if (!name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public LaunchType getLaunchType(String id) {
        for (LaunchType type : this.model.getLaunchTypes()) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        throw new IllegalArgumentException("Can't find launch configuration type " + id);
    }
}

