/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.IStabilityClassifier;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFFormulaEvaluator
implements FormulaEvaluator {
    private WorkbookEvaluator _bookEvaluator;
    private XSSFWorkbook _book;

    public XSSFFormulaEvaluator(XSSFWorkbook workbook) {
        this(workbook, null, null);
    }

    @Deprecated
    public XSSFFormulaEvaluator(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier) {
        this._bookEvaluator = new WorkbookEvaluator((EvaluationWorkbook)XSSFEvaluationWorkbook.create(workbook), stabilityClassifier, null);
        this._book = workbook;
    }

    private XSSFFormulaEvaluator(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._bookEvaluator = new WorkbookEvaluator((EvaluationWorkbook)XSSFEvaluationWorkbook.create(workbook), stabilityClassifier, udfFinder);
        this._book = workbook;
    }

    public static XSSFFormulaEvaluator create(XSSFWorkbook workbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new XSSFFormulaEvaluator(workbook, stabilityClassifier, udfFinder);
    }

    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf((boolean)cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError((int)cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    public int evaluateFormulaCell(Cell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cv = this.evaluateFormulaCellValue(cell);
        XSSFFormulaEvaluator.setCellValue(cell, cv);
        return cv.getCellType();
    }

    public XSSFCell evaluateInCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        XSSFCell result = (XSSFCell)cell;
        if (cell.getCellType() == 2) {
            CellValue cv = this.evaluateFormulaCellValue(cell);
            XSSFFormulaEvaluator.setCellType(cell, cv);
            XSSFFormulaEvaluator.setCellValue(cell, cv);
        }
        return result;
    }

    private static void setCellType(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue((RichTextString)new XSSFRichTextString(cv.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    public static void evaluateAllFormulaCells(XSSFWorkbook wb) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)wb);
    }

    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)this._book);
    }

    private CellValue evaluateFormulaCellValue(Cell cell) {
        if (!(cell instanceof XSSFCell)) {
            throw new IllegalArgumentException("Unexpected type of cell: " + cell.getClass() + "." + " Only XSSFCells can be evaluated.");
        }
        ValueEval eval = this._bookEvaluator.evaluate((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf((boolean)be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError((int)((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(value);
    }
}

