/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.rdf.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.hasmac.rdf.RdfGraph;
import no.hasmac.rdf.RdfResource;
import no.hasmac.rdf.RdfTriple;
import no.hasmac.rdf.RdfValue;

final class RdfGraphImpl
implements RdfGraph {
    private final Map<RdfResource, Map<RdfResource, Set<RdfValue>>> index = new HashMap<RdfResource, Map<RdfResource, Set<RdfValue>>>(1);
    private final List<RdfTriple> triples = new ArrayList<RdfTriple>();

    protected RdfGraphImpl() {
    }

    public void add(RdfTriple triple) {
        if (triple == null) {
            throw new IllegalArgumentException();
        }
        this.index.computeIfAbsent(triple.getSubject(), x -> new HashMap(1)).computeIfAbsent(triple.getPredicate(), x -> new HashSet(1)).add(triple.getObject());
        this.triples.add(triple);
    }

    @Override
    public boolean contains(RdfTriple triple) {
        if (triple == null) {
            throw new IllegalArgumentException();
        }
        return this.index.containsKey(triple.getSubject()) && this.index.get(triple.getSubject()).containsKey(triple.getPredicate()) && this.index.get(triple.getSubject()).get(triple.getPredicate()).contains(triple.getObject());
    }

    @Override
    public List<RdfTriple> toList() {
        return this.triples;
    }
}

