/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.intervals;

import java.io.IOException;
import org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.FilterMatchesIterator;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;

class CachingMatchesIterator
extends FilterMatchesIterator
implements IntervalMatchesIterator {
    private boolean positioned = false;
    private int[] posAndOffsets = new int[16];
    private Query[] matchingQueries = new Query[4];
    private int count = 0;

    CachingMatchesIterator(IntervalMatchesIterator in) {
        super((MatchesIterator)in);
    }

    private void cache() throws IOException {
        this.count = 0;
        MatchesIterator mi = this.in.getSubMatches();
        if (mi == null) {
            this.count = 1;
            this.posAndOffsets[0] = this.in.startPosition();
            this.posAndOffsets[1] = this.in.endPosition();
            this.posAndOffsets[2] = this.in.startOffset();
            this.posAndOffsets[3] = this.in.endOffset();
            this.matchingQueries[0] = this.in.getQuery();
        } else {
            while (mi.next()) {
                if (this.count * 4 >= this.posAndOffsets.length) {
                    this.posAndOffsets = ArrayUtil.grow((int[])this.posAndOffsets, (int)((this.count + 1) * 4));
                    this.matchingQueries = (Query[])ArrayUtil.grow((Object[])this.matchingQueries, (int)(this.count + 1));
                }
                this.posAndOffsets[this.count * 4] = mi.startPosition();
                this.posAndOffsets[this.count * 4 + 1] = mi.endPosition();
                this.posAndOffsets[this.count * 4 + 2] = mi.startOffset();
                this.posAndOffsets[this.count * 4 + 3] = mi.endOffset();
                this.matchingQueries[this.count] = mi.getQuery();
                ++this.count;
            }
        }
    }

    public boolean next() throws IOException {
        if (!this.positioned) {
            this.positioned = true;
        } else {
            this.cache();
        }
        return this.in.next();
    }

    int startOffset(int endPos) throws IOException {
        if (this.endPosition() <= endPos) {
            return this.in.startOffset();
        }
        return this.posAndOffsets[2];
    }

    int endOffset(int endPos) throws IOException {
        if (this.endPosition() <= endPos) {
            return this.in.endOffset();
        }
        return this.posAndOffsets[this.count * 4 + 3];
    }

    MatchesIterator getSubMatches(int endPos) throws IOException {
        if (this.endPosition() <= endPos) {
            this.cache();
        }
        return new MatchesIterator(){
            int upto = -1;

            public boolean next() {
                ++this.upto;
                return this.upto < CachingMatchesIterator.this.count;
            }

            public int startPosition() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4];
            }

            public int endPosition() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 1];
            }

            public int startOffset() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 2];
            }

            public int endOffset() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 3];
            }

            public MatchesIterator getSubMatches() {
                return null;
            }

            public Query getQuery() {
                return CachingMatchesIterator.this.matchingQueries[this.upto];
            }
        };
    }

    @Override
    public int gaps() {
        return ((IntervalMatchesIterator)this.in).gaps();
    }

    @Override
    public int width() {
        return ((IntervalMatchesIterator)this.in).width();
    }
}

