/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class BindLeftJoinIteration
extends LookAheadIteration<BindingSet> {
    protected final CloseableIteration<BindingSet> iter;
    protected final List<BindingSet> bindings;
    protected IntHashSet seenBindingIndexes = new IntHashSet();
    protected final ListIterator<BindingSet> bindingsIterator;

    public BindLeftJoinIteration(CloseableIteration<BindingSet> iter, List<BindingSet> bindings) {
        this.iter = iter;
        this.bindings = bindings;
        this.bindingsIterator = bindings.listIterator();
    }

    @Override
    protected BindingSet getNextElement() {
        if (this.iter.hasNext()) {
            BindingSet bIn = (BindingSet)this.iter.next();
            int bIndex = ((Literal)bIn.getValue("__index")).intValue();
            this.seenBindingIndexes.add(bIndex);
            return this.convert(bIn, bIndex);
        }
        while (this.bindingsIterator.hasNext()) {
            if (this.seenBindingIndexes.contains(this.bindingsIterator.nextIndex())) {
                this.bindingsIterator.next();
                continue;
            }
            return this.bindingsIterator.next();
        }
        return null;
    }

    @Override
    protected void handleClose() {
        this.iter.close();
    }

    protected BindingSet convert(BindingSet bIn, int bIndex) throws QueryEvaluationException {
        QueryBindingSet res = new QueryBindingSet();
        for (Binding b : bIn) {
            if (b.getName().equals("__index")) continue;
            res.addBinding(b);
        }
        for (Binding bs : this.bindings.get(bIndex)) {
            res.setBinding(bs);
        }
        return res;
    }
}

