/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerInstantiator;
import org.eclipse.ecf.provider.xmpp.XMPPSContainer;

public class XMPPSContainerInstantiator
extends XMPPContainerInstantiator {
    private static final String XMPPS_CONFIG = "ecf.xmpps.smack";

    public IContainer createInstance(ContainerTypeDescription description, Object[] args) throws ContainerCreateException {
        try {
            Integer ka = 30000;
            String name = null;
            if (args != null && args.length > 0) {
                name = (String)args[0];
                if (args.length > 1) {
                    ka = this.getIntegerFromArg(args[1]);
                }
            }
            if (name == null) {
                if (ka == null) {
                    return new XMPPSContainer();
                }
                return new XMPPSContainer(ka);
            }
            if (ka == null) {
                ka = 30000;
            }
            return new XMPPSContainer(name, (int)ka);
        }
        catch (Exception e) {
            throw new ContainerCreateException("Exception creating generic container", (Throwable)e);
        }
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        List<String> supportedConfigs = Arrays.asList(exporterSupportedConfigs);
        if (XMPPS_CONFIG.equals(description.getName()) && supportedConfigs.contains(XMPPS_CONFIG)) {
            results.add(XMPPS_CONFIG);
        }
        if (supportedConfigs.size() == 0) {
            return null;
        }
        return results.toArray(new String[0]);
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        return new String[]{XMPPS_CONFIG};
    }
}

