/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient45;

import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.protocol.HttpContext;

public class NTLMProxyDetector {
    private static final String PROXY_SPNEGO_VALUE = "NEGOTIATE";
    private static final String PROXY_NTLM_VALUE = "NTLM";

    public static boolean detectNTLMProxy(HttpContext context) {
        return NTLMProxyDetector.isProxyType(context, PROXY_NTLM_VALUE);
    }

    private static boolean isProxyType(HttpContext context, String scheme) {
        if (context == null) {
            return false;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.proxy-scope");
        if (authState == null) {
            return false;
        }
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        if (schemeName == null) {
            return false;
        }
        return schemeName.equalsIgnoreCase(scheme);
    }

    public static boolean detectSPNEGOProxy(HttpContext context) {
        return NTLMProxyDetector.isProxyType(context, PROXY_SPNEGO_VALUE);
    }
}

